/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.templater;

import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.templater.AbstractHtmlTemplater;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplater
extends AbstractHtmlTemplater {
    protected static final TemplateEngine FILEPATH_TEMPLATE_ENGINE = ThymeleafTemplater.initTemplateEngine((AbstractConfigurableTemplateResolver)new FileTemplateResolver());
    protected static final TemplateEngine CLASSPATH_TEMPLATE_ENGINE = ThymeleafTemplater.initTemplateEngine((AbstractConfigurableTemplateResolver)new ClassLoaderTemplateResolver());
    protected Locale locale = Locale.SIMPLIFIED_CHINESE;

    public ThymeleafTemplater(Document document) {
        super(document);
    }

    @Override
    protected void process(Writer writer) {
        Context context = new Context();
        context.setLocale(this.locale);
        context.setVariables(this.templateData);
        String template = String.join((CharSequence)"/", this.templatePath, this.templateName);
        if (Thread.currentThread().getContextClassLoader().getResource(template) == null) {
            FILEPATH_TEMPLATE_ENGINE.process(template, (IContext)context, writer);
        } else {
            CLASSPATH_TEMPLATE_ENGINE.process(template, (IContext)context, writer);
        }
    }

    protected static TemplateEngine initTemplateEngine(AbstractConfigurableTemplateResolver resolver) {
        TemplateEngine templateEngine = new TemplateEngine();
        resolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        resolver.setTemplateMode(TemplateMode.HTML);
        templateEngine.setTemplateResolver((ITemplateResolver)resolver);
        return templateEngine;
    }
}

