/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

class BidirectionalMultiMap<T1, T2> {
    private final HashMap<T1, List<T2>> mapT1ToT2s = new LinkedHashMap<T1, List<T2>>();
    private final HashMap<T2, List<T1>> mapT2ToT1s = new LinkedHashMap<T2, List<T1>>();

    BidirectionalMultiMap() {
    }

    void addValuePair(T1 ou, T2 og) {
        if (!this.mapT1ToT2s.containsKey(ou)) {
            this.mapT1ToT2s.put(ou, new ArrayList());
        }
        this.mapT1ToT2s.get(ou).add(og);
        if (!this.mapT2ToT1s.containsKey(og)) {
            this.mapT2ToT1s.put(og, new ArrayList());
        }
        this.mapT2ToT1s.get(og).add(ou);
    }

    List<T2> getT1ValuesForKey(T1 key) {
        return this.mapT1ToT2s.get(key);
    }

    List<T1> getT2ValuesForKey(T2 key) {
        return this.mapT2ToT1s.get(key);
    }

    HashMap<T1, List<T2>> getT1ToT2Map() {
        return this.mapT1ToT2s;
    }

    HashMap<T2, List<T1>> getT2ToT1Map() {
        return this.mapT2ToT1s;
    }

    boolean containsT1Key(T1 key) {
        return this.mapT1ToT2s.containsKey(key);
    }

    boolean containsT2Key(T2 key) {
        return this.mapT2ToT1s.containsKey(key);
    }

    int getT1Size() {
        return this.mapT1ToT2s.size();
    }

    int getT2Size() {
        return this.mapT2ToT1s.size();
    }

    boolean isT1Empty() {
        return this.mapT1ToT2s.isEmpty();
    }

    boolean isT2Empty() {
        return this.mapT2ToT1s.isEmpty();
    }
}

