/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.xref.NormalXReference;
import org.apache.pdfbox.pdfparser.xref.XReferenceEntry;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.pdfbox.support.linearization.BitWriter;
import org.dromara.pdf.pdfbox.support.linearization.HGeneric;
import org.dromara.pdf.pdfbox.support.linearization.HPageOffset;
import org.dromara.pdf.pdfbox.support.linearization.HSharedObject;
import org.dromara.pdf.pdfbox.support.linearization.LinearizedPDFWriter;
import org.dromara.pdf.pdfbox.support.linearization.PDFObjectQueue;
import org.dromara.pdf.pdfbox.support.linearization.SimplifiedPDFDocument;
import org.dromara.pdf.pdfbox.support.linearization.StructuredPDFInfo;
import org.dromara.pdf.pdfbox.support.linearization.WrittenObjectStore;

public class Linearizer {
    private final PDDocument document;

    public Linearizer(PDDocument doc) {
        SimplifiedPDFDocument simplified = new SimplifiedPDFDocument(doc.getDocument());
        this.document = new PDDocument(simplified);
    }

    public WrittenObjectStore linearize() {
        StructuredPDFInfo info = new StructuredPDFInfo(this.document.getDocument());
        info.getLinearizedParts();
        LinearizedPDFWriter writer = new LinearizedPDFWriter(this.document);
        LinearizationInformation offsets = new LinearizationInformation();
        WrittenObjectStore writtenStore = new WrittenObjectStore();
        COSDictionary firstTrailer = this.document.getDocument().getTrailer();
        COSDictionary secTrailer = new COSDictionary();
        PDFObjectQueue queue = new PDFObjectQueue();
        queue.setObjectID(info.sizeSecondPart());
        queue.enqueueDummy(PDFObjectQueue.PDFDummyObjects.LINDICT);
        queue.enqueueDummy(PDFObjectQueue.PDFDummyObjects.FIRSTXREF);
        queue.enqueuePart(info.part4);
        queue.enqueueDummy(PDFObjectQueue.PDFDummyObjects.HINTSTREAM);
        queue.enqueuePart(info.part6);
        offsets.firstTrailerSize = queue.getNextID();
        queue.resetObjectID();
        queue.enqueuePart(info.part7);
        queue.enqueuePart(info.part8);
        queue.enqueuePart(info.part9);
        queue.enqueueDummy(PDFObjectQueue.PDFDummyObjects.SECONDXREF);
        offsets.secondTrailerSize = queue.getNextID();
        try {
            COSObject linearizedDictObject = this.createLinearizedDictionary(queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.LINDICT).objNumber, writer);
            this.setObjectNumbers(queue, writer);
            secTrailer.setInt(COSName.SIZE, offsets.secondTrailerSize);
            firstTrailer.setInt(COSName.SIZE, offsets.firstTrailerSize);
            firstTrailer.setLong(COSName.PREV, Long.MAX_VALUE);
            writer.writeHeader();
            writer.doWriteObject((COSBase)linearizedDictObject);
            offsets.firstXrefOffset = writer.getPos();
            writer.doWriteXrefRangeDummy(this.document.getDocument(), offsets.getFirstXrefStart(), offsets.getFirstXrefLength(), firstTrailer, queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.FIRSTXREF).objNumber, 0L);
            offsets.firstXrefEnd = writtenStore.add(WrittenObjectStore.SpecialParts.PARTS_BEFORE_FIRST_XREF, writer.getAndResetParts());
            this.writeObjects(queue, writer, writtenStore, offsets, info);
            COSObject hintStreamObject = this.fillHintStream(info, offsets, queue, writer);
            writer.doWriteObject((COSBase)hintStreamObject);
            offsets.hintLength = writtenStore.add(WrittenObjectStore.SpecialParts.HINTSTREAM, writer.getAndResetParts());
            COSArray cosArray = ((COSDictionary)linearizedDictObject.getObject()).getCOSArray(COSName.H);
            cosArray.set(0, (COSBase)COSInteger.get((long)offsets.linDictOffset));
            cosArray.set(1, (COSBase)COSInteger.get((long)offsets.hintLength));
            List<XReferenceEntry> xrefentries = writer.retrieveXRefEntries();
            ArrayList<XReferenceEntry> xrefentries_first = new ArrayList<XReferenceEntry>();
            ArrayList<XReferenceEntry> xrefentries_sec = new ArrayList<XReferenceEntry>(queue.size());
            long cumulateLength = this.fillXRefEntries(xrefentries, xrefentries_first, xrefentries_sec, writtenStore, queue, info.getPart4EndMarker(), info.getPart6EndMarker());
            firstTrailer.setLong(COSName.PREV, cumulateLength);
            offsets.mainXrefOffset = cumulateLength;
            writer.doWriteXrefRange(this.document.getDocument(), offsets.getSecondXrefLength(), xrefentries_sec, secTrailer, queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.SECONDXREF).objNumber, offsets.firstXrefOffset, cumulateLength);
            COSDictionary linearizedDict = (COSDictionary)linearizedDictObject.getObject();
            linearizedDict.setLong(COSName.L, cumulateLength += writtenStore.add(WrittenObjectStore.SpecialParts.SECOND_XREF_PART, writer.getAndResetParts()));
            linearizedDict.setLong(COSName.O, (long)queue.get((COSBase)((COSBase)info.getPages().get((int)0))).objNumber);
            linearizedDict.setInt(COSName.N, info.getPages().size());
            linearizedDict.setLong(COSName.E, offsets.getEndFirstPage());
            linearizedDict.setLong(COSName.T, offsets.mainXrefOffset);
            writer.writeHeader();
            writer.removeWrittenObject((COSBase)linearizedDictObject);
            writer.doWriteObject((COSBase)linearizedDictObject);
            writer.fillUntilPos(offsets.firstXrefOffset);
            writer.doWriteXrefRange(this.document.getDocument(), offsets.getFirstXrefLength(), xrefentries_first, firstTrailer, queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.FIRSTXREF).objNumber, 0L, offsets.firstXrefOffset);
            writer.fillUntilPos(offsets.firstXrefEnd);
            writtenStore.add(WrittenObjectStore.SpecialParts.PARTS_BEFORE_FIRST_XREF, writer.getAndResetParts());
            return writtenStore;
        }
        catch (IOException ex) {
            throw new ArithmeticException(ex.toString());
        }
    }

    public void close() {
        if (this.document != null) {
            this.document.close();
        }
    }

    private COSObject fillHintStream(StructuredPDFInfo info, LinearizationInformation offsets, PDFObjectQueue queue, LinearizedPDFWriter writer) throws IOException {
        HPageOffset pageOffsetHints = HPageOffset.filledPageOffsetHints(info, queue, offsets.linDictOffset, info.getPages().size());
        HGeneric outlineHints = HGeneric.filledOutlineHints(info, queue, offsets);
        HSharedObject sharedObjectHints = HSharedObject.filledSharedObjectHints(info, queue, offsets.firstSharedOffset);
        COSObject hintStreamObject = this.createHintStream(queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.HINTSTREAM).objNumber, writer);
        COSStream cosstr = (COSStream)((Object)hintStreamObject.getObject());
        try (OutputStream output = cosstr.createOutputStream();){
            BitWriter w = new BitWriter(output);
            pageOffsetHints.writeHPageOffset(w);
            cosstr.setInt(COSName.S, w.getCount());
            sharedObjectHints.writeHSharedObject(w);
            if (outlineHints.nobjects > 0) {
                cosstr.setInt(COSName.O, w.getCount());
                outlineHints.writeHGeneric(w);
            }
        }
        return hintStreamObject;
    }

    private void setObjectNumbers(PDFObjectQueue queue, LinearizedPDFWriter writer) {
        for (Map.Entry<COSBase, PDFObjectQueue.ObjectMetaData> entry : queue.entrySet()) {
            writer.getObjectKeys().put(entry.getKey(), new COSObjectKey((long)entry.getValue().objNumber, 0));
            if (!(entry.getKey() instanceof COSObject)) continue;
            writer.getObjectKeys().put(((COSObject)entry.getKey()).getObject(), new COSObjectKey((long)entry.getValue().objNumber, 0));
        }
    }

    private long fillXRefEntries(List<XReferenceEntry> xrefentries, List<XReferenceEntry> xrefentries_first, List<XReferenceEntry> xrefentries_sec, WrittenObjectStore objParts, PDFObjectQueue queue, COSBase part4_end_marker, COSBase part6_end_marker) {
        xrefentries.sort(LinearizedPDFWriter.XREFCOMP);
        List<XReferenceEntry> xrefentries_write = xrefentries_first;
        xrefentries_first.add(this.getObjectXrefEntryBinary(xrefentries, queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.LINDICT).objNumber));
        long cumulateLength = objParts.getLength(WrittenObjectStore.SpecialParts.PARTS_BEFORE_FIRST_XREF);
        for (Map.Entry<COSBase, PDFObjectQueue.ObjectMetaData> entry : queue.entrySet()) {
            COSBase obj = entry.getKey();
            PDFObjectQueue.ObjectMetaData objData = entry.getValue();
            long beginObject = cumulateLength;
            cumulateLength += objData.objLength;
            XReferenceEntry xrefentry = this.getObjectXrefEntryBinary(xrefentries, objData.objNumber);
            ((NormalXReference)xrefentry).setOffset(beginObject);
            xrefentries_write.add(xrefentry);
            if (part4_end_marker == obj) {
                beginObject = cumulateLength;
                cumulateLength += objParts.getLength(WrittenObjectStore.SpecialParts.HINTSTREAM);
                xrefentry = this.getObjectXrefEntryBinary(xrefentries, queue.get((PDFObjectQueue.PDFDummyObjects)PDFObjectQueue.PDFDummyObjects.HINTSTREAM).objNumber);
                ((NormalXReference)xrefentry).setOffset(beginObject);
                xrefentries_write.add(xrefentry);
                continue;
            }
            if (part6_end_marker != obj) continue;
            xrefentries_write = xrefentries_sec;
        }
        return cumulateLength;
    }

    private void writeObjects(PDFObjectQueue queue, LinearizedPDFWriter writer, WrittenObjectStore objParts, LinearizationInformation offsets, StructuredPDFInfo info) throws IOException {
        long outlineCount = 0L;
        long cumulateLength = offsets.firstXrefEnd;
        COSBase part4EndMarker = info.getPart4EndMarker();
        COSBase part6EndMarker = info.getPart6EndMarker();
        for (Map.Entry<COSBase, PDFObjectQueue.ObjectMetaData> entry : queue.entrySet()) {
            long objLength;
            COSBase obj = entry.getKey();
            PDFObjectQueue.ObjectMetaData objData = entry.getValue();
            objData.objLength = objLength = writer.doWriteObjectInSequence(obj);
            cumulateLength += objLength;
            if (outlineCount-- > 0L) {
                offsets.outlineLength += objLength;
            }
            if (part4EndMarker == obj) {
                objParts.add(WrittenObjectStore.SpecialParts.FIRST_PART_OBJECTS, writer.getAndResetParts());
                offsets.linDictOffset = cumulateLength;
                continue;
            }
            if (part6EndMarker == obj) {
                offsets.part6EndOffset = cumulateLength;
                continue;
            }
            if (info.outlineData.first_object != null && info.outlineData.first_object == (COSObject)obj) {
                offsets.firstObjectOffset = cumulateLength - objLength;
                outlineCount = info.outlineData.nobjects - 1;
                offsets.outlineLength = objLength;
                continue;
            }
            if (info.sharedObjectData.first_shared_obj == null || info.sharedObjectData.first_shared_obj != (COSObject)obj) continue;
            offsets.firstSharedOffset = cumulateLength - objLength;
        }
        objParts.add(WrittenObjectStore.SpecialParts.SECOND_PART_OBJECTS, writer.getAndResetParts());
    }

    private XReferenceEntry getObjectXrefEntryBinary(List<XReferenceEntry> xrefentries, long objNr) {
        int mid;
        XReferenceEntry midEntry;
        int start = 0;
        int end = xrefentries.size() - 1;
        while (start <= end && (midEntry = xrefentries.get(mid = (start + end) / 2)) != null) {
            long midNum = midEntry.getReferencedKey().getNumber();
            if (midNum == objNr) {
                return midEntry;
            }
            if (midNum < objNr) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        throw new ArithmeticException("No Xref-entry found for object number " + objNr);
    }

    private COSObject createLinearizedDictionary(int lindict_id, LinearizedPDFWriter writer) throws IOException {
        COSObject linearizedDictionary = this.createDummyLinearizedDictionary();
        linearizedDictionary.setKey(new COSObjectKey((long)lindict_id, 0));
        writer.getObjectKeys().put((COSBase)linearizedDictionary, new COSObjectKey((long)lindict_id, 0));
        writer.getObjectKeys().put(linearizedDictionary.getObject(), new COSObjectKey((long)lindict_id, 0));
        return linearizedDictionary;
    }

    private COSObject createHintStream(int hint_id, LinearizedPDFWriter writer) throws IOException {
        COSStream hintStream = new COSStream();
        COSObject hintStreamObject = new COSObject((COSBase)((Object)hintStream));
        hintStream.setItem(COSName.FILTER, (COSBase)COSName.FLATE_DECODE);
        hintStreamObject.setKey(new COSObjectKey((long)hint_id, 0));
        writer.getObjectKeys().put((COSBase)hintStreamObject, new COSObjectKey((long)hint_id, 0));
        writer.getObjectKeys().put((COSBase)((Object)hintStream), new COSObjectKey((long)hint_id, 0));
        return hintStreamObject;
    }

    private COSObject createDummyLinearizedDictionary() throws IOException {
        long DUMMY_MAX_VALUE_LONG = Long.MAX_VALUE;
        int DUMMY_MAX_VALUE_INT = Integer.MAX_VALUE;
        COSDictionary linDict = new COSDictionary();
        linDict.setInt(COSName.getPDFName((String)"Linearized"), 1);
        linDict.setLong(COSName.L, Long.MAX_VALUE);
        COSArray linDictH = new COSArray();
        linDictH.add((COSBase)COSInteger.get((long)Integer.MAX_VALUE));
        linDictH.add((COSBase)COSInteger.get((long)Integer.MAX_VALUE));
        linDict.setItem(COSName.H, (COSBase)linDictH);
        linDict.setInt(COSName.O, Integer.MAX_VALUE);
        linDict.setLong(COSName.E, Long.MAX_VALUE);
        linDict.setInt(COSName.N, Integer.MAX_VALUE);
        linDict.setLong(COSName.T, Long.MAX_VALUE);
        COSObject retVal = new COSObject((COSBase)linDict);
        retVal.setKey(new COSObjectKey(Long.MAX_VALUE, 0));
        return retVal;
    }

    class LinearizationInformation {
        long firstObjectOffset = 0L;
        long outlineLength = 0L;
        long linDictOffset = 0L;
        long firstXrefOffset;
        long firstSharedOffset = 0L;
        long part6EndOffset = 0L;
        long mainXrefOffset = 0L;
        long firstXrefEnd = 0L;
        long hintLength = 0L;
        int firstTrailerSize = 0;
        int secondTrailerSize = 0;

        LinearizationInformation() {
        }

        long getEndFirstPage() {
            return this.hintLength + this.part6EndOffset;
        }

        int getFirstXrefStart() {
            return this.secondTrailerSize;
        }

        int getFirstXrefLength() {
            return this.firstTrailerSize - this.secondTrailerSize;
        }

        int getSecondXrefLength() {
            return this.secondTrailerSize - 1;
        }
    }
}

