/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.dromara.pdf.pdfbox.support.linearization.BidirectionalMap;
import org.dromara.pdf.pdfbox.support.linearization.BidirectionalMultiMap;
import org.dromara.pdf.pdfbox.support.linearization.CHPageOffset;
import org.dromara.pdf.pdfbox.support.linearization.CHSharedObject;
import org.dromara.pdf.pdfbox.support.linearization.HGeneric;
import org.dromara.pdf.pdfbox.support.linearization.ObjUser;
import org.dromara.pdf.pdfbox.support.linearization.PreLinearizationOptimizer;

class StructuredPDFInfo {
    final List<COSBase> part4 = new ArrayList<COSBase>();
    final List<COSBase> part6 = new ArrayList<COSBase>();
    final List<COSBase> part7 = new ArrayList<COSBase>();
    final List<COSBase> part8 = new ArrayList<COSBase>();
    final List<COSBase> part9 = new ArrayList<COSBase>();
    final CHSharedObject sharedObjectData = new CHSharedObject();
    final HGeneric outlineData = new HGeneric();
    final BidirectionalMap<Integer, COSBase> indexObjectMap = new BidirectionalMap();
    private final COSDocument document;
    private final List<COSObject> pages;
    CHPageOffset pageOffsetData;
    BidirectionalMultiMap<ObjUser, COSBase> userObjectMap;

    StructuredPDFInfo(COSDocument doc) {
        this.document = doc;
        this.pages = new ArrayList<COSObject>();
    }

    int sizeSecondPart() {
        return this.part7.size() + this.part8.size() + this.part9.size() + 2;
    }

    COSBase getPart4EndMarker() {
        return this.part4.get(this.part4.size() - 1);
    }

    COSBase getPart6EndMarker() {
        return this.part6.get(this.part6.size() - 1);
    }

    List<COSObject> getPages() {
        return this.pages;
    }

    void getLinearizedParts() throws IOException {
        COSObject root = (COSObject)this.document.getTrailer().getItem(COSName.ROOT);
        boolean outlines_in_first_page = false;
        COSBase pagemode = ((COSDictionary)root.getObject()).getDictionaryObject(COSName.PAGE_MODE);
        if (pagemode instanceof COSName && ((COSName)pagemode).getName().equalsIgnoreCase("/UseOutlines") && ((COSDictionary)root.getObject()).getDictionaryObject(COSName.OUTLINES) != null) {
            outlines_in_first_page = true;
        }
        ArrayList<COSName> open_document_keys = new ArrayList<COSName>();
        open_document_keys.add(COSName.VIEWER_PREFERENCES);
        open_document_keys.add(COSName.PAGE_MODE);
        open_document_keys.add(COSName.THREADS);
        open_document_keys.add(COSName.OPEN_ACTION);
        open_document_keys.add(COSName.ACRO_FORM);
        PreLinearizationOptimizer optimizer = new PreLinearizationOptimizer(this.document);
        this.userObjectMap = optimizer.optimize(this.pages);
        ArrayList<COSBase> lc_open_document = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_first_page_private = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_first_page_shared = new ArrayList<COSBase>();
        HashSet<COSBase> lc_other_page_private = new HashSet<COSBase>();
        ArrayList<COSBase> lc_other_page_shared = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_thumbnail_private = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_thumbnail_shared = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_other = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_outlines = new ArrayList<COSBase>();
        ArrayList<COSBase> lc_root = new ArrayList<COSBase>();
        this.traverseElements(open_document_keys, lc_root, lc_outlines, lc_open_document, lc_first_page_private, lc_first_page_shared, lc_other_page_private, lc_other_page_shared, lc_thumbnail_private, lc_thumbnail_shared, lc_other);
        this.initData(lc_root, lc_open_document);
        this.processPart6(lc_first_page_private, lc_first_page_shared, outlines_in_first_page, lc_outlines);
        this.processPart7(lc_other_page_private);
        this.processPart8(lc_other_page_shared);
        this.processPart9(lc_other, lc_thumbnail_private, lc_thumbnail_shared, outlines_in_first_page, lc_outlines);
        this.gatherSharedHintTable();
    }

    private void initData(ArrayList<COSBase> lc_root, List<COSBase> lc_open_document) throws ArithmeticException {
        this.pageOffsetData = new CHPageOffset(this.pages.size());
        if (lc_root.size() != 1) {
            throw new ArithmeticException("calculateLinearizationData: too many roots");
        }
        this.part4.add(lc_root.get(0));
        lc_open_document.forEach(obj -> this.part4.add((COSBase)obj));
    }

    private void gatherSharedHintTable() throws ArithmeticException {
        this.sharedObjectData.nshared_first_page = this.part6.size();
        this.sharedObjectData.nshared_total = this.sharedObjectData.nshared_first_page + this.part8.size();
        this.part6.forEach(iterpart6 -> {
            this.indexObjectMap.putValuePair(this.sharedObjectData.entries.size(), (COSBase)iterpart6);
            this.sharedObjectData.entries.add((COSBase)iterpart6);
        });
        if (!this.part8.isEmpty()) {
            this.sharedObjectData.first_shared_obj = this.part8.get(0);
            this.part8.forEach(iterpart8 -> {
                this.indexObjectMap.putValuePair(this.sharedObjectData.entries.size(), (COSBase)iterpart8);
                this.sharedObjectData.entries.add((COSBase)iterpart8);
            });
        }
        if (this.sharedObjectData.nshared_total != this.sharedObjectData.entries.size()) {
            throw new ArithmeticException("shared object hint table has wrong number of entries");
        }
        for (int i = 1; i < this.pages.size(); ++i) {
            CHPageOffset.CHPageOffsetEntry pe = this.pageOffsetData.entries.get(i);
            ObjUser ou = new ObjUser(ObjUser.user_e.ou_page, i);
            if (!this.userObjectMap.containsT1Key(ou)) {
                throw new ArithmeticException("keine page Object!");
            }
            List<COSBase> ogs = this.userObjectMap.getT1ValuesForKey(ou);
            for (COSBase iterogs : ogs) {
                if (this.userObjectMap.getT2ValuesForKey(iterogs).size() <= 1 || !this.indexObjectMap.containsT2Key(iterogs)) continue;
                int idx = this.indexObjectMap.getValueForT2(iterogs);
                ++pe.nshared_objects;
                pe.shared_identifiers.add(idx);
            }
        }
    }

    private void processPart9(List<COSBase> lc_other, List<COSBase> lc_thumbnail_private, List<COSBase> lc_thumbnail_shared, boolean outlines_in_first_page, List<COSBase> lc_outlines) throws ArithmeticException {
        List<COSBase> pages_ogs = this.userObjectMap.getT1ValuesForKey(new ObjUser(ObjUser.user_e.ou_root_key, COSName.PAGES));
        if (pages_ogs.isEmpty()) {
            throw new ArithmeticException("calculateLinearizationData: pages_ogs is empty");
        }
        pages_ogs.forEach(pages_ogsiter -> {
            if (lc_other.contains(pages_ogsiter)) {
                lc_other.remove(pages_ogsiter);
                this.part9.add((COSBase)pages_ogsiter);
            }
        });
        for (int i = 0; i < this.pages.size(); ++i) {
            COSBase thumb = ((COSDictionary)this.pages.get(i).getObject()).getDictionaryObject(COSName.THUMB);
            if (thumb == null) continue;
            COSBase thumb_og = thumb;
            if (lc_thumbnail_private.contains(thumb_og)) {
                lc_thumbnail_private.remove(thumb_og);
                this.part9.add(thumb);
            }
            List<COSBase> ogs = this.userObjectMap.getT1ValuesForKey(new ObjUser(ObjUser.user_e.ou_thumb, i));
            ogs.forEach(iterogs -> {
                if (lc_thumbnail_private.contains(iterogs)) {
                    lc_thumbnail_private.remove(iterogs);
                    this.part9.add((COSBase)iterogs);
                }
            });
        }
        if (!lc_thumbnail_private.isEmpty()) {
            throw new ArithmeticException("calculateLinearizationData: lc_thumbnail_private - not empty after placing thumbnails");
        }
        lc_thumbnail_shared.forEach(iterthumshar -> this.part9.add((COSBase)iterthumshar));
        if (!outlines_in_first_page) {
            this.pushOutlinesToPart(this.part9, lc_outlines);
        }
        lc_other.forEach(iterother -> this.part9.add((COSBase)iterother));
        int num_placed = this.part4.size() + this.part6.size() + this.part7.size() + this.part8.size() + this.part9.size();
        int num_wanted = this.userObjectMap.getT2Size();
        if (num_placed != num_wanted) {
            throw new ArithmeticException("calculateLinearizationData: wrong number of objects placed (num_placed = " + num_placed + "; number of objects: " + num_wanted);
        }
    }

    private void processPart8(List<COSBase> lc_other_page_shared) {
        lc_other_page_shared.forEach(itershared -> this.part8.add((COSBase)itershared));
    }

    private void processPart7(Set<COSBase> lc_other_page_private) throws ArithmeticException {
        for (int i = 1; i < this.pages.size(); ++i) {
            COSBase page_og = (COSBase)this.pages.get(i);
            if (!lc_other_page_private.contains(page_og)) {
                throw new ArithmeticException("calculateLinearizationData: page object for page " + i + " - object not in lc_first_page_private");
            }
            lc_other_page_private.remove(page_og);
            this.part7.add(page_og);
            this.pageOffsetData.entries.get((int)i).nobjects = 1;
            ObjUser ou = new ObjUser(ObjUser.user_e.ou_page, i);
            if (!this.userObjectMap.containsT1Key(ou)) {
                throw new ArithmeticException("calculateLinearizationData: no user data for page " + i);
            }
            List<COSBase> ogs = this.userObjectMap.getT1ValuesForKey(ou);
            for (COSBase ogpage : ogs) {
                if (!lc_other_page_private.remove(ogpage)) continue;
                this.part7.add(ogpage);
                ++this.pageOffsetData.entries.get((int)i).nobjects;
            }
        }
        if (!lc_other_page_private.isEmpty()) {
            throw new ArithmeticException("calculateLinearizationData: lc_other_page_private is not empty after generation of part7");
        }
    }

    private void processPart6(List<COSBase> lc_first_page_private, List<COSBase> lc_first_page_shared, boolean outlines_in_first_page, List<COSBase> lc_outlines) throws ArithmeticException {
        COSBase first_page_og = (COSBase)this.pages.get(0);
        if (!lc_first_page_private.contains(first_page_og)) {
            throw new ArithmeticException("calculateLinearizationData: first page - object not in lc_first_page_private");
        }
        lc_first_page_private.remove(first_page_og);
        this.part6.add(first_page_og);
        lc_first_page_private.forEach(page -> this.part6.add((COSBase)page));
        lc_first_page_shared.forEach(page -> this.part6.add((COSBase)page));
        if (outlines_in_first_page) {
            this.pushOutlinesToPart(this.part6, lc_outlines);
        }
        this.pageOffsetData.entries.get((int)0).nobjects = this.part6.size();
    }

    private void traverseElements(List<COSName> open_document_keys, ArrayList<COSBase> lc_root, List<COSBase> lc_outlines, List<COSBase> lc_open_document, List<COSBase> lc_first_page_private, List<COSBase> lc_first_page_shared, Set<COSBase> lc_other_page_private, List<COSBase> lc_other_page_shared, List<COSBase> lc_thumbnail_private, List<COSBase> lc_thumbnail_shared, List<COSBase> lc_other) throws ArithmeticException {
        for (Map.Entry<COSBase, List<ObjUser>> entry : this.userObjectMap.getT2ToT1Map().entrySet()) {
            COSBase og = entry.getKey();
            List<ObjUser> ous = entry.getValue();
            boolean in_open_document = false;
            boolean in_first_page = false;
            int other_pages = 0;
            int thumbs = 0;
            int others = 0;
            boolean in_outlines = false;
            boolean is_root = false;
            for (ObjUser ou : ous) {
                switch (ou.ou_type) {
                    case ou_trailer_key: {
                        break;
                    }
                    case ou_thumb: {
                        ++thumbs;
                        break;
                    }
                    case ou_root_key: {
                        if (open_document_keys.contains(ou.key)) {
                            in_open_document = true;
                            break;
                        }
                        if (ou.key == COSName.OUTLINES) {
                            in_outlines = true;
                            break;
                        }
                        ++others;
                        break;
                    }
                    case ou_page: {
                        if (ou.pageno == 0) {
                            in_first_page = true;
                            break;
                        }
                        ++other_pages;
                        break;
                    }
                    case ou_root: {
                        is_root = true;
                        break;
                    }
                    case ou_bad: {
                        throw new ArithmeticException("INTERNAL ERROR: calculateLinearizationData: - invalid user type");
                    }
                }
            }
            if (is_root) {
                lc_root.add(og);
                continue;
            }
            if (in_outlines) {
                lc_outlines.add(og);
                continue;
            }
            if (in_open_document) {
                lc_open_document.add(og);
                continue;
            }
            if (in_first_page && others == 0 && other_pages == 0 && thumbs == 0) {
                lc_first_page_private.add(og);
                continue;
            }
            if (in_first_page) {
                lc_first_page_shared.add(og);
                continue;
            }
            if (other_pages == 1 && others == 0 && thumbs == 0) {
                lc_other_page_private.add(og);
                continue;
            }
            if (other_pages > 1) {
                lc_other_page_shared.add(og);
                continue;
            }
            if (thumbs == 1 && others == 0) {
                lc_thumbnail_private.add(og);
                continue;
            }
            if (thumbs > 1) {
                lc_thumbnail_shared.add(og);
                continue;
            }
            lc_other.add(og);
        }
    }

    private void pushOutlinesToPart(List<COSBase> part, List<COSBase> lc_outlines) {
        COSObject root = (COSObject)this.document.getTrailer().getItem(COSName.ROOT);
        COSObject outlines = (COSObject)((COSDictionary)root.getObject()).getItem(COSName.OUTLINES);
        if (outlines == null) {
            return;
        }
        this.outlineData.first_object = outlines;
        this.outlineData.nobjects = 1;
        lc_outlines.remove(outlines);
        part.add((COSBase)outlines);
        for (COSBase iter : lc_outlines) {
            part.add(iter);
            ++this.outlineData.nobjects;
        }
    }
}

