/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class VirtualPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String reference;
    final long refBeginPos;
    final int referenceLength;
    final byte[] hardPart;
    long outBeginPos;
    private byte[] _referenceBytes = null;

    public VirtualPart(byte[] hardPart) {
        this.reference = null;
        this.refBeginPos = -1L;
        this.outBeginPos = -1L;
        this.referenceLength = -1;
        this.hardPart = hardPart;
    }

    VirtualPart(byte[] hardPart, long outBeginPos) {
        this.reference = null;
        this.outBeginPos = outBeginPos;
        this.refBeginPos = -1L;
        this.referenceLength = -1;
        this.hardPart = hardPart;
    }

    public VirtualPart(String reference, long referenceBeginPosition, int referenceLength) {
        this.reference = reference;
        this.refBeginPos = referenceBeginPosition;
        this.referenceLength = referenceLength;
        this.hardPart = null;
        this.outBeginPos = -1L;
    }

    VirtualPart(String reference, long referenceBeginPosition, int referenceLength, long outBeginPos) {
        this.reference = reference;
        this.refBeginPos = referenceBeginPosition;
        this.referenceLength = referenceLength;
        this.hardPart = null;
        this.outBeginPos = outBeginPos;
    }

    public static long calculateInflatedLength(List<VirtualPart> parts) {
        long length = 0L;
        for (VirtualPart entry : parts) {
            length += (long)entry.getInflatedLength();
        }
        return length;
    }

    static long calculateDeflatedLength(List<VirtualPart> parts) {
        long length = 0L;
        for (VirtualPart entry : parts) {
            length += (long)entry.getDeflatedLength();
        }
        return length;
    }

    boolean isReference() {
        return this.reference != null;
    }

    byte[] getReferenceBytes() {
        if (this._referenceBytes == null) {
            this._referenceBytes = this.reference.getBytes(StandardCharsets.UTF_8);
        }
        return this._referenceBytes;
    }

    public int getInflatedLength() {
        if (this.isReference()) {
            return this.referenceLength;
        }
        return this.hardPart.length;
    }

    public void setOutBeginPos(long offset) {
        this.outBeginPos = offset;
    }

    int getDeflatedLength() {
        if (this.isReference()) {
            return 17 + this.getReferenceBytes().length;
        }
        return this.hardPart.length + 1 + 4;
    }

    long getRefEndPos() {
        assert (this.refBeginPos >= 0L) : "RefBeginPos of VirtualPart < 0";
        return this.refBeginPos + (long)this.getInflatedLength();
    }

    long getOutEndPos() {
        assert (this.outBeginPos >= 0L) : "OutBeginPos of VirtualPart < 0";
        return this.outBeginPos + (long)this.getInflatedLength();
    }
}

