/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearization;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.List;
import org.dromara.pdf.pdfbox.support.linearization.VirtualPart;

public class WrittenObjectStore {
    public static final int EOF = -1;
    private final EnumMap<SpecialParts, List<VirtualPart>> specialParts = new EnumMap(SpecialParts.class);

    public static void writePartsToOutputStream(List<VirtualPart> objParts, OutputStream fos) throws IOException {
        for (VirtualPart part : objParts) {
            if (part.isReference()) {
                FileInputStream fis = new FileInputStream(part.reference);
                Throwable throwable = null;
                try {
                    WrittenObjectStore.copyLarge(fis, fos, part.refBeginPos, part.referenceLength);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                    continue;
                }
            }
            fos.write(part.hardPart);
        }
    }

    public static long copyLarge(InputStream input, OutputStream output, long inputOffset, long length) throws IOException {
        int read;
        int bufferLength;
        if (inputOffset > 0L) {
            input.skip(inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[16384];
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    public void write(OutputStream dest) {
        WrittenObjectStore.writePartsToOutputStream(this.get(SpecialParts.PARTS_BEFORE_FIRST_XREF), dest);
        WrittenObjectStore.writePartsToOutputStream(this.get(SpecialParts.FIRST_PART_OBJECTS), dest);
        WrittenObjectStore.writePartsToOutputStream(this.get(SpecialParts.HINTSTREAM), dest);
        WrittenObjectStore.writePartsToOutputStream(this.get(SpecialParts.SECOND_PART_OBJECTS), dest);
        WrittenObjectStore.writePartsToOutputStream(this.get(SpecialParts.SECOND_XREF_PART), dest);
    }

    long add(SpecialParts key, List<VirtualPart> objects) {
        this.specialParts.put(key, objects);
        return VirtualPart.calculateInflatedLength(objects);
    }

    long getLength(SpecialParts key) {
        return VirtualPart.calculateInflatedLength(this.specialParts.get((Object)key));
    }

    List<VirtualPart> get(SpecialParts key) {
        return this.specialParts.get((Object)key);
    }

    public static enum SpecialParts {
        PARTS_BEFORE_FIRST_XREF,
        HINTSTREAM,
        SECOND_XREF_PART,
        FIRST_PART_OBJECTS,
        SECOND_PART_OBJECTS,
        PART_4_END_MARKER;

    }
}

