/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.support.Constants;

public class BorderUtil {
    public static void drawSolidLine(PDPageContentStream stream, Color color, float beginX, float beginY, float endX, float endY) {
        stream.setStrokingColor(color);
        stream.moveTo(beginX, beginY);
        stream.lineTo(endX, endY);
    }

    public static void drawDottedLine(PDPageContentStream stream, Color color, float dottedLength, float dottedSpacing, float beginX, float beginY, float endX, float endY) {
        boolean isHorizontal;
        stream.setStrokingColor(color);
        float totalLength = endX - beginX;
        boolean bl = isHorizontal = totalLength > 0.0f;
        if (!isHorizontal) {
            totalLength = beginY - endY;
        }
        float lineWidth = dottedLength + dottedSpacing;
        int count = Math.max((int)(totalLength / lineWidth), 1);
        float offset = Math.abs((totalLength - (float)count * lineWidth + dottedSpacing) / 2.0f);
        if (dottedLength > totalLength) {
            dottedLength = totalLength;
            offset = 0.0f;
        }
        if (isHorizontal) {
            beginX += offset;
        } else {
            beginY -= offset;
        }
        for (int i = 0; i < count; ++i) {
            stream.moveTo(beginX, beginY);
            if (isHorizontal) {
                stream.lineTo(beginX += dottedLength, beginY);
                beginX += dottedSpacing;
                continue;
            }
            stream.lineTo(beginX, beginY -= dottedLength);
            beginY = beginY - dottedLength - dottedSpacing;
        }
    }

    public static void drawBorderWithData(BorderData data, PDRectangle rectangle, Color backgroundColor) {
        Context context = data.getContext();
        PDPageContentStream stream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), data.getContentMode().getMode(), true, data.getIsResetContentStream());
        BorderUtil.drawNormalBorder(stream, rectangle, data, backgroundColor);
        stream.closePath();
        stream.fillAndStroke();
        stream.close();
    }

    public static void drawNormalBorder(PDPageContentStream stream, PDRectangle rectangle, BorderData data, Color backgroundColor) {
        stream.setLineWidth(data.getBorderLineWidth().floatValue());
        stream.setLineCapStyle(data.getBorderLineCapStyle().getType());
        stream.setNonStrokingColor(backgroundColor);
        BorderUtil.line(stream, rectangle, data);
    }

    public static List<Position> getCircleDataPositions(float radius, float beginX, float beginY) {
        float x = beginX + radius;
        float y = beginY + radius;
        ArrayList<Position> list = new ArrayList<Position>(4);
        list.add(new Position(Float.valueOf(x), Float.valueOf(y + radius)));
        list.add(new Position(Float.valueOf(x + radius), Float.valueOf(y)));
        list.add(new Position(Float.valueOf(x), Float.valueOf(y - radius)));
        list.add(new Position(Float.valueOf(x - radius), Float.valueOf(y)));
        return list;
    }

    public static List<Position> getCircleCtrlPositions(float radius, List<Position> dataPositions) {
        float offset = radius * 0.55191505f;
        ArrayList<Position> points = new ArrayList<Position>(8);
        Position top = dataPositions.get(0);
        points.add(new Position(Float.valueOf(top.getX().floatValue() + offset), top.getY()));
        Position right = dataPositions.get(1);
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() + offset)));
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() - offset)));
        Position bottom = dataPositions.get(2);
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() + offset), bottom.getY()));
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() - offset), bottom.getY()));
        Position left = dataPositions.get(3);
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() - offset)));
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() + offset)));
        points.add(new Position(Float.valueOf(top.getX().floatValue() - offset), top.getY()));
        return points;
    }

    private static void line(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        switch (data.getBorderLineStyle()) {
            case SOLID: {
                BorderUtil.drawSolidLine(stream, rectangle, data);
                break;
            }
            case DOTTED: {
                BorderUtil.drawDottedLine(stream, rectangle, data);
            }
        }
    }

    private static void drawSolidLine(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        boolean isRound;
        float offset = 0.0f;
        boolean bl = isRound = data.getBorderLineCapStyle() == LineCapStyle.ROUND && data.getBorderRadius().floatValue() > 0.0f;
        if (isRound) {
            offset = data.getBorderRadius().floatValue() * Constants.BEZIER_COEF.floatValue();
        }
        stream.moveTo(rectangle.getLowerLeftX() + data.getBorderRadius().floatValue(), rectangle.getUpperRightY());
        if (data.getIsBorderTop().booleanValue()) {
            if (isRound) {
                stream.setStrokingColor(data.getBorderTopColor());
                stream.lineTo(rectangle.getUpperRightX() - data.getBorderRadius().floatValue(), rectangle.getUpperRightY());
            } else {
                stream.setStrokingColor(data.getBorderTopColor());
                stream.lineTo(rectangle.getUpperRightX(), rectangle.getUpperRightY());
            }
        }
        if (data.getIsBorderRight().booleanValue()) {
            if (isRound) {
                BorderUtil.drawArcForRightTop(stream, data.getBorderRadius().floatValue(), offset, rectangle.getUpperRightX() - data.getBorderRadius().floatValue(), rectangle.getUpperRightY());
                stream.setStrokingColor(data.getBorderRightColor());
                stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY() + data.getBorderRadius().floatValue());
                BorderUtil.drawArcForRightBottom(stream, data.getBorderRadius().floatValue(), offset, rectangle.getUpperRightX(), rectangle.getLowerLeftY() + data.getBorderRadius().floatValue());
            } else {
                stream.setStrokingColor(data.getBorderRightColor());
                stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            }
        }
        if (data.getIsBorderBottom().booleanValue()) {
            if (isRound) {
                stream.setStrokingColor(data.getBorderBottomColor());
                stream.lineTo(rectangle.getLowerLeftX() + data.getBorderRadius().floatValue(), rectangle.getLowerLeftY());
            } else {
                stream.setStrokingColor(data.getBorderBottomColor());
                stream.lineTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            }
        }
        if (data.getIsBorderLeft().booleanValue()) {
            if (isRound) {
                BorderUtil.drawArcForLeftBottom(stream, data.getBorderRadius().floatValue(), offset, rectangle.getLowerLeftX() + data.getBorderRadius().floatValue(), rectangle.getLowerLeftY());
                stream.setStrokingColor(data.getBorderLeftColor());
                stream.lineTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY() - data.getBorderRadius().floatValue());
                BorderUtil.drawArcForLeftTop(stream, data.getBorderRadius().floatValue(), offset, rectangle.getLowerLeftX(), rectangle.getUpperRightY() - data.getBorderRadius().floatValue());
            } else {
                stream.setStrokingColor(data.getBorderLeftColor());
                stream.lineTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY());
            }
        }
    }

    private static void drawDottedLine(PDPageContentStream stream, PDRectangle rectangle, BorderData data) {
        if (data.getIsBorderTop().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderTopColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getUpperRightY());
        }
        if (data.getIsBorderBottom().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderBottomColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
        if (data.getIsBorderLeft().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderLeftColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        }
        if (data.getIsBorderRight().booleanValue()) {
            BorderUtil.drawDottedLine(stream, data.getBorderRightColor(), data.getBorderLineWidth().floatValue(), data.getBorderDottedSpacing().floatValue(), rectangle.getUpperRightX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
    }

    private static void drawArcForRightTop(PDPageContentStream stream, float radius, float offset, float beginX, float beginY) {
        stream.curveTo(beginX + offset, beginY, beginX + radius, beginY - radius + offset, beginX + radius, beginY - radius);
    }

    private static void drawArcForRightBottom(PDPageContentStream stream, float radius, float offset, float beginX, float beginY) {
        stream.curveTo(beginX, beginY - offset, beginX - radius + offset, beginY - radius, beginX - radius, beginY - radius);
    }

    private static void drawArcForLeftTop(PDPageContentStream stream, float radius, float offset, float beginX, float beginY) {
        stream.curveTo(beginX, beginY + offset, beginX + radius - offset, beginY + radius, beginX + radius, beginY + radius);
    }

    private static void drawArcForLeftBottom(PDPageContentStream stream, float radius, float offset, float beginX, float beginY) {
        stream.curveTo(beginX - offset, beginY, beginX - radius, beginY + radius - offset, beginX - radius, beginY + radius);
    }
}

