/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.support.image.J2kImageHandler;
import org.dromara.pdf.pdfbox.util.CommonUtil;
import org.dromara.pdf.pdfbox.util.RenderingHintUtil;

public class ImageUtil {
    protected static final byte[] SVG_BYTES1 = new byte[]{60, 63, 120, 109, 108, 32};
    protected static final byte[] SVG_BYTES2 = new byte[]{60, 115, 118, 103};
    protected static final byte[] J2K_BYTES2 = new byte[]{0, 0, 0, 12, 106, 80, 32, 32};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(File imageFile) {
        Objects.requireNonNull(imageFile, "the image file can not be null");
        try (InputStream inputStream = Files.newInputStream(imageFile.toPath(), new OpenOption[0]);){
            BufferedImage bufferedImage = ImageUtil.read(inputStream);
            return bufferedImage;
        }
    }

    public static BufferedImage read(InputStream imageStream) {
        return ImageUtil.read(CommonUtil.toBytes(imageStream));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(byte[] bytes) {
        Objects.requireNonNull(bytes, "the image bytes can not be null");
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(ImageUtil.resetBytes(bytes)));){
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
    }

    public static void write(BufferedImage image, File file) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            ImageUtil.write(image, outputStream);
        }
    }

    public static void write(BufferedImage image, OutputStream outputStream) {
        ImageIOUtil.writeImage((BufferedImage)image, (String)ImageType.PNG.name(), (OutputStream)outputStream);
    }

    public static BufferedImage scale(BufferedImage sourceImage, int width, int height, int scaleMode) {
        Objects.requireNonNull(sourceImage, "the source image can not be null");
        Image temp = sourceImage.getScaledInstance(width, height, scaleMode);
        BufferedImage image = new BufferedImage(width, height, sourceImage.getType());
        Graphics2D graphics = ImageUtil.createGraphics(image);
        graphics.drawImage(temp, 0, 0, null);
        graphics.dispose();
        return image;
    }

    public static byte[] resetBytes(byte[] bytes) {
        byte[] byteArray;
        block52: {
            Objects.requireNonNull(bytes, "the bytes can not be null");
            byteArray = bytes;
            if (ImageUtil.isSvgImage(byteArray)) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));
                     ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
                    new PNGTranscoder().transcode(new TranscoderInput((InputStream)inputStream), new TranscoderOutput((OutputStream)outputStream));
                    byteArray = outputStream.toByteArray();
                    break block52;
                }
            }
            if (ImageUtil.isJ2kImage(byteArray)) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(bytes));
                     ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
                    J2kImageHandler.transcode(inputStream, outputStream, ImageType.PNG);
                    byteArray = outputStream.toByteArray();
                }
            }
        }
        return byteArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toBytes(BufferedImage sourceImage, String imageType) {
        Objects.requireNonNull(sourceImage, "the source image can not be null");
        Objects.requireNonNull(imageType, "the image type can not be null");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            ImageIOUtil.writeImage((BufferedImage)sourceImage, (String)imageType, (OutputStream)outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static String toBase64(BufferedImage sourceImage, String imageType) {
        Objects.requireNonNull(sourceImage, "the source image can not be null");
        Objects.requireNonNull(imageType, "the image type can not be null");
        return Base64.getEncoder().encodeToString(ImageUtil.toBytes(sourceImage, imageType));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream toInputStream(BufferedImage sourceImage, String imageType) {
        Objects.requireNonNull(sourceImage, "the source image can not be null");
        Objects.requireNonNull(imageType, "the image type can not be null");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIOUtil.writeImage((BufferedImage)sourceImage, (String)imageType, (OutputStream)outputStream);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
            return bufferedInputStream;
        }
    }

    public static BufferedImage rotate(BufferedImage sourceImage, double radians) {
        Objects.requireNonNull(sourceImage, "the source image can not be null");
        int imageWidth = sourceImage.getWidth();
        int imageHeight = sourceImage.getHeight();
        Rectangle rectangle = ImageUtil.getRotateRectangle(imageWidth, imageHeight, radians);
        BufferedImage image = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics = ImageUtil.createGraphics(image);
        graphics.translate((double)(rectangle.width - imageWidth) / 2.0, (double)(rectangle.height - imageHeight) / 2.0);
        graphics.rotate(Math.toRadians(radians), (double)imageWidth / 2.0, (double)imageHeight / 2.0);
        graphics.drawImage((Image)sourceImage, 0, 0, null);
        graphics.dispose();
        sourceImage.flush();
        return image;
    }

    public static BufferedImage joinForHorizontal(List<BufferedImage> sourceImageList) {
        Objects.requireNonNull(sourceImageList, "the source image list can not be null");
        BufferedImage firstImage = sourceImageList.get(0);
        int imageWidth = 0;
        int imageHeight = firstImage.getHeight();
        for (BufferedImage sourceImage : sourceImageList) {
            imageWidth += sourceImage.getWidth();
        }
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, firstImage.getType());
        Graphics2D graphics = ImageUtil.createGraphics(image);
        int x = 0;
        int y = 0;
        for (BufferedImage sourceImage : sourceImageList) {
            graphics.drawImage((Image)sourceImage, x, y, null);
            x += sourceImage.getWidth();
            sourceImage.flush();
        }
        graphics.dispose();
        return image;
    }

    public static BufferedImage joinForVertical(List<BufferedImage> sourceImageList) {
        Objects.requireNonNull(sourceImageList, "the source image list can not be null");
        BufferedImage firstImage = sourceImageList.get(0);
        int imageWidth = firstImage.getWidth();
        int imageHeight = 0;
        for (BufferedImage sourceImage : sourceImageList) {
            imageHeight += sourceImage.getHeight();
        }
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, firstImage.getType());
        Graphics2D graphics = ImageUtil.createGraphics(image);
        int x = 0;
        int y = 0;
        for (BufferedImage sourceImage : sourceImageList) {
            graphics.drawImage((Image)sourceImage, x, y, null);
            y += sourceImage.getHeight();
            sourceImage.flush();
        }
        graphics.dispose();
        return image;
    }

    public static List<BufferedImage> splitForHorizontal(BufferedImage image, int width) {
        Objects.requireNonNull(image, "the image can not be null");
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(16);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int x = 0;
        int w = Math.min(width, imageWidth);
        while (x <= imageWidth && w > 0) {
            imageList.add(image.getSubimage(x, 0, w, imageHeight));
            w = Math.min(width, Math.abs(imageWidth - (x += w)));
        }
        return imageList;
    }

    public static List<BufferedImage> splitForVertical(BufferedImage image, int height) {
        Objects.requireNonNull(image, "the image can not be null");
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(16);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        int y = 0;
        int h = Math.min(height, imageHeight);
        while (y + h < imageHeight) {
            imageList.add(image.getSubimage(0, y, imageWidth, h));
            if ((y += h) + h <= imageHeight) continue;
            h = Math.abs(imageHeight - y);
            y = imageHeight - h;
            imageList.add(image.getSubimage(0, y, imageWidth, h));
        }
        return imageList;
    }

    public static boolean isSvgImage(byte[] bytes) {
        return ImageUtil.isSvgImage1(bytes) || ImageUtil.isSvgImage2(bytes);
    }

    public static boolean isJ2kImage(byte[] bytes) {
        boolean result = true;
        for (int i = 0; i < J2K_BYTES2.length; ++i) {
            if (J2K_BYTES2[i] == bytes[i]) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Graphics2D createGraphics(BufferedImage image) {
        Objects.requireNonNull(image, "the image can not be null");
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHints(RenderingHintUtil.createDefaultRenderingHints());
        graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        return graphics;
    }

    private static Rectangle getRotateRectangle(int width, int height, double radians) {
        Rectangle src = new Rectangle(new Dimension(width, height));
        int angle = 90;
        int num = 2;
        if (radians >= 90.0) {
            if (radians / 90.0 % 2.0 == 1.0) {
                return new Rectangle((int)src.getHeight(), (int)src.getWidth());
            }
            radians %= 90.0;
        }
        double radius = Math.sqrt(src.getHeight() * src.getHeight() + src.getWidth() * src.getWidth()) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(radians) / 2.0) * radius;
        double radiansAlpha = (Math.PI - Math.toRadians(radians)) / 2.0;
        double radiansWidth = Math.atan(src.getHeight() / src.getWidth());
        double radiansHeight = Math.atan(src.getWidth() / src.getHeight());
        int offsetWidth = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansWidth)));
        int offsetHeight = Math.abs((int)(len * Math.cos(Math.PI - radiansAlpha - radiansHeight)));
        return new Rectangle((int)(src.getWidth() + (double)(offsetWidth * 2)), (int)(src.getHeight() + (double)(offsetHeight * 2)));
    }

    private static boolean isSvgImage1(byte[] bytes) {
        int length = 5;
        int maxLength = 24;
        int index = 0;
        byte flag = SVG_BYTES1[index];
        for (int idx = 0; idx < bytes.length && index != length && idx != maxLength; ++idx) {
            if (bytes[idx] != flag) continue;
            flag = SVG_BYTES1[++index];
        }
        return index == length;
    }

    private static boolean isSvgImage2(byte[] bytes) {
        boolean flag = true;
        for (int idx = 0; idx < SVG_BYTES2.length; ++idx) {
            if (bytes[idx] == SVG_BYTES2[idx]) continue;
            flag = false;
            break;
        }
        return flag;
    }
}

