/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.base;

import java.awt.Color;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.enums.ContentMode;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.enums.VerticalAlignment;

public abstract class AbstractBase {
    private Context context;
    private ContentMode contentMode;
    private Boolean isResetContentStream;
    private Color backgroundColor;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private Boolean isWrap;
    private Boolean isBreak;

    public abstract void initBase();

    protected void init() {
    }

    public void setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        Objects.requireNonNull(horizontalAlignment, "the horizontal alignment can not be null");
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(VerticalAlignment verticalAlignment) {
        Objects.requireNonNull(verticalAlignment, "the vertical alignment can not be null");
        this.verticalAlignment = verticalAlignment;
    }

    protected void init(AbstractBase param) {
        if (Objects.isNull((Object)this.contentMode)) {
            this.contentMode = param.contentMode;
        }
        if (Objects.isNull(this.backgroundColor)) {
            this.backgroundColor = param.backgroundColor;
        }
        if (Objects.isNull((Object)this.horizontalAlignment)) {
            this.horizontalAlignment = param.horizontalAlignment;
        }
        if (Objects.isNull((Object)this.verticalAlignment)) {
            this.verticalAlignment = param.verticalAlignment;
        }
        if (Objects.isNull(this.isResetContentStream)) {
            this.isResetContentStream = param.isResetContentStream;
        }
        if (Objects.isNull(this.isWrap)) {
            this.isWrap = param.isWrap;
            if (Objects.isNull(this.isWrap)) {
                this.isWrap = Boolean.FALSE;
            }
        }
        if (Objects.isNull(this.isBreak)) {
            this.isBreak = param.isBreak;
            if (Objects.isNull(this.isBreak)) {
                this.isBreak = Boolean.FALSE;
            }
        }
        if (Objects.nonNull(this.context)) {
            if (Objects.isNull(this.context.getWrapHeight())) {
                this.context.setWrapHeight(this.context.getPage().getFontSize());
            }
            if (Objects.isNull(this.context.getWrapBeginX()) && Objects.nonNull(this.context.getPage())) {
                this.context.setWrapBeginX(this.context.getPage().getMarginLeft());
            }
        }
    }

    public Context getContext() {
        return this.context;
    }

    public ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContentStream() {
        return this.isResetContentStream;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public Boolean getIsWrap() {
        return this.isWrap;
    }

    public Boolean getIsBreak() {
        return this.isBreak;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setContentMode(ContentMode contentMode) {
        this.contentMode = contentMode;
    }

    public void setIsResetContentStream(Boolean isResetContentStream) {
        this.isResetContentStream = isResetContentStream;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setIsWrap(Boolean isWrap) {
        this.isWrap = isWrap;
    }

    public void setIsBreak(Boolean isBreak) {
        this.isBreak = isBreak;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractBase)) {
            return false;
        }
        AbstractBase other = (AbstractBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContentStream = this.getIsResetContentStream();
        Boolean other$isResetContentStream = other.getIsResetContentStream();
        if (this$isResetContentStream == null ? other$isResetContentStream != null : !((Object)this$isResetContentStream).equals(other$isResetContentStream)) {
            return false;
        }
        Boolean this$isWrap = this.getIsWrap();
        Boolean other$isWrap = other.getIsWrap();
        if (this$isWrap == null ? other$isWrap != null : !((Object)this$isWrap).equals(other$isWrap)) {
            return false;
        }
        Boolean this$isBreak = this.getIsBreak();
        Boolean other$isBreak = other.getIsBreak();
        if (this$isBreak == null ? other$isBreak != null : !((Object)this$isBreak).equals(other$isBreak)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        ContentMode this$contentMode = this.getContentMode();
        ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        HorizontalAlignment this$horizontalAlignment = this.getHorizontalAlignment();
        HorizontalAlignment other$horizontalAlignment = other.getHorizontalAlignment();
        if (this$horizontalAlignment == null ? other$horizontalAlignment != null : !((Object)((Object)this$horizontalAlignment)).equals((Object)other$horizontalAlignment)) {
            return false;
        }
        VerticalAlignment this$verticalAlignment = this.getVerticalAlignment();
        VerticalAlignment other$verticalAlignment = other.getVerticalAlignment();
        return !(this$verticalAlignment == null ? other$verticalAlignment != null : !((Object)((Object)this$verticalAlignment)).equals((Object)other$verticalAlignment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContentStream = this.getIsResetContentStream();
        result = result * 59 + ($isResetContentStream == null ? 43 : ((Object)$isResetContentStream).hashCode());
        Boolean $isWrap = this.getIsWrap();
        result = result * 59 + ($isWrap == null ? 43 : ((Object)$isWrap).hashCode());
        Boolean $isBreak = this.getIsBreak();
        result = result * 59 + ($isBreak == null ? 43 : ((Object)$isBreak).hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        HorizontalAlignment $horizontalAlignment = this.getHorizontalAlignment();
        result = result * 59 + ($horizontalAlignment == null ? 43 : ((Object)((Object)$horizontalAlignment)).hashCode());
        VerticalAlignment $verticalAlignment = this.getVerticalAlignment();
        result = result * 59 + ($verticalAlignment == null ? 43 : ((Object)((Object)$verticalAlignment)).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractBase(context=" + this.getContext() + ", contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContentStream=" + this.getIsResetContentStream() + ", backgroundColor=" + this.getBackgroundColor() + ", horizontalAlignment=" + (Object)((Object)this.getHorizontalAlignment()) + ", verticalAlignment=" + (Object)((Object)this.getVerticalAlignment()) + ", isWrap=" + this.getIsWrap() + ", isBreak=" + this.getIsBreak() + ")";
    }
}

