/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.io.Closeable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseFont;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingCondition;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.Component;

public abstract class AbstractComponent
extends AbstractBaseFont
implements Component,
Closeable {
    private Set<PagingEvent> pagingEvents;
    private PagingCondition pagingCondition;
    private Float beginX;
    private Float beginY;
    private Float endX;
    private Float relativeBeginX;
    private Float relativeBeginY;
    private Boolean isCustomX;
    private Boolean isCustomY;

    public AbstractComponent() {
        throw new IllegalStateException("can not be initialized");
    }

    public AbstractComponent(Page page) {
        Page lastPage = page.getLastPage();
        this.setContext(lastPage.getContext());
        this.getContext().reset(lastPage);
        this.pagingEvents = new HashSet<PagingEvent>();
    }

    @Override
    public void setBeginX(Float beginX) {
        this.beginX = beginX;
        this.isCustomX = Objects.nonNull(beginX);
    }

    @Override
    public void setBeginY(Float beginY) {
        this.beginY = beginY;
        this.isCustomY = Objects.nonNull(beginY);
    }

    @Override
    public AbstractBase getBase() {
        return this;
    }

    public Page getPage() {
        return this.getContext().getPage();
    }

    @Override
    public void initBase() {
        super.init(this.getContext().getPage(), false);
    }

    @Override
    public float getBottom() {
        float bottom = this.getContext().getPage().getMarginBottom().floatValue();
        if (this.getContext().hasPageFooter()) {
            bottom += this.getContext().getPageFooter().getHeight().floatValue();
        }
        return bottom;
    }

    @Override
    public void close() {
        super.setContext(null);
    }

    @Override
    protected void init() {
        this.initBase();
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.nonNull(this.getContext().getPageHeader()) && this.getContext().getExecutingComponentType().isNotPageHeaderOrFooter()) {
            this.getPagingEvents().add(this.getContext().getPageHeader().getPagingEvent());
        }
        if (Objects.nonNull(this.getContext().getPageFooter()) && this.getContext().getExecutingComponentType().isNotPageHeaderOrFooter()) {
            this.getPagingEvents().add(this.getContext().getPageFooter().getPagingEvent());
        }
        if (Objects.isNull(this.getIsCustomX())) {
            this.setIsCustomX(Boolean.FALSE);
        }
        if (Objects.isNull(this.getIsCustomY())) {
            this.setIsCustomY(Boolean.FALSE);
        }
        if (this.getIsBreak().booleanValue()) {
            this.processBreak();
        }
        this.checkWrap();
        if (Objects.isNull(this.getRelativeBeginX())) {
            this.setRelativeBeginX(Float.valueOf(0.0f));
        }
        if (Objects.isNull(this.getRelativeBeginY())) {
            this.setRelativeBeginY(Float.valueOf(0.0f));
        }
    }

    protected void setBeginX(Float beginX, boolean isCustomX) {
        this.beginX = beginX;
        this.isCustomX = isCustomX;
    }

    protected void setBeginY(Float beginY, boolean isCustomY) {
        this.beginY = beginY;
        this.isCustomY = isCustomY;
    }

    protected void checkWrap() {
        if (Objects.isNull(this.getBeginX())) {
            this.setBeginX(Float.valueOf(this.getContext().getCursor().getX().floatValue() + this.getMarginLeft().floatValue()), Boolean.FALSE);
        }
        if (this.isWrap()) {
            this.resetWrapWidth();
            this.getContext().getCursor().reset(this.getContext().getWrapBeginX().floatValue(), this.getContext().getCursor().getY().floatValue() - this.getContext().getWrapHeight().floatValue());
            this.setBeginX(Float.valueOf(this.getContext().getCursor().getX().floatValue() + this.getMarginLeft().floatValue()), Boolean.FALSE);
            this.setIsWrap(Boolean.FALSE);
        }
        if (Objects.isNull(this.getBeginY())) {
            this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getMarginTop().floatValue()), Boolean.FALSE);
        }
    }

    protected void wrap() {
        this.setBeginX(null);
        this.setBeginY(null);
        this.setIsWrap(Boolean.TRUE);
        this.checkWrap();
    }

    protected boolean isWrap() {
        if (this.getIsWrap().booleanValue()) {
            return Boolean.TRUE;
        }
        if (Objects.isNull(this.getContext().getWrapWidth()) || Objects.isNull(this.getBeginX())) {
            return Boolean.FALSE;
        }
        return this.getContext().getWrapWidth().floatValue() - this.getBeginX().floatValue() < 0.0f;
    }

    protected boolean isPaging(Component component, float beginY) {
        boolean flag;
        boolean bl = flag = (this.checkPaging(beginY) || Optional.ofNullable(this.pagingCondition).map(condition -> condition.isPaging(component, beginY)).orElse(false) != false) && this.isPagingComponent();
        if (flag) {
            this.paging();
        }
        return flag;
    }

    protected boolean isPagingComponent() {
        return Optional.ofNullable(this.getContext().getExecutingComponentType()).map(ComponentType::isNotPageHeaderOrFooter).orElse(Boolean.FALSE);
    }

    protected void paging() {
        this.processBreak();
        this.wrap();
    }

    protected void reset(ComponentType type) {
        this.beginX = null;
        this.beginY = null;
        this.isCustomX = null;
        this.isCustomY = null;
        this.getContext().setWrapBeginX(null);
        this.getContext().resetExecutingComponentType(type);
    }

    protected boolean checkPaging(float beginY) {
        float bottom = this.getBottom();
        return beginY < this.getMarginBottom().floatValue() + bottom;
    }

    protected void processBreak() {
        if (Objects.isNull(this.getContext().getContainerInfo()) || Objects.isNull(this.getContext().getContainerInfo().getPagingEvent())) {
            this.executeBreak();
        } else {
            this.getContext().getContainerInfo().getPagingEvent().before(this);
            this.executeBreak();
            this.getContext().getContainerInfo().getPagingEvent().after(this);
        }
        this.getContext().setWrapHeight(this.getContext().getPage().getFontSize());
    }

    protected void executeBreak() {
        Optional.ofNullable(this.pagingEvents).ifPresent(events -> events.forEach(event -> event.before(this)));
        this.getContext().getPage().createSubPage();
        this.resetXY();
        super.init(this.getContext().getPage(), false);
        Optional.ofNullable(this.pagingEvents).ifPresent(events -> events.forEach(event -> event.after(this)));
    }

    protected void resetXY() {
        this.beginX = null;
        this.beginY = null;
    }

    protected void resetWrapWidth() {
        ComponentType type = this.getContext().getExecutingComponentType();
        if (Objects.nonNull((Object)type) && ComponentType.CONTAINER == type) {
            this.getContext().resetWrapWidth(this.getContext().getContainerInfo().getWidth());
        } else {
            this.getContext().resetWrapWidth(null);
        }
    }

    @Override
    public Set<PagingEvent> getPagingEvents() {
        return this.pagingEvents;
    }

    @Override
    public PagingCondition getPagingCondition() {
        return this.pagingCondition;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getEndX() {
        return this.endX;
    }

    public Float getRelativeBeginX() {
        return this.relativeBeginX;
    }

    public Float getRelativeBeginY() {
        return this.relativeBeginY;
    }

    public Boolean getIsCustomX() {
        return this.isCustomX;
    }

    public Boolean getIsCustomY() {
        return this.isCustomY;
    }

    public void setPagingEvents(Set<PagingEvent> pagingEvents) {
        this.pagingEvents = pagingEvents;
    }

    public void setPagingCondition(PagingCondition pagingCondition) {
        this.pagingCondition = pagingCondition;
    }

    public void setEndX(Float endX) {
        this.endX = endX;
    }

    public void setRelativeBeginX(Float relativeBeginX) {
        this.relativeBeginX = relativeBeginX;
    }

    public void setRelativeBeginY(Float relativeBeginY) {
        this.relativeBeginY = relativeBeginY;
    }

    public void setIsCustomX(Boolean isCustomX) {
        this.isCustomX = isCustomX;
    }

    public void setIsCustomY(Boolean isCustomY) {
        this.isCustomY = isCustomY;
    }

    @Override
    public String toString() {
        return "AbstractComponent(pagingEvents=" + this.getPagingEvents() + ", pagingCondition=" + this.getPagingCondition() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", endX=" + this.getEndX() + ", relativeBeginX=" + this.getRelativeBeginX() + ", relativeBeginY=" + this.getRelativeBeginY() + ", isCustomX=" + this.getIsCustomX() + ", isCustomY=" + this.getIsCustomY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractComponent)) {
            return false;
        }
        AbstractComponent other = (AbstractComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$endX = this.getEndX();
        Float other$endX = other.getEndX();
        if (this$endX == null ? other$endX != null : !((Object)this$endX).equals(other$endX)) {
            return false;
        }
        Float this$relativeBeginX = this.getRelativeBeginX();
        Float other$relativeBeginX = other.getRelativeBeginX();
        if (this$relativeBeginX == null ? other$relativeBeginX != null : !((Object)this$relativeBeginX).equals(other$relativeBeginX)) {
            return false;
        }
        Float this$relativeBeginY = this.getRelativeBeginY();
        Float other$relativeBeginY = other.getRelativeBeginY();
        if (this$relativeBeginY == null ? other$relativeBeginY != null : !((Object)this$relativeBeginY).equals(other$relativeBeginY)) {
            return false;
        }
        Boolean this$isCustomX = this.getIsCustomX();
        Boolean other$isCustomX = other.getIsCustomX();
        if (this$isCustomX == null ? other$isCustomX != null : !((Object)this$isCustomX).equals(other$isCustomX)) {
            return false;
        }
        Boolean this$isCustomY = this.getIsCustomY();
        Boolean other$isCustomY = other.getIsCustomY();
        if (this$isCustomY == null ? other$isCustomY != null : !((Object)this$isCustomY).equals(other$isCustomY)) {
            return false;
        }
        Set<PagingEvent> this$pagingEvents = this.getPagingEvents();
        Set<PagingEvent> other$pagingEvents = other.getPagingEvents();
        if (this$pagingEvents == null ? other$pagingEvents != null : !((Object)this$pagingEvents).equals(other$pagingEvents)) {
            return false;
        }
        PagingCondition this$pagingCondition = this.getPagingCondition();
        PagingCondition other$pagingCondition = other.getPagingCondition();
        return !(this$pagingCondition == null ? other$pagingCondition != null : !this$pagingCondition.equals(other$pagingCondition));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractComponent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $endX = this.getEndX();
        result = result * 59 + ($endX == null ? 43 : ((Object)$endX).hashCode());
        Float $relativeBeginX = this.getRelativeBeginX();
        result = result * 59 + ($relativeBeginX == null ? 43 : ((Object)$relativeBeginX).hashCode());
        Float $relativeBeginY = this.getRelativeBeginY();
        result = result * 59 + ($relativeBeginY == null ? 43 : ((Object)$relativeBeginY).hashCode());
        Boolean $isCustomX = this.getIsCustomX();
        result = result * 59 + ($isCustomX == null ? 43 : ((Object)$isCustomX).hashCode());
        Boolean $isCustomY = this.getIsCustomY();
        result = result * 59 + ($isCustomY == null ? 43 : ((Object)$isCustomY).hashCode());
        Set<PagingEvent> $pagingEvents = this.getPagingEvents();
        result = result * 59 + ($pagingEvents == null ? 43 : ((Object)$pagingEvents).hashCode());
        PagingCondition $pagingCondition = this.getPagingCondition();
        result = result * 59 + ($pagingCondition == null ? 43 : $pagingCondition.hashCode());
        return result;
    }
}

