/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseBorder;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.Textarea;
import org.dromara.pdf.pdfbox.util.BorderUtil;

public abstract class AbstractPageHeaderOrFooter
extends AbstractBaseBorder {
    private Float width;
    private Float height;
    private Context context;
    private Float beginX;
    private Float beginY;
    private List<Component> components;

    public AbstractPageHeaderOrFooter() {
        throw new IllegalStateException("can not be initialized");
    }

    public AbstractPageHeaderOrFooter(Page page) {
        this.context = page.getContext();
    }

    public abstract ComponentType getType();

    public abstract PagingEvent getPagingEvent();

    public void setWidth(Float width) {
        Objects.requireNonNull(width, "the width can not be null");
        if (width.floatValue() > this.getContext().getPage().getWithoutMarginWidth().floatValue()) {
            throw new IllegalArgumentException("the width can not be greater than the page width");
        }
        this.width = width;
    }

    public void setHeight(Float height) {
        Objects.requireNonNull(height, "the height can not be null");
        if (height.floatValue() > this.getContext().getPage().getWithoutMarginHeight().floatValue()) {
            throw new IllegalArgumentException("the height can not be greater than the page height");
        }
        this.height = height;
    }

    public Page getPage() {
        return this.getContext().getPage();
    }

    public void renderBefore() {
    }

    public void virtualRender() {
        Objects.requireNonNull(this.getWidth(), "the width can not be null");
        Objects.requireNonNull(this.getHeight(), "the height can not be null");
        this.init();
        Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::virtualRenderComponent);
        this.reset();
    }

    public void render() {
        Objects.requireNonNull(this.getWidth(), "the width can not be null");
        Objects.requireNonNull(this.getHeight(), "the height can not be null");
        this.init();
        this.renderBefore();
        Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::renderComponent);
        this.renderAfter();
        this.reset();
    }

    public void renderAfter() {
        BorderUtil.drawBorderWithBase(this, new PDRectangle(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue(), this.getWidth().floatValue(), this.getHeight().floatValue()));
    }

    public void virtualRenderComponent(Component component) {
        component.getContext().setExecutingComponentType(this.getType());
        this.getContext().setWrapBeginX(this.getBeginX());
        component.virtualRender();
    }

    public void renderComponent(Component component) {
        component.getContext().setExecutingComponentType(this.getType());
        this.getContext().setWrapBeginX(this.getBeginX());
        component.render();
    }

    public void reset() {
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue());
        this.getContext().resetExecutingComponentType(this.getType());
        this.getContext().setWrapWidth(this.getContext().getPage().getWithoutMarginWidth());
        this.getContext().setWrapBeginX(this.getContext().getPage().getMarginLeft());
    }

    public float getBeginYOffset() {
        float offset = 0.0f;
        if (!this.getComponents().isEmpty()) {
            Component component = this.getComponents().get(0);
            component.getBase().initBase();
            switch (component.getType()) {
                case TEXTAREA: {
                    offset = Optional.ofNullable(((Textarea)component).getFontSize()).orElse(this.getContext().getPage().getFontSize()).floatValue();
                    break;
                }
            }
        }
        return offset;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @Override
    public String toString() {
        return "AbstractPageHeaderOrFooter(width=" + this.getWidth() + ", height=" + this.getHeight() + ", context=" + this.getContext() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", components=" + this.getComponents() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractPageHeaderOrFooter)) {
            return false;
        }
        AbstractPageHeaderOrFooter other = (AbstractPageHeaderOrFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractPageHeaderOrFooter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }
}

