/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.QRCode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.Image;
import org.dromara.pdf.pdfbox.core.enums.BarcodeErrorLevel;
import org.dromara.pdf.pdfbox.core.enums.BarcodeType;
import org.dromara.pdf.pdfbox.core.enums.BarcodeWordsStyle;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class Barcode
extends AbstractComponent {
    private static final Map<Integer, BufferedImage> CACHE = new HashMap<Integer, BufferedImage>(10);
    private static final ReentrantLock LOCK = new ReentrantLock();
    private Map<EncodeHintType, Object> encodeHints = new HashMap<EncodeHintType, Object>(8);
    private Integer width;
    private Integer height;
    private Integer imageWidth;
    private Integer imageHeight;
    private BarcodeType codeType;
    private Color onColor;
    private Color offColor;
    private String content;
    private String words;
    private String wordsFontName;
    private Color wordsColor;
    private BarcodeWordsStyle wordsStyle;
    private Integer wordsSize;
    private Integer wordsOffsetX;
    private Integer wordsOffsetY;
    private Float angle;
    private Boolean isShowWords;
    private Boolean isCache;

    public Barcode(Page page) {
        super(page);
    }

    public void setWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = width;
    }

    public void setHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = height;
    }

    public void setImageWidth(int width) {
        if (width < 1) {
            throw new IllegalArgumentException("the image width can not be less than 1");
        }
        this.imageWidth = width;
    }

    public void setImageHeight(int height) {
        if (height < 1) {
            throw new IllegalArgumentException("the image height can not be less than 1");
        }
        this.imageHeight = height;
    }

    public void setCodeMargin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("the code margin can not be less than 0");
        }
        this.encodeHints.put(EncodeHintType.MARGIN, margin);
    }

    public void setErrorLevel(BarcodeErrorLevel level) {
        if (Objects.nonNull((Object)level)) {
            this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, level.getLevel());
        }
    }

    public void setQrVersion(int version) {
        boolean min = false;
        int max = 41;
        if (version <= 0 || version >= 41) {
            throw new IllegalArgumentException("the version must be between 1 and 40");
        }
        this.encodeHints.put(EncodeHintType.QR_VERSION, version);
    }

    public void setQrMaskPattern(int pattern) {
        if (!QRCode.isValidMaskPattern((int)pattern)) {
            throw new IllegalArgumentException("the qr mask pattern must be between 0 and 7");
        }
        this.encodeHints.put(EncodeHintType.QR_MASK_PATTERN, pattern);
    }

    public void setQrCompact(boolean isCompact) {
        this.encodeHints.put(EncodeHintType.QR_COMPACT, isCompact);
    }

    public void setEncodeHints(EncodeHintType type, Object value) {
        this.encodeHints.put(type, value);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.BARCODE;
    }

    @Override
    protected void init() {
        super.init();
        this.encodeHints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        this.initErrorLevel();
        if (Objects.isNull(this.width)) {
            this.width = this.imageWidth;
            Objects.requireNonNull(this.width, "the width or image width can not be null");
        }
        if (Objects.isNull(this.height)) {
            this.height = this.imageHeight;
            Objects.requireNonNull(this.height, "the height or image height can not be null");
        }
        if (Objects.isNull(this.imageWidth)) {
            this.imageWidth = this.width;
        }
        if (Objects.isNull(this.imageHeight)) {
            this.imageHeight = this.height;
        }
        Objects.requireNonNull(this.codeType, "the code type can not be null");
        Objects.requireNonNull(this.content, "the content can not be null");
        if (Objects.isNull(this.onColor)) {
            this.onColor = Color.BLACK;
        }
        if (Objects.isNull(this.offColor)) {
            this.offColor = this.getContext().getPage().getBackgroundColor();
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.isShowWords)) {
            this.isShowWords = Boolean.FALSE;
        }
        if (Objects.isNull(this.isCache)) {
            this.isCache = Boolean.FALSE;
        }
    }

    @Override
    public void virtualRender() {
        this.init();
        Image image = new Image(this.getContext().getPage());
        image.init(this, true);
        image.setWidth(this.getWidth());
        image.setHeight(this.getHeight());
        image.setAngle(this.getAngle());
        image.setImage(ImageUtil.toBytes(this.getBarcodeImage(), "png"));
        image.setRelativeBeginX(this.getRelativeBeginX());
        image.setRelativeBeginY(this.getRelativeBeginY());
        image.virtualRender();
        super.reset(this.getType());
    }

    @Override
    public void render() {
        this.init();
        Image image = new Image(this.getContext().getPage());
        image.init(this, true);
        image.setWidth(this.getWidth());
        image.setHeight(this.getHeight());
        image.setAngle(this.getAngle());
        image.setImage(ImageUtil.toBytes(this.getBarcodeImage(), "png"));
        image.setRelativeBeginX(this.getRelativeBeginX());
        image.setRelativeBeginY(this.getRelativeBeginY());
        image.render();
        super.reset(this.getType());
    }

    protected void initErrorLevel() {
        Object errorLevel = this.encodeHints.get(EncodeHintType.ERROR_CORRECTION);
        if (Objects.isNull(errorLevel)) {
            if (BarcodeFormat.AZTEC == this.codeType.getCodeFormat() || BarcodeFormat.PDF_417 == this.codeType.getCodeFormat()) {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M.getBits());
            } else {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
            }
        } else {
            ErrorCorrectionLevel level = (ErrorCorrectionLevel)errorLevel;
            if (BarcodeFormat.AZTEC == this.codeType.getCodeFormat() || BarcodeFormat.PDF_417 == this.codeType.getCodeFormat()) {
                this.encodeHints.put(EncodeHintType.ERROR_CORRECTION, level.getBits());
            }
        }
    }

    protected boolean isShowWords() {
        return this.getIsShowWords();
    }

    protected BufferedImage getBarcodeImage() {
        if (this.getIsCache().booleanValue()) {
            BufferedImage bufferedImage = CACHE.get(this.cacheKey());
            if (Objects.isNull(bufferedImage)) {
                try {
                    LOCK.lock();
                    bufferedImage = CACHE.get(this.cacheKey());
                    if (Objects.isNull(bufferedImage)) {
                        bufferedImage = this.createBarcodeImage();
                        CACHE.put(this.cacheKey(), bufferedImage);
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
            return bufferedImage;
        }
        return this.createBarcodeImage();
    }

    protected BufferedImage createBarcodeImage() {
        BufferedImage bufferedImage = this.toBufferedImage(new MultiFormatWriter().encode(this.getContent(), this.getCodeType().getCodeFormat(), this.getImageWidth().intValue(), this.getImageHeight().intValue(), this.getEncodeHints()));
        if (this.isShowWords()) {
            bufferedImage = this.addImageWords(bufferedImage);
        }
        return bufferedImage;
    }

    protected BufferedImage toBufferedImage(BitMatrix matrix) {
        int onColor = this.getOnColor().getRGB();
        int offColor = this.getOffColor().getRGB();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] rowPixels = new int[width];
        BitArray row = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            row = matrix.getRow(y, row);
            for (int x = 0; x < width; ++x) {
                rowPixels[x] = row.get(x) ? onColor : offColor;
            }
            image.setRGB(0, y, width, 1, rowPixels, 0, width);
        }
        return image;
    }

    protected BufferedImage addImageWords(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        String words = Optional.ofNullable(this.getWords()).orElse(this.getContent());
        String wordsFontName = this.getWordsFontName();
        Color wordsColor = Optional.ofNullable(this.getWordsColor()).orElse(Color.BLACK);
        int wordsSize = Optional.ofNullable(this.getWordsSize()).orElse(10);
        int wordsStyle = Optional.ofNullable(this.getWordsStyle()).orElse(BarcodeWordsStyle.NORMAL).getStyle();
        int wordsOffsetX = Optional.ofNullable(this.getWordsOffsetX()).orElse(0);
        int wordsOffsetY = Optional.ofNullable(this.getWordsOffsetY()).orElse(0);
        int totalHeight = height + wordsSize;
        BufferedImage out = new BufferedImage(width, totalHeight, 1);
        Graphics2D graphics = ImageUtil.createGraphics(out);
        graphics.fillRect(0, 0, width, totalHeight);
        graphics.setColor(wordsColor);
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.setFont(new Font(wordsFontName, wordsStyle, wordsSize));
        int strWidth = graphics.getFontMetrics().stringWidth(words);
        int beginX = (width - strWidth) / 2 + wordsOffsetX;
        int beginY = height + wordsOffsetY;
        graphics.drawString(words, beginX, beginY);
        graphics.dispose();
        image.flush();
        return out;
    }

    protected int cacheKey() {
        return Objects.hash(new Object[]{this.encodeHints, this.width, this.height, this.imageWidth, this.imageHeight, this.codeType, this.onColor, this.offColor, this.content, this.words, this.wordsFontName, this.wordsColor, this.wordsStyle, this.wordsSize, this.wordsOffsetX, this.wordsOffsetY, this.isShowWords});
    }

    public Map<EncodeHintType, Object> getEncodeHints() {
        return this.encodeHints;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public BarcodeType getCodeType() {
        return this.codeType;
    }

    public Color getOnColor() {
        return this.onColor;
    }

    public Color getOffColor() {
        return this.offColor;
    }

    public String getContent() {
        return this.content;
    }

    public String getWords() {
        return this.words;
    }

    public String getWordsFontName() {
        return this.wordsFontName;
    }

    public Color getWordsColor() {
        return this.wordsColor;
    }

    public BarcodeWordsStyle getWordsStyle() {
        return this.wordsStyle;
    }

    public Integer getWordsSize() {
        return this.wordsSize;
    }

    public Integer getWordsOffsetX() {
        return this.wordsOffsetX;
    }

    public Integer getWordsOffsetY() {
        return this.wordsOffsetY;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Boolean getIsShowWords() {
        return this.isShowWords;
    }

    public Boolean getIsCache() {
        return this.isCache;
    }

    public void setEncodeHints(Map<EncodeHintType, Object> encodeHints) {
        this.encodeHints = encodeHints;
    }

    public void setCodeType(BarcodeType codeType) {
        this.codeType = codeType;
    }

    public void setOnColor(Color onColor) {
        this.onColor = onColor;
    }

    public void setOffColor(Color offColor) {
        this.offColor = offColor;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setWords(String words) {
        this.words = words;
    }

    public void setWordsFontName(String wordsFontName) {
        this.wordsFontName = wordsFontName;
    }

    public void setWordsColor(Color wordsColor) {
        this.wordsColor = wordsColor;
    }

    public void setWordsStyle(BarcodeWordsStyle wordsStyle) {
        this.wordsStyle = wordsStyle;
    }

    public void setWordsSize(Integer wordsSize) {
        this.wordsSize = wordsSize;
    }

    public void setWordsOffsetX(Integer wordsOffsetX) {
        this.wordsOffsetX = wordsOffsetX;
    }

    public void setWordsOffsetY(Integer wordsOffsetY) {
        this.wordsOffsetY = wordsOffsetY;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    public void setIsShowWords(Boolean isShowWords) {
        this.isShowWords = isShowWords;
    }

    public void setIsCache(Boolean isCache) {
        this.isCache = isCache;
    }

    @Override
    public String toString() {
        return "Barcode(encodeHints=" + this.getEncodeHints() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", imageWidth=" + this.getImageWidth() + ", imageHeight=" + this.getImageHeight() + ", codeType=" + (Object)((Object)this.getCodeType()) + ", onColor=" + this.getOnColor() + ", offColor=" + this.getOffColor() + ", content=" + this.getContent() + ", words=" + this.getWords() + ", wordsFontName=" + this.getWordsFontName() + ", wordsColor=" + this.getWordsColor() + ", wordsStyle=" + (Object)((Object)this.getWordsStyle()) + ", wordsSize=" + this.getWordsSize() + ", wordsOffsetX=" + this.getWordsOffsetX() + ", wordsOffsetY=" + this.getWordsOffsetY() + ", angle=" + this.getAngle() + ", isShowWords=" + this.getIsShowWords() + ", isCache=" + this.getIsCache() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Barcode)) {
            return false;
        }
        Barcode other = (Barcode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$imageWidth = this.getImageWidth();
        Integer other$imageWidth = other.getImageWidth();
        if (this$imageWidth == null ? other$imageWidth != null : !((Object)this$imageWidth).equals(other$imageWidth)) {
            return false;
        }
        Integer this$imageHeight = this.getImageHeight();
        Integer other$imageHeight = other.getImageHeight();
        if (this$imageHeight == null ? other$imageHeight != null : !((Object)this$imageHeight).equals(other$imageHeight)) {
            return false;
        }
        Integer this$wordsSize = this.getWordsSize();
        Integer other$wordsSize = other.getWordsSize();
        if (this$wordsSize == null ? other$wordsSize != null : !((Object)this$wordsSize).equals(other$wordsSize)) {
            return false;
        }
        Integer this$wordsOffsetX = this.getWordsOffsetX();
        Integer other$wordsOffsetX = other.getWordsOffsetX();
        if (this$wordsOffsetX == null ? other$wordsOffsetX != null : !((Object)this$wordsOffsetX).equals(other$wordsOffsetX)) {
            return false;
        }
        Integer this$wordsOffsetY = this.getWordsOffsetY();
        Integer other$wordsOffsetY = other.getWordsOffsetY();
        if (this$wordsOffsetY == null ? other$wordsOffsetY != null : !((Object)this$wordsOffsetY).equals(other$wordsOffsetY)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Boolean this$isShowWords = this.getIsShowWords();
        Boolean other$isShowWords = other.getIsShowWords();
        if (this$isShowWords == null ? other$isShowWords != null : !((Object)this$isShowWords).equals(other$isShowWords)) {
            return false;
        }
        Boolean this$isCache = this.getIsCache();
        Boolean other$isCache = other.getIsCache();
        if (this$isCache == null ? other$isCache != null : !((Object)this$isCache).equals(other$isCache)) {
            return false;
        }
        Map<EncodeHintType, Object> this$encodeHints = this.getEncodeHints();
        Map<EncodeHintType, Object> other$encodeHints = other.getEncodeHints();
        if (this$encodeHints == null ? other$encodeHints != null : !((Object)this$encodeHints).equals(other$encodeHints)) {
            return false;
        }
        BarcodeType this$codeType = this.getCodeType();
        BarcodeType other$codeType = other.getCodeType();
        if (this$codeType == null ? other$codeType != null : !((Object)((Object)this$codeType)).equals((Object)other$codeType)) {
            return false;
        }
        Color this$onColor = this.getOnColor();
        Color other$onColor = other.getOnColor();
        if (this$onColor == null ? other$onColor != null : !((Object)this$onColor).equals(other$onColor)) {
            return false;
        }
        Color this$offColor = this.getOffColor();
        Color other$offColor = other.getOffColor();
        if (this$offColor == null ? other$offColor != null : !((Object)this$offColor).equals(other$offColor)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$words = this.getWords();
        String other$words = other.getWords();
        if (this$words == null ? other$words != null : !this$words.equals(other$words)) {
            return false;
        }
        String this$wordsFontName = this.getWordsFontName();
        String other$wordsFontName = other.getWordsFontName();
        if (this$wordsFontName == null ? other$wordsFontName != null : !this$wordsFontName.equals(other$wordsFontName)) {
            return false;
        }
        Color this$wordsColor = this.getWordsColor();
        Color other$wordsColor = other.getWordsColor();
        if (this$wordsColor == null ? other$wordsColor != null : !((Object)this$wordsColor).equals(other$wordsColor)) {
            return false;
        }
        BarcodeWordsStyle this$wordsStyle = this.getWordsStyle();
        BarcodeWordsStyle other$wordsStyle = other.getWordsStyle();
        return !(this$wordsStyle == null ? other$wordsStyle != null : !((Object)((Object)this$wordsStyle)).equals((Object)other$wordsStyle));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Barcode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $imageWidth = this.getImageWidth();
        result = result * 59 + ($imageWidth == null ? 43 : ((Object)$imageWidth).hashCode());
        Integer $imageHeight = this.getImageHeight();
        result = result * 59 + ($imageHeight == null ? 43 : ((Object)$imageHeight).hashCode());
        Integer $wordsSize = this.getWordsSize();
        result = result * 59 + ($wordsSize == null ? 43 : ((Object)$wordsSize).hashCode());
        Integer $wordsOffsetX = this.getWordsOffsetX();
        result = result * 59 + ($wordsOffsetX == null ? 43 : ((Object)$wordsOffsetX).hashCode());
        Integer $wordsOffsetY = this.getWordsOffsetY();
        result = result * 59 + ($wordsOffsetY == null ? 43 : ((Object)$wordsOffsetY).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Boolean $isShowWords = this.getIsShowWords();
        result = result * 59 + ($isShowWords == null ? 43 : ((Object)$isShowWords).hashCode());
        Boolean $isCache = this.getIsCache();
        result = result * 59 + ($isCache == null ? 43 : ((Object)$isCache).hashCode());
        Map<EncodeHintType, Object> $encodeHints = this.getEncodeHints();
        result = result * 59 + ($encodeHints == null ? 43 : ((Object)$encodeHints).hashCode());
        BarcodeType $codeType = this.getCodeType();
        result = result * 59 + ($codeType == null ? 43 : ((Object)((Object)$codeType)).hashCode());
        Color $onColor = this.getOnColor();
        result = result * 59 + ($onColor == null ? 43 : ((Object)$onColor).hashCode());
        Color $offColor = this.getOffColor();
        result = result * 59 + ($offColor == null ? 43 : ((Object)$offColor).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : $words.hashCode());
        String $wordsFontName = this.getWordsFontName();
        result = result * 59 + ($wordsFontName == null ? 43 : $wordsFontName.hashCode());
        Color $wordsColor = this.getWordsColor();
        result = result * 59 + ($wordsColor == null ? 43 : ((Object)$wordsColor).hashCode());
        BarcodeWordsStyle $wordsStyle = this.getWordsStyle();
        result = result * 59 + ($wordsStyle == null ? 43 : ((Object)((Object)$wordsStyle)).hashCode());
        return result;
    }
}

