/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;

public class Circle
extends AbstractComponent {
    private Float radius;
    private Color borderColor;

    public Circle(Page page) {
        super(page);
    }

    public void setRadius(float radius) {
        if (radius < 1.0f) {
            throw new IllegalArgumentException("the radius can not be less than 1");
        }
        this.radius = Float.valueOf(radius);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.RECTANGLE;
    }

    @Override
    protected void init() {
        super.init();
        this.initRadius();
        if (Objects.isNull(this.borderColor)) {
            this.borderColor = Color.BLACK;
        }
        if (!this.getIsCustomY().booleanValue() && this.getContext().isFirstLine()) {
            this.setBeginY(Float.valueOf(this.getBeginY().floatValue() - this.getRadius().floatValue()));
        }
        if (this.isWrap()) {
            this.wrap();
            this.setBeginY(Float.valueOf(this.getBeginY().floatValue() - this.getRadius().floatValue() * 0.5f));
        }
        this.setBeginX(Float.valueOf(this.getBeginX().floatValue() + this.getRadius().floatValue()));
    }

    @Override
    public void virtualRender() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        this.getContext().getCursor().reset(this.getBeginX().floatValue() + this.getRadius().floatValue() + this.getMarginRight().floatValue(), this.getBeginY().floatValue() + this.getMarginTop().floatValue());
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getRadius());
    }

    @Override
    public void render() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        this.renderCircle(contentStream, this.getRadius().floatValue(), this.getBorderColor());
        this.renderCircle(contentStream, this.getRadius().floatValue() - this.getBorderWidth().floatValue(), this.getBackgroundColor());
        contentStream.close();
        this.getContext().getCursor().reset(this.getBeginX().floatValue() + this.getRadius().floatValue() + this.getMarginRight().floatValue(), this.getBeginY().floatValue() + this.getMarginTop().floatValue());
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getRadius());
    }

    protected void initRadius() {
        float maxWidth = this.getContext().getWrapWidth().floatValue() + this.getPage().getMarginLeft().floatValue() - this.getBeginX().floatValue() - this.getMarginRight().floatValue();
        float maxHeight = this.getBeginY().floatValue() - this.getMarginBottom().floatValue() - this.getContext().getPage().getMarginBottom().floatValue();
        if (Objects.isNull(this.radius)) {
            this.radius = Float.valueOf(Math.min(maxWidth, maxHeight) / 2.0f);
        }
    }

    protected List<Position> initPosition(float radius) {
        float x = this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue();
        float y = this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue();
        ArrayList<Position> list = new ArrayList<Position>(4);
        list.add(new Position(Float.valueOf(x), Float.valueOf(y + radius)));
        list.add(new Position(Float.valueOf(x + radius), Float.valueOf(y)));
        list.add(new Position(Float.valueOf(x), Float.valueOf(y - radius)));
        list.add(new Position(Float.valueOf(x - radius), Float.valueOf(y)));
        return list;
    }

    protected List<Position> initCtrlPosition(List<Position> positions) {
        float offset = this.getRadius().floatValue() * 0.55191505f;
        ArrayList<Position> points = new ArrayList<Position>(8);
        Position top = positions.get(0);
        points.add(new Position(Float.valueOf(top.getX().floatValue() + offset), top.getY()));
        Position right = positions.get(1);
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() + offset)));
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() - offset)));
        Position bottom = positions.get(2);
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() + offset), bottom.getY()));
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() - offset), bottom.getY()));
        Position left = positions.get(3);
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() - offset)));
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() + offset)));
        points.add(new Position(Float.valueOf(top.getX().floatValue() - offset), top.getY()));
        return points;
    }

    protected void renderCircle(PDPageContentStream contentStream, float radius, Color color) {
        List<Position> positions = this.initPosition(radius);
        List<Position> ctrlPositions = this.initCtrlPosition(positions);
        Position dataTop = positions.get(0);
        Position ctrlTopRight = ctrlPositions.get(0);
        Position ctrlRightTop = ctrlPositions.get(1);
        Position dataRight = positions.get(1);
        Position ctrlRightBottom = ctrlPositions.get(2);
        Position ctrlBottomRight = ctrlPositions.get(3);
        Position dataBottom = positions.get(2);
        Position ctrlBottomLeft = ctrlPositions.get(4);
        Position ctrlLeftBottom = ctrlPositions.get(5);
        Position dataLeft = positions.get(3);
        Position ctrlLeftTop = ctrlPositions.get(6);
        Position ctrlTopLeft = ctrlPositions.get(7);
        contentStream.moveTo(dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.curveTo(ctrlTopRight.getX().floatValue(), ctrlTopRight.getY().floatValue(), ctrlRightTop.getX().floatValue(), ctrlRightTop.getY().floatValue(), dataRight.getX().floatValue(), dataRight.getY().floatValue());
        contentStream.curveTo(ctrlRightBottom.getX().floatValue(), ctrlRightBottom.getY().floatValue(), ctrlBottomRight.getX().floatValue(), ctrlBottomRight.getY().floatValue(), dataBottom.getX().floatValue(), dataBottom.getY().floatValue());
        contentStream.curveTo(ctrlBottomLeft.getX().floatValue(), ctrlBottomLeft.getY().floatValue(), ctrlLeftBottom.getX().floatValue(), ctrlLeftBottom.getY().floatValue(), dataLeft.getX().floatValue(), dataLeft.getY().floatValue());
        contentStream.curveTo(ctrlLeftTop.getX().floatValue(), ctrlLeftTop.getY().floatValue(), ctrlTopLeft.getX().floatValue(), ctrlTopLeft.getY().floatValue(), dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.setNonStrokingColor(color);
        contentStream.fill();
    }

    public Float getRadius() {
        return this.radius;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public String toString() {
        return "Circle(radius=" + this.getRadius() + ", borderColor=" + this.getBorderColor() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$radius = this.getRadius();
        Float other$radius = other.getRadius();
        if (this$radius == null ? other$radius != null : !((Object)this$radius).equals(other$radius)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        return !(this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Circle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $radius = this.getRadius();
        result = result * 59 + ($radius == null ? 43 : ((Object)$radius).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        return result;
    }
}

