/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.AbstractPagingEvent;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.component.Component;
import org.dromara.pdf.pdfbox.core.component.ContainerInfo;
import org.dromara.pdf.pdfbox.util.BorderUtil;

public class Container
extends AbstractComponent {
    private Float width;
    private Float Height;
    private List<Component> components;
    private PagingEvent pagingEvent;
    private Boolean isPagingBorder;

    public Container(Page page) {
        super(page);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.CONTAINER;
    }

    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.width, "the width can not be null");
        Objects.requireNonNull(this.Height, "the height can not be null");
        super.init();
        this.initOthers();
        this.getContext().getCursor().setX(this.getBeginX());
    }

    @Override
    public void virtualRender() {
        this.init();
        this.setPagingEvent(new DefaultContainerVirtualPagingEvent());
        if (!this.getIsCustomY().booleanValue() && this.isPaging(this, this.getBeginY().floatValue())) {
            this.getContext().getContainerInfo().setBeginY(this.getContext().getCursor().getY());
        }
        Float beforeX = this.getBeginX();
        Float beforeY = this.getContext().getCursor().getY();
        Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::virtualRenderComponent);
        this.addVirtualBorder(beforeY, this.getContext().getContainerInfo());
        this.reset(beforeX);
    }

    @Override
    public void render() {
        this.init();
        this.setPagingEvent(new DefaultContainerPagingEvent());
        if (!this.getIsCustomY().booleanValue() && this.isPaging(this, this.getBeginY().floatValue())) {
            this.getContext().getContainerInfo().setBeginY(this.getContext().getCursor().getY());
        }
        Float beforeX = this.getBeginX();
        Float beforeY = this.getContext().getCursor().getY();
        Optional.ofNullable(this.getComponents()).orElse(Collections.emptyList()).forEach(this::renderComponent);
        this.addBorder(beforeY, this.getContext().getContainerInfo());
        this.reset(beforeX);
    }

    @Override
    public void close() {
        this.getContext().setContainerInfo(null);
        super.close();
    }

    protected void reset(Float beforeX) {
        this.getContext().getCursor().setX(Float.valueOf(beforeX.floatValue() + this.getWidth().floatValue()));
        this.getContext().resetWrapWidth(null);
        this.getContext().resetWrapHeight(this.getContext().getContainerInfo().getHeight());
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getHeight());
    }

    protected void initOthers() {
        if (!this.getIsCustomX().booleanValue()) {
            this.setBeginX(Float.valueOf(this.getContext().getPage().getMarginLeft().floatValue() + this.getMarginLeft().floatValue()));
        }
        if (Objects.isNull(this.getIsPagingBorder())) {
            this.setIsPagingBorder(Boolean.FALSE);
        }
        this.getContext().setContainerInfo(new ContainerInfo(this));
        this.getContext().resetWrapWidth(this.getWidth());
    }

    protected void virtualRenderComponent(Component component) {
        this.getContext().setWrapBeginX(this.getBeginX());
        component.virtualRender();
        this.getContext().getContainerInfo().setIsFirstComponent(Boolean.FALSE);
    }

    protected void renderComponent(Component component) {
        this.getContext().setWrapBeginX(this.getBeginX());
        component.render();
        this.getContext().getContainerInfo().setIsFirstComponent(Boolean.FALSE);
    }

    protected void addVirtualBorder(Float beforeY, ContainerInfo info) {
        if (info.isPaging()) {
            if (!this.getIsPagingBorder().booleanValue()) {
                info.setIsBorderTop(Boolean.FALSE);
            }
            beforeY = info.getBeginY();
        }
        if (this.checkPaging(beforeY.floatValue() - info.getHeight().floatValue())) {
            this.paging();
            this.addVirtualBorder(info.getBeginY(), info);
        } else {
            this.getContext().getCursor().setY(Float.valueOf(beforeY.floatValue() - info.getHeight().floatValue()));
        }
    }

    protected void addBorder(Float beforeY, ContainerInfo info) {
        if (info.isPaging()) {
            if (!this.getIsPagingBorder().booleanValue()) {
                info.setIsBorderTop(Boolean.FALSE);
            }
            beforeY = info.getBeginY();
        }
        if (this.checkPaging(beforeY.floatValue() - info.getHeight().floatValue())) {
            this.paging();
            this.addBorder(info.getBeginY(), info);
        } else {
            BorderUtil.drawBorderWithBase(info, new PDRectangle(info.getBeginX().floatValue(), info.getBeginY().floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue()));
            this.getContext().getCursor().setY(Float.valueOf(beforeY.floatValue() - info.getHeight().floatValue()));
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.Height;
    }

    public List<Component> getComponents() {
        return this.components;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public void setHeight(Float Height) {
        this.Height = Height;
    }

    public void setComponents(List<Component> components) {
        this.components = components;
    }

    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    @Override
    public String toString() {
        return "Container(width=" + this.getWidth() + ", Height=" + this.getHeight() + ", components=" + this.getComponents() + ", pagingEvent=" + this.getPagingEvent() + ", isPagingBorder=" + this.getIsPagingBorder() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Container)) {
            return false;
        }
        Container other = (Container)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$Height = this.getHeight();
        Float other$Height = other.getHeight();
        if (this$Height == null ? other$Height != null : !((Object)this$Height).equals(other$Height)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        return !(this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Container;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $Height = this.getHeight();
        result = result * 59 + ($Height == null ? 43 : ((Object)$Height).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        return result;
    }

    public static class DefaultContainerPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void before(Component component) {
            Context context = component.getContext();
            ContainerInfo info = context.getContainerInfo();
            if (Objects.nonNull(info)) {
                Float height = info.getHeight();
                info.setHeight(Float.valueOf(info.getBeginY().floatValue() - component.getBottom()));
                Boolean isBorderTop = info.getIsBorderTop();
                Boolean isBorderBottom = info.getIsBorderBottom();
                if (info.getIsPagingBorder().booleanValue()) {
                    info.setIsBorderTop(Boolean.TRUE);
                    info.setIsBorderBottom(Boolean.TRUE);
                } else {
                    if (info.isPaging()) {
                        info.setIsBorderTop(Boolean.FALSE);
                    }
                    info.setIsBorderBottom(Boolean.FALSE);
                }
                BorderUtil.drawBorderWithBase(info, new PDRectangle(info.getBeginX().floatValue(), info.getBeginY().floatValue() - info.getHeight().floatValue(), info.getWidth().floatValue(), info.getHeight().floatValue()));
                info.setIsBorderTop(isBorderTop);
                info.setIsBorderBottom(isBorderBottom);
                info.setHeight(Float.valueOf(height.floatValue() - info.getHeight().floatValue()));
                info.pagingCount();
            }
        }

        @Override
        public void after(Component component) {
            Context context = component.getContext();
            Optional.ofNullable(context.getContainerInfo()).ifPresent(info -> info.setBeginY(context.getCursor().getY()));
        }
    }

    public static class DefaultContainerVirtualPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void before(Component component) {
            Context context = component.getContext();
            ContainerInfo info = context.getContainerInfo();
            if (Objects.nonNull(info)) {
                info.setHeight(Float.valueOf(info.getHeight().floatValue() - info.getBeginY().floatValue() + component.getBottom()));
                info.pagingCount();
            }
        }

        @Override
        public void after(Component component) {
            Context context = component.getContext();
            Optional.ofNullable(context.getContainerInfo()).ifPresent(info -> info.setBeginY(context.getCursor().getY()));
        }
    }
}

