/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.Objects;
import java.util.Optional;
import org.dromara.pdf.pdfbox.core.base.AbstractPagingEvent;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.component.Component;

public class PageFooter
extends AbstractPageHeaderOrFooter {
    private PagingEvent pagingEvent;
    private Float originalY;

    public PageFooter(Page page) {
        super(page);
        page.getContext().setPageFooter(this);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.PAGE_FOOTER;
    }

    @Override
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Override
    public void initBase() {
        super.init(this.getContext().getPage(), false);
    }

    @Override
    public void virtualRender() {
        this.pagingEvent = new DefaultPageFooterVirtualPagingEvent();
        super.virtualRender();
    }

    @Override
    public void render() {
        this.pagingEvent = new DefaultPageFooterPagingEvent();
        super.render();
    }

    @Override
    public void reset() {
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.originalY.floatValue());
        this.getContext().resetExecutingComponentType(this.getType());
    }

    @Override
    protected void init() {
        this.initBase();
        if (Objects.isNull(this.getBeginX())) {
            this.setBeginX(this.getContext().getPage().getMarginLeft());
        }
        if (Objects.isNull(this.getBeginY())) {
            this.setBeginY(Float.valueOf(this.getHeight().floatValue() + this.getContext().getPage().getMarginBottom().floatValue()));
        }
        this.originalY = this.getContext().getCursor().getY();
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getBeginYOffset());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageFooter)) {
            return false;
        }
        PageFooter other = (PageFooter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$originalY = this.originalY;
        Float other$originalY = other.originalY;
        if (this$originalY == null ? other$originalY != null : !((Object)this$originalY).equals(other$originalY)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        return !(this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageFooter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $originalY = this.originalY;
        result = result * 59 + ($originalY == null ? 43 : ((Object)$originalY).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        return result;
    }

    public static class DefaultPageFooterPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void after(Component component) {
            Float wrapBeginX = component.getContext().getWrapBeginX();
            ComponentType currentExecutingComponentType = component.getContext().getExecutingComponentType();
            Optional.ofNullable(component.getContext().getPageFooter()).ifPresent(AbstractPageHeaderOrFooter::render);
            component.getContext().setExecutingComponentType(currentExecutingComponentType);
            component.getContext().setWrapBeginX(wrapBeginX);
        }
    }

    public static class DefaultPageFooterVirtualPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void after(Component component) {
            Float wrapBeginX = component.getContext().getWrapBeginX();
            ComponentType currentExecutingComponentType = component.getContext().getExecutingComponentType();
            Optional.ofNullable(component.getContext().getPageFooter()).ifPresent(AbstractPageHeaderOrFooter::virtualRender);
            component.getContext().setExecutingComponentType(currentExecutingComponentType);
            component.getContext().setWrapBeginX(wrapBeginX);
        }
    }
}

