/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.Objects;
import java.util.Optional;
import org.dromara.pdf.pdfbox.core.base.AbstractPagingEvent;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.component.AbstractPageHeaderOrFooter;
import org.dromara.pdf.pdfbox.core.component.Component;

public class PageHeader
extends AbstractPageHeaderOrFooter {
    private PagingEvent pagingEvent;

    public PageHeader(Page page) {
        super(page);
        page.getContext().setPageHeader(this);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.PAGE_HEADER;
    }

    @Override
    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    @Override
    public void initBase() {
        super.init(this.getContext().getPage(), false);
    }

    @Override
    public void virtualRender() {
        this.pagingEvent = new DefaultPageHeaderVirtualPagingEvent();
        super.virtualRender();
    }

    @Override
    public void render() {
        this.pagingEvent = new DefaultPageHeaderPagingEvent();
        super.render();
    }

    @Override
    protected void init() {
        this.initBase();
        this.getContext().setWrapWidth(this.getWidth());
        if (Objects.isNull(this.getBeginX())) {
            this.setBeginX(this.getContext().getPage().getMarginLeft());
        }
        if (Objects.isNull(this.getBeginY())) {
            this.setBeginY(Float.valueOf(this.getContext().getPage().getHeight().floatValue() - this.getContext().getPage().getMarginTop().floatValue()));
        }
        this.getContext().getCursor().reset(this.getBeginX().floatValue(), this.getBeginY().floatValue() - this.getBeginYOffset());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageHeader)) {
            return false;
        }
        PageHeader other = (PageHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        return !(this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageHeader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        return result;
    }

    public static class DefaultPageHeaderPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void after(Component component) {
            Float wrapBeginX = component.getContext().getWrapBeginX();
            ComponentType currentExecutingComponentType = component.getContext().getExecutingComponentType();
            Optional.ofNullable(component.getContext().getPageHeader()).ifPresent(AbstractPageHeaderOrFooter::render);
            component.getContext().setExecutingComponentType(currentExecutingComponentType);
            component.getContext().setWrapBeginX(wrapBeginX);
        }
    }

    public static class DefaultPageHeaderVirtualPagingEvent
    extends AbstractPagingEvent {
        @Override
        public void after(Component component) {
            Float wrapBeginX = component.getContext().getWrapBeginX();
            ComponentType currentExecutingComponentType = component.getContext().getExecutingComponentType();
            Optional.ofNullable(component.getContext().getPageHeader()).ifPresent(AbstractPageHeaderOrFooter::virtualRender);
            component.getContext().setExecutingComponentType(currentExecutingComponentType);
            component.getContext().setWrapBeginX(wrapBeginX);
        }
    }
}

