/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;

public class Rectangle
extends AbstractComponent {
    private Float width;
    private Float height;
    private Float angle;
    private Color borderColor;

    public Rectangle(Page page) {
        super(page);
    }

    public void setWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the width can not be less than 1");
        }
        this.width = Float.valueOf(width);
    }

    public void setHeight(float height) {
        if (height < 1.0f) {
            throw new IllegalArgumentException("the height can not be less than 1");
        }
        this.height = Float.valueOf(height);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.RECTANGLE;
    }

    @Override
    public void virtualRender() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        this.getContext().getCursor().reset(this.getBeginX().floatValue() + this.getWidth().floatValue() + this.getMarginRight().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue() - this.getMarginBottom().floatValue());
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getHeight());
    }

    @Override
    public void render() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        float offsetX = 0.5f * this.getWidth().floatValue();
        float offsetY = 0.5f * this.getHeight().floatValue();
        PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        contentStream.saveGraphicsState();
        contentStream.transform(Matrix.getTranslateInstance((float)(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue() + offsetX), (float)(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue() + offsetY)));
        contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(this.getAngle().floatValue()), (float)0.0f, (float)0.0f));
        contentStream.transform(Matrix.getTranslateInstance((float)(-offsetX), (float)(-offsetY)));
        contentStream.addRect(0.0f, 0.0f, this.getWidth().floatValue(), this.getHeight().floatValue());
        contentStream.setNonStrokingColor(this.getBorderColor());
        contentStream.fill();
        float offSet = this.getBorderWidth().floatValue();
        float whOffSet = this.getBorderWidth().floatValue() * 2.0f;
        contentStream.addRect(offSet, offSet, this.getWidth().floatValue() - whOffSet, this.getHeight().floatValue() - whOffSet);
        contentStream.setNonStrokingColor(this.getBackgroundColor());
        contentStream.fill();
        contentStream.restoreGraphicsState();
        contentStream.close();
        this.getContext().getCursor().reset(this.getBeginX().floatValue() + this.getWidth().floatValue() + this.getMarginRight().floatValue(), this.getBeginY().floatValue() - this.getHeight().floatValue() - this.getMarginBottom().floatValue());
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getHeight());
    }

    @Override
    protected void init() {
        super.init();
        this.initWidthAndHeight();
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.borderColor)) {
            this.borderColor = Color.BLACK;
        }
        if (!this.getIsCustomY().booleanValue() && this.getContext().isFirstLine()) {
            this.setBeginY(Float.valueOf(this.getBeginY().floatValue() - this.getHeight().floatValue()));
        }
        if (this.isWrap()) {
            this.wrap();
        }
    }

    private void initWidthAndHeight() {
        float maxWidth = this.getContext().getWrapWidth().floatValue() + this.getPage().getMarginLeft().floatValue() - this.getBeginX().floatValue() - this.getMarginRight().floatValue();
        float maxHeight = this.getBeginY().floatValue() - this.getMarginBottom().floatValue() - this.getContext().getPage().getMarginBottom().floatValue();
        if (Objects.isNull(this.width)) {
            this.width = Float.valueOf(maxWidth);
        }
        if (this.width.floatValue() > maxWidth) {
            this.width = Float.valueOf(maxWidth);
        }
        if (Objects.isNull(this.height)) {
            this.height = Float.valueOf(maxHeight);
        }
        if (this.height.floatValue() > maxHeight) {
            this.height = Float.valueOf(maxHeight);
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public String toString() {
        return "Rectangle(width=" + this.getWidth() + ", height=" + this.getHeight() + ", angle=" + this.getAngle() + ", borderColor=" + this.getBorderColor() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        return !(this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Rectangle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        return result;
    }
}

