/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.HighlightMode;
import org.dromara.pdf.pdfbox.core.base.InnerDest;
import org.dromara.pdf.pdfbox.core.base.OuterDest;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.info.CatalogInfo;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.BorderUtil;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class Textarea
extends AbstractComponent {
    protected CatalogInfo catalog;
    protected Integer tabSize;
    protected String text;
    protected List<String> textList;
    protected Color highlightColor;
    protected Boolean isHighlight;
    protected Float underlineWidth;
    protected Color underlineColor;
    protected Boolean isUnderline;
    protected Float deleteLineWidth;
    protected Color deleteLineColor;
    protected Boolean isDeleteLine;
    protected InnerDest innerDest;
    protected OuterDest outerDest;

    public Textarea(Page page) {
        super(page);
    }

    @Override
    public void setFontName(String fontName) {
        super.setFontName(fontName);
        super.setFont(null);
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the size can not be less than 0");
        }
        this.tabSize = size;
    }

    public void setUnderlineWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the underline width can not be less than 1");
        }
        this.underlineWidth = Float.valueOf(width);
    }

    public void setDeleteLineWidth(float width) {
        if (width < 1.0f) {
            throw new IllegalArgumentException("the delete line width can not be less than 1");
        }
        this.deleteLineWidth = Float.valueOf(width);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.TEXTAREA;
    }

    public String getPlaceholder() {
        return "${CPN}";
    }

    @Override
    public void virtualRender() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        if (!this.getTextList().isEmpty()) {
            float textWidth = 0.0f;
            PDPageContentStream contentStream = this.initContentStream();
            Iterator<String> iterator = this.getTextList().iterator();
            while (iterator.hasNext()) {
                String text = iterator.next();
                textWidth = TextUtil.getTextRealWidth(text, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue());
                this.virtualWrite(text, position);
                if (!iterator.hasNext()) continue;
                position.reset(this.getContext().getWrapBeginX(), Float.valueOf(position.getY().floatValue() - this.getFontSize().floatValue() - this.getLeading().floatValue() - this.getUnderlineWidth().floatValue()));
            }
            contentStream.close();
            this.resetPagePosition(position, textWidth);
        }
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getFontSize());
    }

    @Override
    public void render() {
        this.init();
        if (!this.getIsCustomY().booleanValue()) {
            this.isPaging(this, this.getBeginY().floatValue());
        }
        Position position = new Position(Float.valueOf(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue()), Float.valueOf(this.getBeginY().floatValue() - this.getRelativeBeginY().floatValue()));
        this.initCatalog(position);
        if (!this.getTextList().isEmpty()) {
            float textWidth = 0.0f;
            PDPageContentStream contentStream = this.initContentStream();
            Iterator<String> iterator = this.getTextList().iterator();
            while (iterator.hasNext()) {
                String text = iterator.next();
                textWidth = TextUtil.getTextRealWidth(text, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue());
                contentStream = this.write(text, textWidth, contentStream, position);
                if (!iterator.hasNext()) continue;
                position.reset(this.getContext().getWrapBeginX(), Float.valueOf(position.getY().floatValue() - this.getFontSize().floatValue() - this.getLeading().floatValue() - this.getUnderlineWidth().floatValue()));
            }
            contentStream.close();
            this.resetPagePosition(position, textWidth);
        }
        super.reset(this.getType());
        this.getContext().setWrapHeight(this.getFontSize());
    }

    @Override
    protected void init() {
        super.init();
        Page page = this.getContext().getPage();
        if (this.getContext().isContainerWrap() || !this.getIsCustomY().booleanValue() && this.getContext().isFirstLine()) {
            super.setBeginY(Float.valueOf(this.getBeginY().floatValue() - this.getFontSize().floatValue()));
        }
        if (Objects.nonNull(this.getFontName())) {
            PDFont pdFont = PdfHandler.getFontHandler().getPDFont(this.getContext().getTargetDocument(), this.getFontName(), true);
            super.setFont(pdFont);
        }
        if (Objects.isNull(this.tabSize)) {
            this.tabSize = 4;
        }
        if (Objects.isNull(this.highlightColor)) {
            this.highlightColor = page.getBackgroundColor();
        }
        if (Objects.isNull(this.isHighlight)) {
            this.isHighlight = Boolean.FALSE;
        }
        if (Objects.isNull(this.underlineWidth)) {
            this.underlineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.underlineColor)) {
            this.underlineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isUnderline)) {
            this.isUnderline = Boolean.FALSE;
        }
        if (Objects.isNull(this.deleteLineWidth)) {
            this.deleteLineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.deleteLineColor)) {
            this.deleteLineColor = this.getFontColor();
        }
        if (Objects.isNull(this.isDeleteLine)) {
            this.isDeleteLine = Boolean.FALSE;
        }
        this.initText();
    }

    protected void initText() {
        LinkedList<String> tempTextList = new LinkedList<String>();
        if (Objects.nonNull(this.text)) {
            tempTextList.addAll(this.processText(this.text));
        } else if (Objects.nonNull(this.textList)) {
            this.textList.forEach(text -> tempTextList.addAll(this.processText((String)text)));
        } else {
            this.textList = Collections.emptyList();
            return;
        }
        this.initTextList(tempTextList);
    }

    protected List<String> processText(String text) {
        String temp = TextUtil.filterAll(text);
        temp = temp.replace("${CPN}", this.getContext().getPage().getIndex().toString());
        temp = TextUtil.replaceTab(temp, this.getTabSize());
        return Arrays.asList(temp.split("\n"));
    }

    protected void initTextList(List<String> tempTextList) {
        float wrapWidth = this.getContext().getWrapWidth().floatValue();
        if (wrapWidth < this.getFontSize().floatValue()) {
            throw new IllegalArgumentException("the font size is larger, must set less font size");
        }
        float firstLineWidth = wrapWidth - (this.getBeginX().floatValue() - Optional.ofNullable(this.getContext().getWrapBeginX()).orElse(this.getContext().getPage().getMarginLeft()).floatValue());
        this.initTextList(tempTextList, firstLineWidth, wrapWidth);
    }

    protected void initTextList(List<String> tempTextList, float firstLineWidth, float newLineWidth) {
        this.textList = new LinkedList<String>();
        if (tempTextList.isEmpty()) {
            return;
        }
        String text = tempTextList.get(0);
        if (TextUtil.isNotBlank(text)) {
            String firstContent = TextUtil.splitText(text, firstLineWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue());
            if (firstContent == null) {
                this.setBeginX(this.getContext().getWrapBeginX());
                this.setBeginY(Float.valueOf(this.getContext().getCursor().getY().floatValue() - this.getFontSize().floatValue()));
                this.textList.addAll(TextUtil.splitLines(text, newLineWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue()));
            } else {
                this.textList.add(firstContent);
                if (firstContent.length() < text.length()) {
                    this.textList.addAll(TextUtil.splitLines(text.substring(firstContent.length()), newLineWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue()));
                }
            }
        }
        int count = tempTextList.size();
        for (int i = 1; i < count; ++i) {
            if (!TextUtil.isNotBlank(tempTextList.get(i))) continue;
            this.textList.addAll(TextUtil.splitLines(tempTextList.get(i), newLineWidth, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue()));
        }
    }

    protected void initCatalog(Position position) {
        if (Objects.nonNull(this.catalog)) {
            Context context = this.getContext();
            this.catalog.setPage(context.getPage());
            this.catalog.setBeginX(position.getX());
            this.catalog.setBeginY(position.getY());
            context.getCatalogs().add(this.catalog);
        }
    }

    protected void virtualWrite(String text, Position position) {
        if (TextUtil.isNotBlank(text) && this.isPaging(this, position.getY().floatValue())) {
            position.setY(this.getBeginY());
        }
    }

    protected PDPageContentStream write(String text, float textWidth, PDPageContentStream contentStream, Position position) {
        if (TextUtil.isNotBlank(text)) {
            if (this.isPaging(this, position.getY().floatValue())) {
                position.setY(Float.valueOf(this.getBeginY().floatValue() - this.getFontSize().floatValue()));
                contentStream.close();
                contentStream = this.initContentStream();
            }
            PDRectangle lineRectangle = this.getLineRectangle(textWidth, position);
            this.addHighlight(lineRectangle, contentStream);
            this.addText(text, lineRectangle, contentStream);
            this.addDeleteLine(lineRectangle, contentStream);
            this.addUnderline(lineRectangle, contentStream);
            this.addInnerDest(lineRectangle);
            this.addOuterDest(lineRectangle);
            this.addBorder(lineRectangle, contentStream);
            position.setX(Float.valueOf(lineRectangle.getLowerLeftX()));
        }
        return contentStream;
    }

    protected void addHighlight(PDRectangle rectangle, PDPageContentStream contentStream) {
        if (this.getIsHighlight().booleanValue()) {
            contentStream.addRect(rectangle.getLowerLeftX(), rectangle.getLowerLeftY() - this.getFontSize().floatValue() / 10.0f, rectangle.getWidth(), rectangle.getHeight());
            contentStream.setNonStrokingColor(this.getHighlightColor());
            contentStream.fill();
            contentStream.setNonStrokingColor(this.getContext().getPage().getBackgroundColor());
        }
    }

    protected void addText(String text, PDRectangle rectangle, PDPageContentStream contentStream) {
        contentStream.beginText();
        this.initFontColorAndAlpha(contentStream);
        this.initPosition(contentStream, rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        contentStream.showText(text);
        contentStream.endText();
    }

    protected void addDeleteLine(PDRectangle rectangle, PDPageContentStream stream) {
        if (this.getIsDeleteLine().booleanValue()) {
            float beginY = rectangle.getLowerLeftY() - this.getDeleteLineWidth().floatValue() / 2.0f + this.getFontSize().floatValue() / 2.0f - this.getFontSize().floatValue() / 10.0f;
            stream.setStrokingColor(this.getDeleteLineColor());
            stream.setLineWidth(this.getDeleteLineWidth().floatValue());
            stream.moveTo(rectangle.getLowerLeftX(), beginY);
            stream.lineTo(rectangle.getUpperRightX(), beginY);
            stream.stroke();
        }
    }

    protected void addUnderline(PDRectangle rectangle, PDPageContentStream stream) {
        if (this.getIsUnderline().booleanValue()) {
            stream.setStrokingColor(this.getUnderlineColor());
            stream.setLineWidth(this.getUnderlineWidth().floatValue());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
        }
    }

    protected void addInnerDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getInnerDest())) {
            Objects.requireNonNull(this.getInnerDest().getPage(), "the page of inner destination can not be null");
            PDPageXYZDestination destination = new PDPageXYZDestination();
            destination.setPage(this.getInnerDest().getPage().getTarget());
            Optional.ofNullable(this.getInnerDest().getTopY()).ifPresent(arg_0 -> ((PDPageXYZDestination)destination).setTop(arg_0));
            PDActionGoTo action = new PDActionGoTo();
            action.setDestination((PDDestination)destination);
            this.addLink((PDAction)action, this.getInnerDest().getName(), rectangle, this.getInnerDest().getHighlightMode());
        }
    }

    protected void addOuterDest(PDRectangle rectangle) {
        if (Objects.nonNull(this.getOuterDest())) {
            Objects.requireNonNull(this.getOuterDest().getUrl(), "the url of outer destination can not be null");
            PDActionURI action = new PDActionURI();
            action.setURI(this.getOuterDest().getUrl());
            this.addLink((PDAction)action, this.getOuterDest().getName(), rectangle, this.getOuterDest().getHighlightMode());
        }
    }

    protected void addLink(PDAction action, String name, PDRectangle rectangle, HighlightMode mode) {
        PDPage target = this.getContext().getPage().getTarget();
        PDAnnotationLink link = new PDAnnotationLink();
        link.setAnnotationName(Optional.ofNullable(name).orElse(UUID.randomUUID().toString()));
        Optional.ofNullable(mode).map(HighlightMode::getMode).ifPresent(arg_0 -> ((PDAnnotationLink)link).setHighlightMode(arg_0));
        link.setAction(action);
        link.setRectangle(rectangle);
        target.getAnnotations().add(link);
    }

    protected void addBorder(PDRectangle rectangle, PDPageContentStream stream) {
        rectangle.setLowerLeftY(rectangle.getLowerLeftY() - this.getFontSize().floatValue() / 6.0f);
        BorderUtil.drawNormalBorder(stream, rectangle, this);
    }

    protected PDPageContentStream initContentStream() {
        Context context = this.getContext();
        PDPageContentStream contentStream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), this.getContentMode().getMode(), true, true);
        contentStream.setFont(this.getFont(), this.getFontSize().floatValue());
        contentStream.setRenderingMode(this.getFontStyle().getMode());
        contentStream.setLeading(this.getLeading().floatValue());
        contentStream.setCharacterSpacing(this.getCharacterSpacing().floatValue());
        return contentStream;
    }

    protected void initFontColorAndAlpha(PDPageContentStream stream) {
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        stream.setGraphicsStateParameters(state);
        if (this.getFontStyle().isFill()) {
            stream.setNonStrokingColor(this.getFontColor());
            state.setNonStrokingAlphaConstant(this.getFontAlpha());
        }
        if (this.getFontStyle().isStroke()) {
            stream.setStrokingColor(this.getFontColor());
            state.setStrokingAlphaConstant(this.getFontAlpha());
        }
        if (this.getFontStyle().isLight()) {
            stream.setStrokingColor(this.getBackgroundColor());
            stream.setNonStrokingColor(this.getFontColor());
            state.setNonStrokingAlphaConstant(this.getFontAlpha());
        }
    }

    protected void initPosition(PDPageContentStream stream, float beginX, float beginY) {
        Matrix matrix = new Matrix(1.0f, 0.0f, this.getFontSlope().floatValue(), 1.0f, beginX, beginY);
        stream.setTextMatrix(matrix);
    }

    protected PDRectangle getLineRectangle(float textWidth, Position position) {
        float offsetY = this.getFontSize().floatValue() / 8.0f;
        PDRectangle rectangle = new PDRectangle();
        switch (this.getHorizontalAlignment()) {
            case CENTER: {
                float offset = (this.getContext().getWrapWidth().floatValue() + this.getContext().getPage().getMarginLeft().floatValue() - this.getBeginX().floatValue() - textWidth) / 2.0f;
                rectangle.setLowerLeftX(position.getX().floatValue() + offset);
                rectangle.setUpperRightX(rectangle.getLowerLeftX() + textWidth);
                break;
            }
            case RIGHT: {
                float offset = this.getContext().getWrapWidth().floatValue() + this.getPage().getMarginRight().floatValue() - textWidth;
                rectangle.setLowerLeftX(offset);
                rectangle.setUpperRightX(rectangle.getLowerLeftX() + textWidth);
                break;
            }
            default: {
                rectangle.setLowerLeftX(position.getX().floatValue());
                rectangle.setUpperRightX(position.getX().floatValue() + textWidth);
            }
        }
        rectangle.setLowerLeftY(position.getY().floatValue());
        rectangle.setUpperRightY(position.getY().floatValue() + this.getFontSize().floatValue() - offsetY);
        return rectangle;
    }

    protected void resetPagePosition(Position position, float textWidth) {
        Context context = this.getContext();
        float beginX = position.getX().floatValue() + textWidth + this.getMarginRight().floatValue();
        context.getCursor().reset(beginX, position.getY().floatValue());
        if (Objects.nonNull(this.getCatalog())) {
            this.getCatalog().setEndX(Float.valueOf(beginX));
            this.getCatalog().setEndY(position.getY());
        }
    }

    public CatalogInfo getCatalog() {
        return this.catalog;
    }

    public Integer getTabSize() {
        return this.tabSize;
    }

    public String getText() {
        return this.text;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Boolean getIsHighlight() {
        return this.isHighlight;
    }

    public Float getUnderlineWidth() {
        return this.underlineWidth;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public Boolean getIsUnderline() {
        return this.isUnderline;
    }

    public Float getDeleteLineWidth() {
        return this.deleteLineWidth;
    }

    public Color getDeleteLineColor() {
        return this.deleteLineColor;
    }

    public Boolean getIsDeleteLine() {
        return this.isDeleteLine;
    }

    public InnerDest getInnerDest() {
        return this.innerDest;
    }

    public OuterDest getOuterDest() {
        return this.outerDest;
    }

    public void setCatalog(CatalogInfo catalog) {
        this.catalog = catalog;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setIsHighlight(Boolean isHighlight) {
        this.isHighlight = isHighlight;
    }

    public void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    public void setIsUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    public void setDeleteLineColor(Color deleteLineColor) {
        this.deleteLineColor = deleteLineColor;
    }

    public void setIsDeleteLine(Boolean isDeleteLine) {
        this.isDeleteLine = isDeleteLine;
    }

    public void setInnerDest(InnerDest innerDest) {
        this.innerDest = innerDest;
    }

    public void setOuterDest(OuterDest outerDest) {
        this.outerDest = outerDest;
    }

    @Override
    public String toString() {
        return "Textarea(catalog=" + this.getCatalog() + ", tabSize=" + this.getTabSize() + ", text=" + this.getText() + ", textList=" + this.getTextList() + ", highlightColor=" + this.getHighlightColor() + ", isHighlight=" + this.getIsHighlight() + ", underlineWidth=" + this.getUnderlineWidth() + ", underlineColor=" + this.getUnderlineColor() + ", isUnderline=" + this.getIsUnderline() + ", deleteLineWidth=" + this.getDeleteLineWidth() + ", deleteLineColor=" + this.getDeleteLineColor() + ", isDeleteLine=" + this.getIsDeleteLine() + ", innerDest=" + this.getInnerDest() + ", outerDest=" + this.getOuterDest() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Textarea)) {
            return false;
        }
        Textarea other = (Textarea)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Boolean this$isHighlight = this.getIsHighlight();
        Boolean other$isHighlight = other.getIsHighlight();
        if (this$isHighlight == null ? other$isHighlight != null : !((Object)this$isHighlight).equals(other$isHighlight)) {
            return false;
        }
        Float this$underlineWidth = this.getUnderlineWidth();
        Float other$underlineWidth = other.getUnderlineWidth();
        if (this$underlineWidth == null ? other$underlineWidth != null : !((Object)this$underlineWidth).equals(other$underlineWidth)) {
            return false;
        }
        Boolean this$isUnderline = this.getIsUnderline();
        Boolean other$isUnderline = other.getIsUnderline();
        if (this$isUnderline == null ? other$isUnderline != null : !((Object)this$isUnderline).equals(other$isUnderline)) {
            return false;
        }
        Float this$deleteLineWidth = this.getDeleteLineWidth();
        Float other$deleteLineWidth = other.getDeleteLineWidth();
        if (this$deleteLineWidth == null ? other$deleteLineWidth != null : !((Object)this$deleteLineWidth).equals(other$deleteLineWidth)) {
            return false;
        }
        Boolean this$isDeleteLine = this.getIsDeleteLine();
        Boolean other$isDeleteLine = other.getIsDeleteLine();
        if (this$isDeleteLine == null ? other$isDeleteLine != null : !((Object)this$isDeleteLine).equals(other$isDeleteLine)) {
            return false;
        }
        CatalogInfo this$catalog = this.getCatalog();
        CatalogInfo other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !((Object)this$catalog).equals(other$catalog)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        if (this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList)) {
            return false;
        }
        Color this$highlightColor = this.getHighlightColor();
        Color other$highlightColor = other.getHighlightColor();
        if (this$highlightColor == null ? other$highlightColor != null : !((Object)this$highlightColor).equals(other$highlightColor)) {
            return false;
        }
        Color this$underlineColor = this.getUnderlineColor();
        Color other$underlineColor = other.getUnderlineColor();
        if (this$underlineColor == null ? other$underlineColor != null : !((Object)this$underlineColor).equals(other$underlineColor)) {
            return false;
        }
        Color this$deleteLineColor = this.getDeleteLineColor();
        Color other$deleteLineColor = other.getDeleteLineColor();
        if (this$deleteLineColor == null ? other$deleteLineColor != null : !((Object)this$deleteLineColor).equals(other$deleteLineColor)) {
            return false;
        }
        InnerDest this$innerDest = this.getInnerDest();
        InnerDest other$innerDest = other.getInnerDest();
        if (this$innerDest == null ? other$innerDest != null : !((Object)this$innerDest).equals(other$innerDest)) {
            return false;
        }
        OuterDest this$outerDest = this.getOuterDest();
        OuterDest other$outerDest = other.getOuterDest();
        return !(this$outerDest == null ? other$outerDest != null : !((Object)this$outerDest).equals(other$outerDest));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Textarea;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Boolean $isHighlight = this.getIsHighlight();
        result = result * 59 + ($isHighlight == null ? 43 : ((Object)$isHighlight).hashCode());
        Float $underlineWidth = this.getUnderlineWidth();
        result = result * 59 + ($underlineWidth == null ? 43 : ((Object)$underlineWidth).hashCode());
        Boolean $isUnderline = this.getIsUnderline();
        result = result * 59 + ($isUnderline == null ? 43 : ((Object)$isUnderline).hashCode());
        Float $deleteLineWidth = this.getDeleteLineWidth();
        result = result * 59 + ($deleteLineWidth == null ? 43 : ((Object)$deleteLineWidth).hashCode());
        Boolean $isDeleteLine = this.getIsDeleteLine();
        result = result * 59 + ($isDeleteLine == null ? 43 : ((Object)$isDeleteLine).hashCode());
        CatalogInfo $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : ((Object)$catalog).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        Color $highlightColor = this.getHighlightColor();
        result = result * 59 + ($highlightColor == null ? 43 : ((Object)$highlightColor).hashCode());
        Color $underlineColor = this.getUnderlineColor();
        result = result * 59 + ($underlineColor == null ? 43 : ((Object)$underlineColor).hashCode());
        Color $deleteLineColor = this.getDeleteLineColor();
        result = result * 59 + ($deleteLineColor == null ? 43 : ((Object)$deleteLineColor).hashCode());
        InnerDest $innerDest = this.getInnerDest();
        result = result * 59 + ($innerDest == null ? 43 : ((Object)$innerDest).hashCode());
        OuterDest $outerDest = this.getOuterDest();
        result = result * 59 + ($outerDest == null ? 43 : ((Object)$outerDest).hashCode());
        return result;
    }
}

