/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseFont;
import org.dromara.pdf.pdfbox.core.base.ComponentType;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.Watermark;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.util.TextUtil;

public class TextareaWatermark
extends AbstractBaseFont
implements Watermark {
    private Float beginX;
    private Float beginY;
    private Integer lines;
    private Integer countOfLine;
    private Float spacingOfLine;
    private Integer tabSize;
    private List<String> textList;
    private Float angle;

    public TextareaWatermark(Document document) {
        super.setContext(document.getContext());
    }

    @Override
    public void setFontName(String fontName) {
        super.setFontName(fontName);
        super.setFont(null);
    }

    public void setTabSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("the size can not be less than 0");
        }
        this.tabSize = size;
    }

    @Override
    public ComponentType getType() {
        return ComponentType.WATERMARK;
    }

    @Override
    public void initBase() {
        if (Objects.isNull(this.textList) || this.textList.isEmpty()) {
            throw new IllegalArgumentException("the text list can not be empty");
        }
        if (Objects.isNull((Object)this.getContext().getExecutingComponentType())) {
            this.getContext().setExecutingComponentType(this.getType());
        }
        if (Objects.nonNull(this.getFontName())) {
            PDFont pdFont = PdfHandler.getFontHandler().getPDFont(this.getContext().getTargetDocument(), this.getFontName(), true);
            super.setFont(pdFont);
        }
        if (Objects.isNull(this.lines)) {
            this.lines = 1;
        }
        if (Objects.isNull(this.countOfLine)) {
            this.countOfLine = 1;
        }
        if (Objects.isNull(this.spacingOfLine)) {
            this.spacingOfLine = Float.valueOf(50.0f);
        }
        if (Objects.isNull(this.tabSize)) {
            this.tabSize = 4;
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
    }

    @Override
    public void render(Page page) {
        Objects.requireNonNull(page, "the page can not be null");
        this.init(page);
        this.renderText(page);
    }

    @Override
    public void render(Document document) {
        Objects.requireNonNull(document, "the document can not be null");
        document.getPages().forEach(this::render);
    }

    protected void init(Page page) {
        super.init(page, false);
        this.initBase();
        if (Objects.isNull(this.beginX)) {
            this.beginX = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.beginY)) {
            this.beginY = Float.valueOf(page.getHeight().floatValue() - this.getFontSize().floatValue());
        }
    }

    protected void renderText(Page page) {
        float beginX = this.getBeginX().floatValue();
        float beginY = this.getBeginY().floatValue();
        float maxWidth = 0.0f;
        boolean initFlag = true;
        PDPageContentStream stream = this.initContentStream(page);
        for (int i = 0; i < this.getLines(); ++i) {
            float lastBeginY = beginY;
            for (int j = 0; j < this.getCountOfLine(); ++j) {
                for (String text : this.getTextList()) {
                    stream.beginText();
                    this.initFontColorAndAlpha(stream);
                    this.initPosition(stream, beginX, beginY);
                    String writeText = TextUtil.replaceTab(text, this.getTabSize());
                    stream.showText(writeText);
                    stream.endText();
                    beginY -= this.getFontSize().floatValue();
                    if (!initFlag) continue;
                    maxWidth = Math.max(maxWidth, TextUtil.getTextRealWidth(writeText, this.getFont(), this.getFontSize().floatValue(), this.getCharacterSpacing().floatValue()));
                }
                beginX = beginX + maxWidth + this.getSpacingOfLine().floatValue();
                if (j < this.getCountOfLine() - 1) {
                    beginY = lastBeginY;
                }
                initFlag = false;
            }
            beginX = this.getBeginX().floatValue();
            beginY -= this.getLeading().floatValue();
        }
        stream.close();
    }

    protected PDPageContentStream initContentStream(Page page) {
        Context context = this.getContext();
        PDPageContentStream contentStream = new PDPageContentStream(context.getTargetDocument(), page.getTarget(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        contentStream.setFont(this.getFont(), this.getFontSize().floatValue());
        contentStream.setRenderingMode(this.getFontStyle().getMode());
        contentStream.setCharacterSpacing(this.getCharacterSpacing().floatValue());
        return contentStream;
    }

    protected void initFontColorAndAlpha(PDPageContentStream stream) {
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        stream.setGraphicsStateParameters(state);
        if (this.getFontStyle().isFill()) {
            stream.setNonStrokingColor(this.getFontColor());
            state.setNonStrokingAlphaConstant(this.getFontAlpha());
        }
        if (this.getFontStyle().isStroke()) {
            stream.setStrokingColor(this.getFontColor());
            state.setStrokingAlphaConstant(this.getFontAlpha());
        }
        if (this.getFontStyle().isLight()) {
            stream.setStrokingColor(this.getBackgroundColor());
            stream.setNonStrokingColor(this.getFontColor());
            state.setNonStrokingAlphaConstant(this.getFontAlpha());
        }
    }

    protected void initPosition(PDPageContentStream stream, float beginX, float beginY) {
        Matrix matrix = new Matrix(1.0f, 0.0f, this.getFontSlope().floatValue(), 1.0f, beginX, beginY);
        matrix.rotate(Math.toRadians(this.getAngle().floatValue()));
        stream.setTextMatrix(matrix);
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Integer getLines() {
        return this.lines;
    }

    public Integer getCountOfLine() {
        return this.countOfLine;
    }

    public Float getSpacingOfLine() {
        return this.spacingOfLine;
    }

    public Integer getTabSize() {
        return this.tabSize;
    }

    public List<String> getTextList() {
        return this.textList;
    }

    public Float getAngle() {
        return this.angle;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setLines(Integer lines) {
        this.lines = lines;
    }

    public void setCountOfLine(Integer countOfLine) {
        this.countOfLine = countOfLine;
    }

    public void setSpacingOfLine(Float spacingOfLine) {
        this.spacingOfLine = spacingOfLine;
    }

    public void setTextList(List<String> textList) {
        this.textList = textList;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    @Override
    public String toString() {
        return "TextareaWatermark(beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", lines=" + this.getLines() + ", countOfLine=" + this.getCountOfLine() + ", spacingOfLine=" + this.getSpacingOfLine() + ", tabSize=" + this.getTabSize() + ", textList=" + this.getTextList() + ", angle=" + this.getAngle() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextareaWatermark)) {
            return false;
        }
        TextareaWatermark other = (TextareaWatermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Integer this$lines = this.getLines();
        Integer other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        Integer this$countOfLine = this.getCountOfLine();
        Integer other$countOfLine = other.getCountOfLine();
        if (this$countOfLine == null ? other$countOfLine != null : !((Object)this$countOfLine).equals(other$countOfLine)) {
            return false;
        }
        Float this$spacingOfLine = this.getSpacingOfLine();
        Float other$spacingOfLine = other.getSpacingOfLine();
        if (this$spacingOfLine == null ? other$spacingOfLine != null : !((Object)this$spacingOfLine).equals(other$spacingOfLine)) {
            return false;
        }
        Integer this$tabSize = this.getTabSize();
        Integer other$tabSize = other.getTabSize();
        if (this$tabSize == null ? other$tabSize != null : !((Object)this$tabSize).equals(other$tabSize)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        List<String> this$textList = this.getTextList();
        List<String> other$textList = other.getTextList();
        return !(this$textList == null ? other$textList != null : !((Object)this$textList).equals(other$textList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextareaWatermark;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Integer $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        Integer $countOfLine = this.getCountOfLine();
        result = result * 59 + ($countOfLine == null ? 43 : ((Object)$countOfLine).hashCode());
        Float $spacingOfLine = this.getSpacingOfLine();
        result = result * 59 + ($spacingOfLine == null ? 43 : ((Object)$spacingOfLine).hashCode());
        Integer $tabSize = this.getTabSize();
        result = result * 59 + ($tabSize == null ? 43 : ((Object)$tabSize).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        List<String> $textList = this.getTextList();
        result = result * 59 + ($textList == null ? 43 : ((Object)$textList).hashCode());
        return result;
    }
}

