/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractAnalyzer;
import org.dromara.pdf.pdfbox.core.info.TextInfo;

public abstract class AbstractTextAnalyzer
extends AbstractAnalyzer {
    protected Set<TextInfo> infoSet = new HashSet<TextInfo>(64);

    public AbstractTextAnalyzer(Document document) {
        super(document);
    }

    public abstract void processText(int var1);

    public Set<TextInfo> getInfoSet() {
        return this.infoSet;
    }

    protected static class DefaultTextStripper
    extends PDFTextStripper {
        protected Integer pageIndex;
        protected final Set<TextInfo> infoSet = new HashSet<TextInfo>(64);

        public DefaultTextStripper(Integer pageIndex) {
            this.pageIndex = pageIndex;
            this.setSortByPosition(true);
            this.setStartPage(this.pageIndex + 1);
            this.setEndPage(this.pageIndex + 1);
        }

        protected void writeString(String content, List<TextPosition> textPositions) {
            if (Objects.nonNull(content) && !content.trim().isEmpty()) {
                PDRectangle rectangle = this.getCurrentPage().getMediaBox();
                float width = rectangle.getWidth();
                float height = rectangle.getHeight();
                TextPosition begin = textPositions.get(0);
                TextPosition end = textPositions.get(textPositions.size() - 1);
                TextInfo textInfo = TextInfo.builder().pageIndex(this.pageIndex).pageWidth(Float.valueOf(width)).pageHeight(Float.valueOf(height)).fontName(this.getFontName(begin.getFont().getName())).fontSize(Float.valueOf(begin.getFontSize())).textContent(content).textBeginPosition(begin.getXDirAdj() + "," + (height - begin.getYDirAdj())).textEndPosition(end.getXDirAdj() + "," + (height - end.getYDirAdj())).textTotalWidth(Float.valueOf(end.getXDirAdj() - begin.getXDirAdj())).build();
                this.infoSet.add(textInfo);
                if (AbstractAnalyzer.log.isDebugEnabled()) {
                    AbstractAnalyzer.log.debug((Object)("\n********************************************ANALYZE TEXT BEGIN********************************************\npage index: " + textInfo.getPageIndex() + "\npage width: " + textInfo.getPageWidth() + "\npage height: " + textInfo.getPageHeight() + "\ntext font name: " + textInfo.getFontName() + "\ntext font size: " + textInfo.getFontSize() + "\ntext content: " + textInfo.getTextContent() + "\ntext begin position: " + textInfo.getTextBeginPosition() + "\ntext end position: " + textInfo.getTextEndPosition() + "\ntext total width: " + textInfo.getTextTotalWidth() + "\n*********************************************ANALYZE TEXT END*********************************************"));
                }
            }
        }

        protected String getFontName(String fontName) {
            if (Objects.nonNull(fontName)) {
                return fontName.substring(fontName.indexOf(43) + 1);
            }
            return null;
        }

        public Set<TextInfo> getInfoSet() {
            return this.infoSet;
        }
    }
}

