/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFreeText;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.handler.PdfHandler;
import org.dromara.pdf.pdfbox.support.DefaultFreeTextAppearanceHandler;
import org.dromara.pdf.pdfbox.util.ColorUtil;

public class CommentProcessor
extends AbstractProcessor {
    public CommentProcessor(Document document) {
        super(document);
    }

    public Map<Integer, List<PDAnnotation>> getMap() {
        int pages = this.document.getTotalPageNumber();
        HashMap<Integer, List<PDAnnotation>> data = new HashMap<Integer, List<PDAnnotation>>(pages);
        for (int i = 0; i < pages; ++i) {
            data.put(i, this.getList(i));
        }
        return data;
    }

    public List<PDAnnotation> getList(int ... pageIndexes) {
        ArrayList<PDAnnotation> list = new ArrayList<PDAnnotation>(64);
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                try {
                    this.addAnnotation(pageTree.get(index), list);
                }
                catch (Exception e) {
                    log.warn((Object)("the index['" + index + "'] is invalid, will be ignored"));
                }
            }
        } else {
            for (PDPage page : pageTree) {
                this.addAnnotation(page, list);
            }
        }
        return list;
    }

    public void add(int pageIndex, PDAnnotationFreeText comment) {
        this.add(pageIndex, null, null, null, comment);
    }

    public void add(int pageIndex, String fontName, PDAnnotationFreeText comment) {
        this.add(pageIndex, fontName, null, null, comment);
    }

    public void add(int pageIndex, String fontName, Float fontSize, PDAnnotationFreeText comment) {
        this.add(pageIndex, fontName, fontSize, null, comment);
    }

    public void add(int pageIndex, String fontName, Float fontSize, Color fontColor, PDAnnotationFreeText comment) {
        Objects.requireNonNull(comment, "the comment can not be null");
        try {
            PDFont font = Optional.ofNullable(fontName).map(name -> PdfHandler.getFontHandler().getPDFont(this.getDocument(), (String)name, true)).orElse(this.document.getFont());
            fontSize = Optional.ofNullable(fontSize).orElse(Float.valueOf(10.0f));
            fontColor = Optional.ofNullable(fontColor).orElse(Color.BLACK);
            PDPage page = this.getDocument().getPage(pageIndex);
            comment.setPage(page);
            comment.setDefaultStyleString(this.initDefaultStyleString(font, fontSize, fontColor));
            comment.setCustomAppearanceHandler((PDAppearanceHandler)new DefaultFreeTextAppearanceHandler(this.document, (PDAnnotation)comment, font));
            comment.constructAppearances();
            page.getAnnotations().add(comment);
        }
        catch (Exception e) {
            log.warn((Object)("the page index['" + pageIndex + "'] is invalid, will be ignored"));
        }
    }

    public void set(int pageIndex, String content, PDAnnotationFreeText comment, int ... indexes) {
        Objects.requireNonNull(content, "the content can not be null");
        Objects.requireNonNull(comment, "the comment can not be null");
        HashMap<Integer, Boolean> flagMap = new HashMap<Integer, Boolean>();
        if (Objects.nonNull(indexes)) {
            for (int index : indexes) {
                flagMap.put(index, Boolean.TRUE);
            }
        }
        try {
            int index;
            PDPage page = this.getDocument().getPage(pageIndex);
            List annotations = page.getAnnotations();
            ArrayList<Object> newList = new ArrayList<Object>(annotations.size());
            index = 0;
            for (PDAnnotation annotation : annotations) {
                if (annotation instanceof PDAnnotationText || annotation instanceof PDAnnotationFreeText) {
                    if (Objects.equals(annotation.getContents(), content)) {
                        if (flagMap.isEmpty() || flagMap.containsKey(index)) {
                            newList.add(comment);
                        } else {
                            newList.add(annotation);
                        }
                        ++index;
                        continue;
                    }
                    newList.add(annotation);
                    continue;
                }
                newList.add(annotation);
            }
            page.setAnnotations(newList);
        }
        catch (Exception e) {
            log.warn((Object)("the page index['" + pageIndex + "'] is invalid, will be ignored"));
        }
    }

    public void remove(int pageIndex, String content, int ... indexes) {
        Objects.requireNonNull(content, "the content can not be null");
        HashMap<Integer, Boolean> flagMap = new HashMap<Integer, Boolean>();
        if (Objects.nonNull(indexes)) {
            for (int index : indexes) {
                flagMap.put(index, Boolean.TRUE);
            }
        }
        try {
            int index;
            PDPage page = this.getDocument().getPage(pageIndex);
            List annotations = page.getAnnotations();
            ArrayList<PDAnnotation> newList = new ArrayList<PDAnnotation>(annotations.size());
            index = 0;
            for (PDAnnotation annotation : annotations) {
                if (annotation instanceof PDAnnotationText || annotation instanceof PDAnnotationFreeText) {
                    if (Objects.equals(annotation.getContents(), content)) {
                        if (!flagMap.isEmpty() && !flagMap.containsKey(index)) {
                            newList.add(annotation);
                        }
                        ++index;
                        continue;
                    }
                    newList.add(annotation);
                    continue;
                }
                newList.add(annotation);
            }
            page.setAnnotations(newList);
        }
        catch (Exception e) {
            log.warn((Object)("the page index['" + pageIndex + "'] is invalid, will be ignored"));
        }
    }

    protected void addAnnotation(PDPage page, List<PDAnnotation> list) {
        List annotations = page.getAnnotations();
        for (PDAnnotation annotation : annotations) {
            if (!(annotation instanceof PDAnnotationText) && !(annotation instanceof PDAnnotationFreeText)) continue;
            list.add(annotation);
        }
    }

    protected String initDefaultStyleString(PDFont font, Float fontSize, Color fontColor) {
        return String.join((CharSequence)";", String.join((CharSequence)":", "font", String.join((CharSequence)" ", font.getName(), fontSize + "pt")), String.join((CharSequence)":", "color", ColorUtil.toHexString(fontColor)));
    }
}

