/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.image.BufferedImage;
import java.util.Objects;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class LayerProcessor
extends AbstractProcessor {
    public LayerProcessor(Document document) {
        super(document);
    }

    public void append(String layerName, BufferedImage image, Page page) {
        this.addImage(layerName, false, image, page);
    }

    public void set(String layerName, BufferedImage image, Page page) {
        this.addImage(layerName, true, image, page);
    }

    protected void addImage(String layerName, boolean isReplace, BufferedImage image, Page page) {
        Objects.requireNonNull(layerName, "the layer name can not be null");
        Objects.requireNonNull(image, "the image can not be null");
        Objects.requireNonNull(page, "the page can not be null");
        this.addImage(layerName, isReplace, image, page.getTarget());
    }

    protected void addImage(String layerName, boolean isReplace, BufferedImage image, PDPage page) {
        PDOptionalContentGroup group = this.initOCGroup(layerName, isReplace);
        PDRectangle rectangle = page.getMediaBox();
        PDImageXObject imageXObject = PDImageXObject.createFromByteArray((PDDocument)this.getDocument(), (byte[])ImageUtil.toBytes(image, ImageType.PNG.getType()), (String)ImageType.PNG.getType());
        PDPageContentStream contentStream = new PDPageContentStream(this.getDocument(), page, PDPageContentStream.AppendMode.APPEND, true, true);
        contentStream.beginMarkedContent(COSName.OC, (PDPropertyList)group);
        contentStream.drawImage(imageXObject, 0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight());
        contentStream.endMarkedContent();
        contentStream.close();
    }

    protected PDOptionalContentGroup initOCGroup(String layerName, boolean isReplace) {
        PDOptionalContentGroup group;
        PDOptionalContentProperties ocProperties = this.initOCProperties();
        if (!isReplace && ocProperties.hasGroup(layerName)) {
            throw new IllegalArgumentException("the layer name['" + layerName + "'] already exists");
        }
        if (isReplace) {
            group = ocProperties.getGroup(layerName);
            if (Objects.isNull(group)) {
                group = new PDOptionalContentGroup(layerName);
                ocProperties.addGroup(group);
            }
        } else {
            group = new PDOptionalContentGroup(layerName);
            ocProperties.addGroup(group);
        }
        return group;
    }

    protected PDOptionalContentProperties initOCProperties() {
        PDDocumentCatalog catalog = this.getDocument().getDocumentCatalog();
        PDOptionalContentProperties ocProperties = catalog.getOCProperties();
        if (Objects.isNull(ocProperties)) {
            ocProperties = new PDOptionalContentProperties();
            catalog.setOCProperties(ocProperties);
        }
        return ocProperties;
    }
}

