/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.enums.RenderType;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.FileUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;
import org.dromara.pdf.pdfbox.util.RenderingHintUtil;

public class RenderProcessor
extends AbstractProcessor {
    protected Float dpi;
    protected RenderType renderType;
    protected RenderingHints renderingHints;
    protected Boolean isMemoryOptimization;
    protected Boolean isBinary;
    protected Boolean isGray;
    protected Boolean isAlpha;
    protected MergeType mergeType;

    public RenderProcessor(Document document) {
        super(document);
    }

    public void setDpi(float dpi) {
        this.dpi = Float.valueOf(Math.abs(dpi));
    }

    public void setRenderType(RenderType renderType) {
        Objects.requireNonNull(renderType, "the render type can not be null");
        this.renderType = renderType;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        Objects.requireNonNull(renderingHints, "the render hints can not be null");
        this.renderingHints = renderingHints;
    }

    public void enableOptimization() {
        this.isMemoryOptimization = Boolean.TRUE;
    }

    public void enableBinary() {
        this.isBinary = Boolean.TRUE;
        this.isGray = Boolean.FALSE;
        this.isAlpha = Boolean.FALSE;
    }

    public void enableGray() {
        this.isGray = Boolean.TRUE;
        this.isBinary = Boolean.FALSE;
        this.isAlpha = Boolean.FALSE;
    }

    public void enableAlpha() {
        this.isAlpha = Boolean.TRUE;
        this.isBinary = Boolean.FALSE;
        this.isGray = Boolean.FALSE;
    }

    public void enableHorizontalMerge() {
        this.mergeType = MergeType.HORIZONTAL;
    }

    public void enableVerticalMerge() {
        this.mergeType = MergeType.VERTICAL;
    }

    public void image(String outputPath, ImageType imageType) {
        this.image(outputPath, imageType, null);
    }

    public void image(String outputPath, ImageType imageType, String prefix) {
        Objects.requireNonNull(outputPath, "the output path can not be null");
        Objects.requireNonNull(imageType, "the image type can not be null");
        this.init();
        if (Objects.isNull(prefix)) {
            prefix = "x-easypdf";
        }
        PDFRenderer renderer = new PDFRenderer(this.getDocument());
        renderer.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        renderer.setDefaultDestination(this.renderType.getDestination());
        if (Objects.nonNull((Object)this.mergeType)) {
            this.writeImageByMerge(renderer, imageType, outputPath, prefix);
        } else {
            this.writeImageBySingle(renderer, imageType, outputPath, prefix);
        }
    }

    public BufferedImage image(ImageType imageType, int pageIndex) {
        Objects.requireNonNull(imageType, "the image type can not be null");
        this.init();
        PDFRenderer renderer = new PDFRenderer(this.getDocument());
        renderer.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        renderer.setDefaultDestination(this.renderType.getDestination());
        return renderer.renderImageWithDPI(Math.min(Math.max(pageIndex, 0), this.getDocument().getNumberOfPages() - 1), this.dpi.floatValue(), this.getColorType());
    }

    public void image(OutputStream outputStream, ImageType imageType, int ... pageIndexes) {
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        Objects.requireNonNull(imageType, "the image type can not be null");
        Objects.requireNonNull(pageIndexes, "the page indexes can not be null");
        this.init();
        PDFRenderer renderer = new PDFRenderer(this.getDocument());
        renderer.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        renderer.setDefaultDestination(this.renderType.getDestination());
        if (Objects.nonNull((Object)this.mergeType)) {
            ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(pageIndexes.length);
            for (int index : pageIndexes) {
                imageList.add(renderer.renderImageWithDPI(Math.min(Math.max(index, 0), this.getDocument().getNumberOfPages() - 1), this.dpi.floatValue(), this.getColorType()));
            }
            BufferedImage bufferedImage = ImageUtil.join(imageList, this.mergeType == MergeType.HORIZONTAL);
            ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)imageType.name().toLowerCase(), (OutputStream)outputStream, (int)this.dpi.intValue());
        } else {
            for (int index : pageIndexes) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(Math.min(Math.max(index, 0), this.getDocument().getNumberOfPages() - 1), this.dpi.floatValue(), this.getColorType());
                ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)imageType.name(), (OutputStream)outputStream, (int)this.dpi.intValue());
            }
        }
    }

    protected void init() {
        if (Objects.isNull(this.dpi)) {
            this.dpi = Float.valueOf(72.0f);
        }
        if (Objects.isNull((Object)this.renderType)) {
            this.renderType = RenderType.EXPORT;
        }
        if (Objects.isNull(this.renderingHints)) {
            this.renderingHints = RenderingHintUtil.createDefaultRenderingHints();
        }
        if (Objects.isNull(this.isMemoryOptimization)) {
            this.isMemoryOptimization = Boolean.FALSE;
        }
        if (Objects.isNull(this.isBinary)) {
            this.isBinary = Boolean.FALSE;
        }
        if (Objects.isNull(this.isGray)) {
            this.isGray = Boolean.FALSE;
        }
        if (Objects.isNull(this.isAlpha)) {
            this.isAlpha = Boolean.FALSE;
        }
    }

    protected void writeImageByMerge(PDFRenderer renderer, ImageType imageType, String outputPath, String prefix) {
        String imageTypeName = imageType.getType();
        int pageCount = this.getDocument().getNumberOfPages();
        ArrayList<BufferedImage> imageList = new ArrayList<BufferedImage>(pageCount);
        for (int i = 0; i < pageCount; ++i) {
            imageList.add(renderer.renderImageWithDPI(i, this.dpi.floatValue(), this.getColorType()));
        }
        BufferedImage bufferedImage = ImageUtil.join(imageList, this.mergeType == MergeType.HORIZONTAL);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(outputPath + File.separator + prefix + '.' + imageTypeName, new String[0])), new OpenOption[0]));){
            ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)imageTypeName, (OutputStream)outputStream, (int)this.dpi.intValue());
        }
    }

    protected void writeImageBySingle(PDFRenderer renderer, ImageType imageType, String outputPath, String prefix) {
        String imageTypeName = imageType.getType();
        int pageCount = this.getDocument().getNumberOfPages();
        for (int index = 0; index < pageCount; ++index) {
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(index + 1).append('.').append(imageTypeName);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(fileNameBuilder.toString(), new String[0])), new OpenOption[0]));){
                BufferedImage bufferedImage = renderer.renderImageWithDPI(index, this.dpi.floatValue(), this.getColorType());
                ImageIOUtil.writeImage((BufferedImage)bufferedImage, (String)imageTypeName, (OutputStream)outputStream, (int)this.dpi.intValue());
                continue;
            }
        }
    }

    protected org.apache.pdfbox.rendering.ImageType getColorType() {
        if (this.isBinary.booleanValue()) {
            return org.apache.pdfbox.rendering.ImageType.BINARY;
        }
        if (this.isGray.booleanValue()) {
            return org.apache.pdfbox.rendering.ImageType.GRAY;
        }
        if (this.isAlpha.booleanValue()) {
            return org.apache.pdfbox.rendering.ImageType.ARGB;
        }
        return org.apache.pdfbox.rendering.ImageType.RGB;
    }

    protected static enum MergeType {
        HORIZONTAL,
        VERTICAL;

    }
}

