/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.pdfbox.core.base.AbstractBaseBorder;
import org.dromara.pdf.pdfbox.core.base.Context;
import org.dromara.pdf.pdfbox.core.enums.BorderStyle;

public class BorderUtil {
    public static void drawBorderWithBase(AbstractBaseBorder base, PDRectangle rectangle) {
        Context context = base.getContext();
        PDPageContentStream stream = new PDPageContentStream(context.getTargetDocument(), context.getTargetPage(), base.getContentMode().getMode(), true, base.getIsResetContentStream().booleanValue());
        BorderUtil.drawNormalBorder(stream, rectangle, base);
        stream.close();
    }

    public static void drawNormalBorder(PDPageContentStream stream, PDRectangle rectangle, AbstractBaseBorder base) {
        stream.setLineWidth(base.getBorderWidth().floatValue());
        stream.setLineCapStyle(0);
        BorderUtil.line(stream, rectangle, base);
    }

    private static void line(PDPageContentStream stream, PDRectangle rectangle, AbstractBaseBorder base) {
        if (base.getBorderStyle() == BorderStyle.SOLID) {
            BorderUtil.drawSolidLine(stream, rectangle, base);
            return;
        }
        if (base.getBorderStyle() == BorderStyle.DOTTED) {
            BorderUtil.drawDottedLine(stream, rectangle, base);
        }
    }

    private static void drawSolidLine(PDPageContentStream stream, PDRectangle rectangle, AbstractBaseBorder base) {
        if (base.getIsBorderTop().booleanValue()) {
            stream.setStrokingColor(base.getBorderTopColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getUpperRightY());
            stream.stroke();
        }
        if (base.getIsBorderBottom().booleanValue()) {
            stream.setStrokingColor(base.getBorderBottomColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.stroke();
        }
        if (base.getIsBorderLeft().booleanValue()) {
            stream.setStrokingColor(base.getBorderLeftColor());
            stream.moveTo(rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getLowerLeftX(), rectangle.getUpperRightY());
            stream.stroke();
        }
        if (base.getIsBorderRight().booleanValue()) {
            stream.setStrokingColor(base.getBorderRightColor());
            stream.moveTo(rectangle.getUpperRightX(), rectangle.getLowerLeftY());
            stream.lineTo(rectangle.getUpperRightX(), rectangle.getUpperRightY());
            stream.stroke();
        }
    }

    private static void drawDottedLine(PDPageContentStream stream, PDRectangle rectangle, AbstractBaseBorder base) {
        if (base.getIsBorderTop().booleanValue()) {
            BorderUtil.drawDottedLine(stream, base.getBorderTopColor(), base.getBorderLineLength().floatValue(), base.getBorderLineSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getUpperRightY());
        }
        if (base.getIsBorderBottom().booleanValue()) {
            BorderUtil.drawDottedLine(stream, base.getBorderBottomColor(), base.getBorderLineLength().floatValue(), base.getBorderLineSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
        if (base.getIsBorderLeft().booleanValue()) {
            BorderUtil.drawDottedLine(stream, base.getBorderLeftColor(), base.getBorderLineLength().floatValue(), base.getBorderLineSpacing().floatValue(), rectangle.getLowerLeftX(), rectangle.getUpperRightY(), rectangle.getLowerLeftX(), rectangle.getLowerLeftY());
        }
        if (base.getIsBorderRight().booleanValue()) {
            BorderUtil.drawDottedLine(stream, base.getBorderRightColor(), base.getBorderLineLength().floatValue(), base.getBorderLineSpacing().floatValue(), rectangle.getUpperRightX(), rectangle.getUpperRightY(), rectangle.getUpperRightX(), rectangle.getLowerLeftY());
        }
    }

    private static void drawDottedLine(PDPageContentStream contentStream, Color color, float lineLength, float lineSpace, float beginX, float beginY, float endX, float endY) {
        boolean isHorizontal;
        contentStream.setStrokingColor(color);
        float totalLength = endX - beginX;
        boolean bl = isHorizontal = totalLength > 0.0f;
        if (!isHorizontal) {
            totalLength = beginY - endY;
        }
        float lineWidth = lineLength + lineSpace;
        int count = Math.max((int)(totalLength / lineWidth), 1);
        float offset = Math.abs((totalLength - (float)count * lineWidth + lineSpace) / 2.0f);
        if (lineLength > totalLength) {
            lineLength = totalLength;
            offset = 0.0f;
        }
        if (isHorizontal) {
            beginX += offset;
        } else {
            beginY -= offset;
        }
        for (int i = 0; i < count; ++i) {
            contentStream.moveTo(beginX, beginY);
            if (isHorizontal) {
                contentStream.lineTo(beginX += lineLength, beginY);
                beginX += lineSpace;
                continue;
            }
            contentStream.lineTo(beginX, beginY -= lineLength);
            beginY -= lineSpace;
        }
        contentStream.stroke();
    }
}

