/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class TextUtil {
    public static String splitText(String text, float lineWidth, PDFont font, float fontSize, float characterSpacing) {
        if (TextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return null;
        }
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = TextUtil.getTextRealWidth(tempText, font, fontSize, characterSpacing);
            if (!(lineRealWidth > lineWidth)) continue;
            return text.substring(beginIndex, i - 1);
        }
        return text;
    }

    public static List<String> splitLines(String text, float lineWidth, PDFont font, float fontSize, float characterSpacing) {
        if (TextUtil.isBlank(text) || lineWidth - fontSize < 0.0f) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> lineList = new ArrayList<String>(1024);
        int fontCount = Math.max(1, (int)(lineWidth / (fontSize + characterSpacing)));
        int beginIndex = 0;
        int len = text.length();
        for (int i = fontCount; i <= len; ++i) {
            String tempText = text.substring(beginIndex, i);
            float lineRealWidth = TextUtil.getTextRealWidth(tempText, font, fontSize, characterSpacing);
            if (!(lineRealWidth > lineWidth)) continue;
            lineList.add(text.substring(beginIndex, i - 1));
            beginIndex = i - 1;
            i = i + fontCount - 1;
            if (i < len) continue;
            lineList.add(text.substring(beginIndex));
        }
        if (beginIndex + fontCount < text.length() || lineList.isEmpty()) {
            lineList.add(text.substring(beginIndex));
        }
        return lineList;
    }

    public static float getTextRealWidth(String text, PDFont font, float fontSize, float characterSpacing) {
        if (Objects.isNull(text)) {
            return 0.0f;
        }
        return fontSize * font.getStringWidth(text) / 1000.0f + (float)(text.length() - 1) * characterSpacing;
    }

    public static String escapeForRegex(String text) {
        char[] charArray;
        if (TextUtil.isBlank(text)) {
            return "";
        }
        char[] escapeChars = new char[]{'$', '(', ')', '*', '+', '.', '[', ']', '?', '\\', '^', '{', '}', '|'};
        StringBuilder builder = new StringBuilder();
        for (char c : charArray = text.toCharArray()) {
            for (char escapeChar : escapeChars) {
                if (escapeChar != c) continue;
                builder.append('\\');
                break;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String filterAll(String text) {
        return text.replaceAll("[\r\b\f]", "");
    }

    public static String replaceAll(String text, Map<String, String> replaceMap) {
        if (TextUtil.isBlank(text)) {
            return "";
        }
        if (Objects.isNull(replaceMap) || replaceMap.isEmpty()) {
            return text;
        }
        String temp = text;
        Set<Map.Entry<String, String>> entrySet = replaceMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            temp = temp.replaceAll(entry.getKey(), entry.getValue());
        }
        return temp;
    }

    public static boolean isBlank(String text) {
        return !TextUtil.isNotBlank(text);
    }

    public static boolean isNotBlank(String text) {
        return Objects.nonNull(text) && !text.trim().isEmpty();
    }

    public static String spacing(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    public static String replaceTab(String text, int size) {
        int tab = 9;
        char[] charArray = TextUtil.filterAll(text).toCharArray();
        StringBuilder builder = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (char c : charArray) {
            if (temp.length() == size) {
                builder.append((CharSequence)temp);
                temp = new StringBuilder();
            }
            if (c == '\t') {
                temp.append(TextUtil.spacing(size - temp.length()));
                continue;
            }
            temp.append(c);
        }
        return builder.append((CharSequence)temp).toString();
    }
}

