/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import org.dromara.pdf.pdfbox.core.base.AbstractBase;
import org.dromara.pdf.pdfbox.core.base.BorderData;
import org.dromara.pdf.pdfbox.core.base.PagingEvent;
import org.dromara.pdf.pdfbox.core.base.config.BorderConfiguration;

public class BorderInfo
extends BorderData {
    protected Color backgroundColor;
    protected Integer pagingCount;
    protected Float width;
    protected Float height;
    protected Float beginX;
    protected Float beginY;
    protected PagingEvent pagingEvent;
    protected Boolean isPagingBorder;
    protected Boolean isFirstComponent;
    protected Boolean isAlreadyRendered;

    public BorderInfo(AbstractBase base, BorderConfiguration configuration, Color backgroundColor, float width, float height, float beginX, float beginY, PagingEvent pagingEvent, Boolean isPagingBorder) {
        this.init(base, configuration, backgroundColor, width, height, beginX, beginY, pagingEvent, isPagingBorder);
    }

    public void pagingCount() {
        BorderInfo borderInfo = this;
        Integer n = borderInfo.pagingCount;
        Integer n2 = borderInfo.pagingCount = Integer.valueOf(borderInfo.pagingCount + 1);
    }

    public boolean isPaging() {
        return this.pagingCount > 0;
    }

    protected void init(AbstractBase base, BorderConfiguration configuration, Color backgroundColor, float width, float height, float beginX, float beginY, PagingEvent pagingEvent, Boolean isPagingBorder) {
        super.init(base, configuration);
        this.backgroundColor = backgroundColor;
        this.pagingCount = 0;
        this.width = Float.valueOf(width);
        this.height = Float.valueOf(height);
        this.beginX = Float.valueOf(beginX);
        this.beginY = Float.valueOf(beginY);
        this.pagingEvent = pagingEvent;
        this.isPagingBorder = isPagingBorder;
        this.isFirstComponent = Boolean.TRUE;
        this.isAlreadyRendered = Boolean.FALSE;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Integer getPagingCount() {
        return this.pagingCount;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public PagingEvent getPagingEvent() {
        return this.pagingEvent;
    }

    public Boolean getIsPagingBorder() {
        return this.isPagingBorder;
    }

    public Boolean getIsFirstComponent() {
        return this.isFirstComponent;
    }

    public Boolean getIsAlreadyRendered() {
        return this.isAlreadyRendered;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setPagingCount(Integer pagingCount) {
        this.pagingCount = pagingCount;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public void setBeginX(Float beginX) {
        this.beginX = beginX;
    }

    public void setBeginY(Float beginY) {
        this.beginY = beginY;
    }

    public void setPagingEvent(PagingEvent pagingEvent) {
        this.pagingEvent = pagingEvent;
    }

    public void setIsPagingBorder(Boolean isPagingBorder) {
        this.isPagingBorder = isPagingBorder;
    }

    public void setIsFirstComponent(Boolean isFirstComponent) {
        this.isFirstComponent = isFirstComponent;
    }

    public void setIsAlreadyRendered(Boolean isAlreadyRendered) {
        this.isAlreadyRendered = isAlreadyRendered;
    }

    @Override
    public String toString() {
        return "BorderInfo(backgroundColor=" + this.getBackgroundColor() + ", pagingCount=" + this.getPagingCount() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", pagingEvent=" + this.getPagingEvent() + ", isPagingBorder=" + this.getIsPagingBorder() + ", isFirstComponent=" + this.getIsFirstComponent() + ", isAlreadyRendered=" + this.getIsAlreadyRendered() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BorderInfo)) {
            return false;
        }
        BorderInfo other = (BorderInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$pagingCount = this.getPagingCount();
        Integer other$pagingCount = other.getPagingCount();
        if (this$pagingCount == null ? other$pagingCount != null : !((Object)this$pagingCount).equals(other$pagingCount)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isPagingBorder = this.getIsPagingBorder();
        Boolean other$isPagingBorder = other.getIsPagingBorder();
        if (this$isPagingBorder == null ? other$isPagingBorder != null : !((Object)this$isPagingBorder).equals(other$isPagingBorder)) {
            return false;
        }
        Boolean this$isFirstComponent = this.getIsFirstComponent();
        Boolean other$isFirstComponent = other.getIsFirstComponent();
        if (this$isFirstComponent == null ? other$isFirstComponent != null : !((Object)this$isFirstComponent).equals(other$isFirstComponent)) {
            return false;
        }
        Boolean this$isAlreadyRendered = this.getIsAlreadyRendered();
        Boolean other$isAlreadyRendered = other.getIsAlreadyRendered();
        if (this$isAlreadyRendered == null ? other$isAlreadyRendered != null : !((Object)this$isAlreadyRendered).equals(other$isAlreadyRendered)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        PagingEvent this$pagingEvent = this.getPagingEvent();
        PagingEvent other$pagingEvent = other.getPagingEvent();
        return !(this$pagingEvent == null ? other$pagingEvent != null : !this$pagingEvent.equals(other$pagingEvent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BorderInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $pagingCount = this.getPagingCount();
        result = result * 59 + ($pagingCount == null ? 43 : ((Object)$pagingCount).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isPagingBorder = this.getIsPagingBorder();
        result = result * 59 + ($isPagingBorder == null ? 43 : ((Object)$isPagingBorder).hashCode());
        Boolean $isFirstComponent = this.getIsFirstComponent();
        result = result * 59 + ($isFirstComponent == null ? 43 : ((Object)$isFirstComponent).hashCode());
        Boolean $isAlreadyRendered = this.getIsAlreadyRendered();
        result = result * 59 + ($isAlreadyRendered == null ? 43 : ((Object)$isAlreadyRendered).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        PagingEvent $pagingEvent = this.getPagingEvent();
        result = result * 59 + ($pagingEvent == null ? 43 : $pagingEvent.hashCode());
        return result;
    }
}

