/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Position;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;

public class Circle
extends AbstractComponent {
    protected Float radius;
    protected Color borderColor;
    protected Color backgroundColor;

    public Circle(Page page) {
        super(page);
    }

    public void setRadius(float radius) {
        if (radius < 1.0f) {
            throw new IllegalArgumentException("the radius can not be less than 1");
        }
        this.radius = Float.valueOf(radius);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.CIRCLE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.radius, "the radius can not be null");
        super.init();
        if (Objects.isNull(this.borderColor)) {
            this.borderColor = Color.BLACK;
        }
        float diameter = this.getMinWidth();
        this.initBeginXY(diameter, diameter);
    }

    @Override
    protected float getMinWidth() {
        return this.getRadius().floatValue() * 2.0f;
    }

    protected List<Position> initPosition(float radius) {
        float x = this.getBeginX().floatValue() + this.radius.floatValue() + this.getRelativeBeginX().floatValue();
        float y = this.getBeginY().floatValue() + this.radius.floatValue() - this.getRelativeBeginY().floatValue();
        ArrayList<Position> list = new ArrayList<Position>(4);
        list.add(new Position(Float.valueOf(x), Float.valueOf(y + radius)));
        list.add(new Position(Float.valueOf(x + radius), Float.valueOf(y)));
        list.add(new Position(Float.valueOf(x), Float.valueOf(y - radius)));
        list.add(new Position(Float.valueOf(x - radius), Float.valueOf(y)));
        return list;
    }

    protected List<Position> initCtrlPosition(List<Position> positions) {
        float offset = this.getRadius().floatValue() * 0.55191505f;
        ArrayList<Position> points = new ArrayList<Position>(8);
        Position top = positions.get(0);
        points.add(new Position(Float.valueOf(top.getX().floatValue() + offset), top.getY()));
        Position right = positions.get(1);
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() + offset)));
        points.add(new Position(right.getX(), Float.valueOf(right.getY().floatValue() - offset)));
        Position bottom = positions.get(2);
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() + offset), bottom.getY()));
        points.add(new Position(Float.valueOf(bottom.getX().floatValue() - offset), bottom.getY()));
        Position left = positions.get(3);
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() - offset)));
        points.add(new Position(left.getX(), Float.valueOf(left.getY().floatValue() + offset)));
        points.add(new Position(Float.valueOf(top.getX().floatValue() - offset), top.getY()));
        return points;
    }

    @Override
    protected void writeContents() {
        if (!this.getContext().getIsVirtualRender().booleanValue()) {
            PDPageContentStream contentStream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
            this.renderCircle(contentStream, this.getRadius().floatValue(), this.getBorderColor());
            if (Objects.nonNull(this.getBackgroundColor())) {
                this.renderCircle(contentStream, this.getRadius().floatValue() - this.getBorderConfiguration().getBorderLineWidth().floatValue(), this.getBackgroundColor());
            }
            contentStream.close();
        }
    }

    protected void renderCircle(PDPageContentStream contentStream, float radius, Color color) {
        List<Position> positions = this.initPosition(radius);
        List<Position> ctrlPositions = this.initCtrlPosition(positions);
        Position dataTop = positions.get(0);
        Position ctrlTopRight = ctrlPositions.get(0);
        Position ctrlRightTop = ctrlPositions.get(1);
        Position dataRight = positions.get(1);
        Position ctrlRightBottom = ctrlPositions.get(2);
        Position ctrlBottomRight = ctrlPositions.get(3);
        Position dataBottom = positions.get(2);
        Position ctrlBottomLeft = ctrlPositions.get(4);
        Position ctrlLeftBottom = ctrlPositions.get(5);
        Position dataLeft = positions.get(3);
        Position ctrlLeftTop = ctrlPositions.get(6);
        Position ctrlTopLeft = ctrlPositions.get(7);
        contentStream.moveTo(dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.curveTo(ctrlTopRight.getX().floatValue(), ctrlTopRight.getY().floatValue(), ctrlRightTop.getX().floatValue(), ctrlRightTop.getY().floatValue(), dataRight.getX().floatValue(), dataRight.getY().floatValue());
        contentStream.curveTo(ctrlRightBottom.getX().floatValue(), ctrlRightBottom.getY().floatValue(), ctrlBottomRight.getX().floatValue(), ctrlBottomRight.getY().floatValue(), dataBottom.getX().floatValue(), dataBottom.getY().floatValue());
        contentStream.curveTo(ctrlBottomLeft.getX().floatValue(), ctrlBottomLeft.getY().floatValue(), ctrlLeftBottom.getX().floatValue(), ctrlLeftBottom.getY().floatValue(), dataLeft.getX().floatValue(), dataLeft.getY().floatValue());
        contentStream.curveTo(ctrlLeftTop.getX().floatValue(), ctrlLeftTop.getY().floatValue(), ctrlTopLeft.getX().floatValue(), ctrlTopLeft.getY().floatValue(), dataTop.getX().floatValue(), dataTop.getY().floatValue());
        contentStream.setNonStrokingColor(color);
        contentStream.fill();
    }

    @Override
    protected void reset() {
        float x = this.getBeginX().floatValue() + this.getMinWidth() + this.getMarginRight().floatValue();
        float y = this.getBeginY().floatValue();
        super.reset(this.getType(), x, y);
    }

    public Float getRadius() {
        return this.radius;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public String toString() {
        return "Circle(radius=" + this.getRadius() + ", borderColor=" + this.getBorderColor() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$radius = this.getRadius();
        Float other$radius = other.getRadius();
        if (this$radius == null ? other$radius != null : !((Object)this$radius).equals(other$radius)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Circle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $radius = this.getRadius();
        result = result * 59 + ($radius == null ? 43 : ((Object)$radius).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }
}

