/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.component;

import java.awt.Color;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.component.AbstractComponent;
import org.dromara.pdf.pdfbox.core.enums.ComponentType;
import org.dromara.pdf.pdfbox.core.enums.LineCapStyle;
import org.dromara.pdf.pdfbox.util.CommonUtil;

public class DiagonalLine
extends AbstractComponent {
    protected Float lineWidth;
    protected Color lineColor;
    protected Float angle;
    protected Float alpha;
    protected Float endX;
    protected Float endY;

    public DiagonalLine(Page page) {
        super(page);
    }

    @Override
    public ComponentType getType() {
        return ComponentType.DIAGONAL_LINE;
    }

    @Override
    protected void init() {
        Objects.requireNonNull(this.beginX, "the begin x can not be null");
        Objects.requireNonNull(this.beginY, "the begin y can not be null");
        Objects.requireNonNull(this.endX, "the end x can not be null");
        Objects.requireNonNull(this.endY, "the end y can not be null");
        super.init();
        if (Objects.isNull(this.lineWidth)) {
            this.lineWidth = Float.valueOf(1.0f);
        }
        if (Objects.isNull(this.lineColor)) {
            this.lineColor = Color.BLACK;
        }
        if (Objects.isNull(this.angle)) {
            this.angle = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.alpha)) {
            this.alpha = Float.valueOf(1.0f);
        }
    }

    @Override
    protected float getMinWidth() {
        return 0.0f;
    }

    @Override
    protected void writeContents() {
        if (this.getAngle().floatValue() % 180.0f == 0.0f) {
            this.processNotRotation();
        } else {
            this.processRotation();
        }
    }

    protected void processRotation() {
        float beginX = 0.0f;
        float beginY = 0.0f;
        float width = this.getEndX().floatValue() - this.getBeginX().floatValue();
        float height = Math.abs(this.getBeginY().floatValue() - this.getEndY().floatValue());
        PDPageContentStream stream = this.initContentStream();
        CommonUtil.initMatrix(stream, this.getBeginX().floatValue(), this.getBeginY().floatValue(), this.getRelativeBeginX().floatValue(), this.getRelativeBeginY().floatValue(), width, height, this.getAngle().floatValue(), this.getAlpha().floatValue());
        stream.moveTo(beginX, beginY);
        stream.lineTo(width, height);
        stream.stroke();
        stream.close();
    }

    protected void processNotRotation() {
        PDPageContentStream stream = this.initContentStream();
        stream.moveTo(this.getBeginX().floatValue() + this.getRelativeBeginX().floatValue(), this.getBeginY().floatValue() + this.getRelativeBeginY().floatValue());
        stream.lineTo(this.getEndX().floatValue(), this.getEndY().floatValue());
        stream.stroke();
        stream.close();
    }

    @Override
    protected void reset() {
        super.reset(this.getType(), this.getEndX().floatValue(), this.getEndY().floatValue());
    }

    protected PDPageContentStream initContentStream() {
        PDPageContentStream stream = new PDPageContentStream(this.getContext().getTargetDocument(), this.getContext().getTargetPage(), this.getContentMode().getMode(), true, this.getIsResetContentStream().booleanValue());
        stream.setLineWidth(this.getLineWidth().floatValue());
        stream.setStrokingColor(this.getLineColor());
        stream.setLineCapStyle(LineCapStyle.NORMAL.getType());
        return stream;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public Float getAngle() {
        return this.angle;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Float getEndX() {
        return this.endX;
    }

    public Float getEndY() {
        return this.endY;
    }

    public void setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setAngle(Float angle) {
        this.angle = angle;
    }

    public void setAlpha(Float alpha) {
        this.alpha = alpha;
    }

    public void setEndX(Float endX) {
        this.endX = endX;
    }

    public void setEndY(Float endY) {
        this.endY = endY;
    }

    @Override
    public String toString() {
        return "DiagonalLine(lineWidth=" + this.getLineWidth() + ", lineColor=" + this.getLineColor() + ", angle=" + this.getAngle() + ", alpha=" + this.getAlpha() + ", endX=" + this.getEndX() + ", endY=" + this.getEndY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiagonalLine)) {
            return false;
        }
        DiagonalLine other = (DiagonalLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$lineWidth = this.getLineWidth();
        Float other$lineWidth = other.getLineWidth();
        if (this$lineWidth == null ? other$lineWidth != null : !((Object)this$lineWidth).equals(other$lineWidth)) {
            return false;
        }
        Float this$angle = this.getAngle();
        Float other$angle = other.getAngle();
        if (this$angle == null ? other$angle != null : !((Object)this$angle).equals(other$angle)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Float this$endX = this.getEndX();
        Float other$endX = other.getEndX();
        if (this$endX == null ? other$endX != null : !((Object)this$endX).equals(other$endX)) {
            return false;
        }
        Float this$endY = this.getEndY();
        Float other$endY = other.getEndY();
        if (this$endY == null ? other$endY != null : !((Object)this$endY).equals(other$endY)) {
            return false;
        }
        Color this$lineColor = this.getLineColor();
        Color other$lineColor = other.getLineColor();
        return !(this$lineColor == null ? other$lineColor != null : !((Object)this$lineColor).equals(other$lineColor));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DiagonalLine;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $lineWidth = this.getLineWidth();
        result = result * 59 + ($lineWidth == null ? 43 : ((Object)$lineWidth).hashCode());
        Float $angle = this.getAngle();
        result = result * 59 + ($angle == null ? 43 : ((Object)$angle).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Float $endX = this.getEndX();
        result = result * 59 + ($endX == null ? 43 : ((Object)$endX).hashCode());
        Float $endY = this.getEndY();
        result = result * 59 + ($endY == null ? 43 : ((Object)$endY).hashCode());
        Color $lineColor = this.getLineColor();
        result = result * 59 + ($lineColor == null ? 43 : ((Object)$lineColor).hashCode());
        return result;
    }
}

