/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.comparator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pdfbox.text.PDFTextStripper;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.comparator.AbstractComparator;
import org.dromara.pdf.pdfbox.core.info.TextCompareInfo;

public class TextComparator
extends AbstractComparator {
    public TextComparator(Document document) {
        super(document);
    }

    public Map<Integer, List<TextCompareInfo>> compareTo(Document other, int ... pageIndexes) {
        HashMap<Integer, List<TextCompareInfo>> result = new HashMap<Integer, List<TextCompareInfo>>(this.document.getTotalPageNumber());
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int pageIndex : pageIndexes) {
                result.put(pageIndex, this.compareTexts(other, pageIndex));
            }
        } else {
            for (int pageIndex = 0; pageIndex < this.document.getTotalPageNumber(); ++pageIndex) {
                result.put(pageIndex, this.compareTexts(other, pageIndex));
            }
        }
        return result;
    }

    protected List<TextCompareInfo> compareTexts(Document other, int pageIndex) {
        ArrayList<TextCompareInfo> results = new ArrayList<TextCompareInfo>(64);
        List<String> list = this.processPageText(this.document, pageIndex);
        List<String> otherList = this.processPageText(other, pageIndex);
        for (int i = 0; i < list.size(); ++i) {
            String text = list.get(i);
            if (Objects.nonNull(otherList) && otherList.size() > i) {
                String otherText = otherList.get(i);
                if (Objects.equals(text, otherText)) continue;
                results.add(TextCompareInfo.builder().pageIndex(pageIndex).lineNumber(i).content(text).compareContent(otherText).build());
                continue;
            }
            results.add(TextCompareInfo.builder().pageIndex(pageIndex).lineNumber(i).content(text).build());
        }
        return results;
    }

    protected List<String> processPageText(Document document, int pageIndex) {
        if (Objects.isNull(document.getPage(pageIndex))) {
            return null;
        }
        PDFTextStripper stripper = new PDFTextStripper();
        stripper.setSortByPosition(true);
        stripper.setStartPage(pageIndex + 1);
        stripper.setEndPage(pageIndex + 1);
        return Arrays.asList(stripper.getText(document.getTarget()).split(System.lineSeparator()));
    }
}

