/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.awt.RenderingHints;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Objects;
import java.util.Optional;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.PrintOrientation;
import org.dromara.pdf.pdfbox.core.enums.PrintScaling;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.util.RenderingHintUtil;

public class PrintProcessor
extends AbstractProcessor {
    protected Integer beginPageNo;
    protected Integer endPageNo;
    protected PrintScaling scaling;
    protected PrintOrientation orientation;
    protected Float dpi;
    protected RenderingHints renderingHints;
    protected Boolean isShowBorder;
    protected Boolean isCenter;
    protected Boolean isMemoryOptimization;
    protected Integer count;

    public PrintProcessor(Document document) {
        super(document);
    }

    public void setBeginPageNo(Integer beginPageNo) {
        if (Objects.nonNull(beginPageNo) && beginPageNo < 1) {
            throw new IllegalArgumentException("the begin page no must be greater than 1");
        }
        this.beginPageNo = beginPageNo;
    }

    public void setEndPageNo(Integer endPageNo) {
        int pages = this.getDocument().getNumberOfPages();
        if (Objects.nonNull(endPageNo) && endPageNo > pages) {
            throw new IllegalArgumentException("the end page no must not be greater than the page num of the document['" + pages + "']");
        }
        if (Objects.nonNull(endPageNo) && endPageNo < Optional.ofNullable(this.beginPageNo).orElse(1)) {
            throw new IllegalArgumentException("the end page no must not be less than begin page num or 1");
        }
        this.endPageNo = endPageNo;
    }

    public void print() {
        this.init();
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
        job.setPageable(this.initPageable());
        job.setCopies(this.count);
        job.print(new HashPrintRequestAttributeSet(new PageRanges(this.beginPageNo, this.endPageNo)));
    }

    protected void init() {
        if (Objects.isNull(this.beginPageNo)) {
            this.beginPageNo = 1;
        }
        if (Objects.isNull(this.endPageNo)) {
            this.endPageNo = this.getDocument().getNumberOfPages();
        }
        if (Objects.isNull((Object)this.scaling)) {
            this.scaling = PrintScaling.ACTUAL_SIZE;
        }
        if (Objects.isNull((Object)this.orientation)) {
            this.orientation = PrintOrientation.PORTRAIT;
        }
        if (Objects.isNull(this.dpi)) {
            this.dpi = Float.valueOf(0.0f);
        }
        if (Objects.isNull(this.renderingHints)) {
            this.renderingHints = RenderingHintUtil.createDefaultRenderingHints();
        }
        if (Objects.isNull(this.isShowBorder)) {
            this.isShowBorder = Boolean.FALSE;
        }
        if (Objects.isNull(this.isCenter)) {
            this.isCenter = Boolean.TRUE;
        }
        if (Objects.isNull(this.isMemoryOptimization)) {
            this.isMemoryOptimization = Boolean.FALSE;
        }
        if (Objects.isNull(this.count)) {
            this.count = 1;
        }
    }

    protected PDFPrintable initPrintable() {
        PDFPrintable printable = new PDFPrintable(this.getDocument(), this.scaling.getScaling(), this.isShowBorder.booleanValue(), this.dpi.floatValue(), this.isCenter.booleanValue(), new PDFRenderer(this.getDocument()));
        printable.setSubsamplingAllowed(this.isMemoryOptimization.booleanValue());
        printable.setRenderingHints(this.renderingHints);
        return printable;
    }

    protected DefaultPageable initPageable() {
        return new DefaultPageable(this.getDocument(), this.orientation.getOrientation(), (Printable)this.initPrintable());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrintProcessor)) {
            return false;
        }
        PrintProcessor other = (PrintProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$beginPageNo = this.beginPageNo;
        Integer other$beginPageNo = other.beginPageNo;
        if (this$beginPageNo == null ? other$beginPageNo != null : !((Object)this$beginPageNo).equals(other$beginPageNo)) {
            return false;
        }
        Integer this$endPageNo = this.endPageNo;
        Integer other$endPageNo = other.endPageNo;
        if (this$endPageNo == null ? other$endPageNo != null : !((Object)this$endPageNo).equals(other$endPageNo)) {
            return false;
        }
        Float this$dpi = this.dpi;
        Float other$dpi = other.dpi;
        if (this$dpi == null ? other$dpi != null : !((Object)this$dpi).equals(other$dpi)) {
            return false;
        }
        Boolean this$isShowBorder = this.isShowBorder;
        Boolean other$isShowBorder = other.isShowBorder;
        if (this$isShowBorder == null ? other$isShowBorder != null : !((Object)this$isShowBorder).equals(other$isShowBorder)) {
            return false;
        }
        Boolean this$isCenter = this.isCenter;
        Boolean other$isCenter = other.isCenter;
        if (this$isCenter == null ? other$isCenter != null : !((Object)this$isCenter).equals(other$isCenter)) {
            return false;
        }
        Boolean this$isMemoryOptimization = this.isMemoryOptimization;
        Boolean other$isMemoryOptimization = other.isMemoryOptimization;
        if (this$isMemoryOptimization == null ? other$isMemoryOptimization != null : !((Object)this$isMemoryOptimization).equals(other$isMemoryOptimization)) {
            return false;
        }
        Integer this$count = this.count;
        Integer other$count = other.count;
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        PrintScaling this$scaling = this.scaling;
        PrintScaling other$scaling = other.scaling;
        if (this$scaling == null ? other$scaling != null : !((Object)((Object)this$scaling)).equals((Object)other$scaling)) {
            return false;
        }
        PrintOrientation this$orientation = this.orientation;
        PrintOrientation other$orientation = other.orientation;
        if (this$orientation == null ? other$orientation != null : !((Object)((Object)this$orientation)).equals((Object)other$orientation)) {
            return false;
        }
        RenderingHints this$renderingHints = this.renderingHints;
        RenderingHints other$renderingHints = other.renderingHints;
        return !(this$renderingHints == null ? other$renderingHints != null : !((Object)this$renderingHints).equals(other$renderingHints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrintProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $beginPageNo = this.beginPageNo;
        result = result * 59 + ($beginPageNo == null ? 43 : ((Object)$beginPageNo).hashCode());
        Integer $endPageNo = this.endPageNo;
        result = result * 59 + ($endPageNo == null ? 43 : ((Object)$endPageNo).hashCode());
        Float $dpi = this.dpi;
        result = result * 59 + ($dpi == null ? 43 : ((Object)$dpi).hashCode());
        Boolean $isShowBorder = this.isShowBorder;
        result = result * 59 + ($isShowBorder == null ? 43 : ((Object)$isShowBorder).hashCode());
        Boolean $isCenter = this.isCenter;
        result = result * 59 + ($isCenter == null ? 43 : ((Object)$isCenter).hashCode());
        Boolean $isMemoryOptimization = this.isMemoryOptimization;
        result = result * 59 + ($isMemoryOptimization == null ? 43 : ((Object)$isMemoryOptimization).hashCode());
        Integer $count = this.count;
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        PrintScaling $scaling = this.scaling;
        result = result * 59 + ($scaling == null ? 43 : ((Object)((Object)$scaling)).hashCode());
        PrintOrientation $orientation = this.orientation;
        result = result * 59 + ($orientation == null ? 43 : ((Object)((Object)$orientation)).hashCode());
        RenderingHints $renderingHints = this.renderingHints;
        result = result * 59 + ($renderingHints == null ? 43 : ((Object)$renderingHints).hashCode());
        return result;
    }

    public void setScaling(PrintScaling scaling) {
        this.scaling = scaling;
    }

    public void setOrientation(PrintOrientation orientation) {
        this.orientation = orientation;
    }

    public void setDpi(Float dpi) {
        this.dpi = dpi;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public void setIsShowBorder(Boolean isShowBorder) {
        this.isShowBorder = isShowBorder;
    }

    public void setIsCenter(Boolean isCenter) {
        this.isCenter = isCenter;
    }

    public void setIsMemoryOptimization(Boolean isMemoryOptimization) {
        this.isMemoryOptimization = isMemoryOptimization;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public static class DefaultPageable
    extends Book {
        private final PDDocument document;
        private final int numberOfPages;
        private final Orientation orientation;
        private final Printable printable;

        public DefaultPageable(PDDocument document, Orientation orientation, Printable printable) {
            this.document = document;
            this.orientation = orientation;
            this.printable = printable;
            this.numberOfPages = document.getNumberOfPages();
        }

        @Override
        public int getNumberOfPages() {
            return this.numberOfPages;
        }

        @Override
        public PageFormat getPageFormat(int pageIndex) {
            boolean isLandscape;
            Paper paper;
            PDPage page = this.document.getPage(pageIndex);
            PDRectangle mediaBox = this.getRotatedMediaBox(page);
            PDRectangle cropBox = this.getRotatedCropBox(page);
            if (mediaBox.getWidth() > mediaBox.getHeight()) {
                paper = new Paper();
                paper.setSize(mediaBox.getHeight(), mediaBox.getWidth());
                paper.setImageableArea(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
                isLandscape = true;
            } else {
                paper = new Paper();
                paper.setSize(mediaBox.getWidth(), mediaBox.getHeight());
                paper.setImageableArea(cropBox.getLowerLeftX(), cropBox.getLowerLeftY(), cropBox.getWidth(), cropBox.getHeight());
                isLandscape = false;
            }
            PageFormat format = new PageFormat();
            format.setPaper(paper);
            switch (this.orientation) {
                case AUTO: {
                    format.setOrientation(isLandscape ? 0 : 1);
                    break;
                }
                case LANDSCAPE: {
                    format.setOrientation(0);
                    break;
                }
                case PORTRAIT: {
                    format.setOrientation(1);
                    break;
                }
            }
            return format;
        }

        @Override
        public Printable getPrintable(int i) {
            if (i >= this.numberOfPages) {
                throw new IndexOutOfBoundsException(i + " >= " + this.numberOfPages);
            }
            return this.printable;
        }

        protected PDRectangle getRotatedCropBox(PDPage page) {
            PDRectangle cropBox = page.getCropBox();
            int rotationAngle = page.getRotation();
            if (rotationAngle == 90 || rotationAngle == 270) {
                return new PDRectangle(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
            }
            return cropBox;
        }

        protected PDRectangle getRotatedMediaBox(PDPage page) {
            PDRectangle mediaBox = page.getMediaBox();
            int rotationAngle = page.getRotation();
            if (rotationAngle == 90 || rotationAngle == 270) {
                return new PDRectangle(mediaBox.getLowerLeftY(), mediaBox.getLowerLeftX(), mediaBox.getHeight(), mediaBox.getWidth());
            }
            return mediaBox;
        }
    }
}

