/* GeneratedJavaParser.java */
/* Generated By:JavaCC: Do not edit this line. GeneratedJavaParser.java */
/*
 * Copyright (C) 2007-2010 Júlio Vilmar Gesser.
 * Copyright (C) 2011, 2013-2016 The JavaParser Team.
 *
 * This file is part of JavaParser.
 *
 * JavaParser can be used either under the terms of
 * a) the GNU Lesser General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 * b) the terms of the Apache License
 *
 * You should have received a copy of both licenses in LICENCE.LGPL and
 * LICENCE.APACHE. Please refer to those files for details.
 *
 * JavaParser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */
package org.drools.javaparser;
import java.io.*;
import java.util.*;
import java.util.concurrent.TimeUnit;
import org.drools.javaparser.ast.*;
import org.drools.javaparser.ast.body.*;
import org.drools.javaparser.ast.comments.*;
import org.drools.javaparser.ast.drlx.*;
import org.drools.javaparser.ast.drlx.expr.*;
import org.drools.javaparser.ast.modules.*;
import org.drools.javaparser.ast.expr.*;
import org.drools.javaparser.ast.stmt.*;
import org.drools.javaparser.ast.type.*;
import org.drools.javaparser.utils.*;
import javax.annotation.Generated;
import static org.drools.javaparser.JavaToken.INVALID;
import static org.drools.javaparser.ast.Node.Parsedness.UNPARSABLE;
import static org.drools.javaparser.utils.Utils.*;
import static org.drools.javaparser.ast.NodeList.*;
import static org.drools.javaparser.GeneratedJavaParser.*;
import static org.drools.javaparser.Range.*;
import static org.drools.javaparser.Position.*;
import static org.drools.javaparser.ast.type.ArrayType.*;
import static org.drools.javaparser.GeneratedJavaParserTokenManagerBase.*;

@Generated("JavaCC")
public final class GeneratedJavaParser extends GeneratedJavaParserBase implements GeneratedJavaParserConstants {
    /* Returns the JavaParser specific token type of the last matched token */
    JavaToken token() {
        return token.javaToken;
    }

    /* Changes the amount by which the horizontal position is increased when a tab character is encountered.
        One by default.*/
    void setTabSize(int size) {
        jj_input_stream.setTabSize(size);
    }

    @Override
    GeneratedJavaParserTokenManager getTokenSource() {
        return token_source;
    }

    private boolean drlParsing = false;
    public void setDrlParsing(boolean drlParsing) {
        this.drlParsing = drlParsing;
    }

    private <T extends Node> T asDrlNode(T node) throws ParseException {
        if (!drlParsing) {
            throw new ParseException();
        }
        return node;
    }

    private Collection<String> pointFreeOperators = new ArrayList<String>();
    public void setPointFreeOperators(Collection<String> pointFreeOperators) {
        this.pointFreeOperators = pointFreeOperators;
    }

    public boolean isPointFreeOperator(String operator) {
        return this.pointFreeOperators.contains(operator);
    }

/*****************************************
 * THE JAVA LANGUAGE GRAMMAR STARTS HERE *
 *****************************************/

/*
 * Program structuring syntax follows.
 */
  final public 
CompilationUnit CompilationUnit() throws ParseException {PackageDeclaration pakage = null;
        NodeList<ImportDeclaration> imports = emptyList();
        ImportDeclaration in = null;
        NodeList<TypeDeclaration<?>> types = emptyList();
   ModifierHolder modifier;
        TypeDeclaration tn = null;
        ModuleDeclaration module = null;
    try {
      label_1:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_1;
        }
        jj_consume_token(SEMICOLON);
      }
      if (jj_2_2(2147483647)) {
        pakage = PackageDeclaration();
      } else {
        ;
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case CLASS:
        case _DEFAULT:
        case ENUM:
        case FINAL:
        case IMPORT:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case OPEN:
        case MODULE:
        case TRANSITIVE:
        case RULE:
        case SEMICOLON:
        case AT:{
          ;
          break;
          }
        default:
          jj_la1[0] = jj_gen;
          break label_2;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT:{
          in = ImportDeclaration();
imports = add(imports, in);
          break;
          }
        case ABSTRACT:
        case CLASS:
        case _DEFAULT:
        case ENUM:
        case FINAL:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case OPEN:
        case MODULE:
        case TRANSITIVE:
        case RULE:
        case SEMICOLON:
        case AT:{
          modifier = Modifiers();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CLASS:
          case INTERFACE:{
            tn = ClassOrInterfaceDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case RULE:{
            tn = RuleDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case ENUM:{
            tn = EnumDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case AT:{
            tn = AnnotationTypeDeclaration(modifier);
types = add(types, tn);
            break;
            }
          case OPEN:
          case MODULE:{
            module = ModuleDeclaration(modifier);
            break;
            }
          case SEMICOLON:{
            jj_consume_token(SEMICOLON);
            break;
            }
          default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 0:{
        jj_consume_token(0);
        break;
        }
      case CTRL_Z:{
        jj_consume_token(CTRL_Z);
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
return new CompilationUnit(range(token_source.getHomeToken(), token()), pakage, imports, types, module);
    } catch (ParseException e) {
recover(EOF, e);
        final CompilationUnit compilationUnit = new CompilationUnit(range(token_source.getHomeToken(), token()), null, new NodeList<ImportDeclaration>(), new NodeList<TypeDeclaration<?>>(), null);
        compilationUnit.setParsed(UNPARSABLE);
        return compilationUnit;
    }
}

  final public PackageDeclaration PackageDeclaration() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
        Name name;
        JavaToken begin;
    annotations = Annotations();
    jj_consume_token(PACKAGE);
begin = token();
    name = Name();
    jj_consume_token(SEMICOLON);
return new PackageDeclaration(range(begin, token()), annotations, name);
}

  final public ImportDeclaration ImportDeclaration() throws ParseException {Name name;
    boolean isStatic = false;
    boolean isAsterisk = false;
    JavaToken begin;
    jj_consume_token(IMPORT);
begin = token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true;
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    name = Name();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      jj_consume_token(STAR);
isAsterisk = true;
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new ImportDeclaration(range(begin, token()), name, isStatic, isAsterisk);
}

/*
 * Modifiers. We match all modifiers in a single rule to reduce the chances of
 * syntax errors for simple modifier mistakes. It will also enable us to give
 * better error messages.
 */
  final public 
ModifierHolder Modifiers() throws ParseException {JavaToken begin = INVALID;
    EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    AnnotationExpr ann;
    label_3:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PUBLIC:{
        jj_consume_token(PUBLIC);
addModifier(modifiers, Modifier.PUBLIC); begin = orIfInvalid(begin, token());
        break;
        }
      case STATIC:{
        jj_consume_token(STATIC);
addModifier(modifiers, Modifier.STATIC); begin = orIfInvalid(begin, token());
        break;
        }
      case PROTECTED:{
        jj_consume_token(PROTECTED);
addModifier(modifiers, Modifier.PROTECTED); begin = orIfInvalid(begin, token());
        break;
        }
      case PRIVATE:{
        jj_consume_token(PRIVATE);
addModifier(modifiers, Modifier.PRIVATE); begin = orIfInvalid(begin, token());
        break;
        }
      case FINAL:{
        jj_consume_token(FINAL);
addModifier(modifiers, Modifier.FINAL); begin = orIfInvalid(begin, token());
        break;
        }
      case ABSTRACT:{
        jj_consume_token(ABSTRACT);
addModifier(modifiers, Modifier.ABSTRACT); begin = orIfInvalid(begin, token());
        break;
        }
      case SYNCHRONIZED:{
        jj_consume_token(SYNCHRONIZED);
addModifier(modifiers, Modifier.SYNCHRONIZED); begin = orIfInvalid(begin, token());
        break;
        }
      case NATIVE:{
        jj_consume_token(NATIVE);
addModifier(modifiers, Modifier.NATIVE); begin = orIfInvalid(begin, token());
        break;
        }
      case TRANSIENT:{
        jj_consume_token(TRANSIENT);
addModifier(modifiers, Modifier.TRANSIENT); begin = orIfInvalid(begin, token());
        break;
        }
      case VOLATILE:{
        jj_consume_token(VOLATILE);
addModifier(modifiers, Modifier.VOLATILE); begin = orIfInvalid(begin, token());
        break;
        }
      case STRICTFP:{
        jj_consume_token(STRICTFP);
addModifier(modifiers, Modifier.STRICTFP);  begin = orIfInvalid(begin, token());
        break;
        }
      case TRANSITIVE:{
        jj_consume_token(TRANSITIVE);
addModifier(modifiers, Modifier.TRANSITIVE);  begin = orIfInvalid(begin, token());
        break;
        }
      case _DEFAULT:{
        jj_consume_token(_DEFAULT);
addModifier(modifiers, Modifier.DEFAULT);  begin = orIfInvalid(begin, token());
        break;
        }
      case AT:{
        ann = Annotation();
annotations = add(annotations, ann); begin = orIfInvalid(begin, ann);
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return new ModifierHolder(begin, modifiers, annotations);
}

/*
 * Declaration syntax follows.
 */
  final public 
ClassOrInterfaceDeclaration ClassOrInterfaceDeclaration(ModifierHolder modifier) throws ParseException {boolean isInterface = false;
    SimpleName name;
    RangedList<TypeParameter> typePar = new RangedList<TypeParameter>(emptyList());
    NodeList<ClassOrInterfaceType> extList = emptyList();
    NodeList<ClassOrInterfaceType> impList = emptyList();
    NodeList<BodyDeclaration<?>> members = emptyList();
    JavaToken begin = modifier.begin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CLASS:{
      jj_consume_token(CLASS);
      break;
      }
    case INTERFACE:{
      jj_consume_token(INTERFACE);
isInterface = true;
      break;
      }
    default:
      jj_la1[7] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
begin = orIfInvalid(begin, token());
    name = SimpleName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typePar = TypeParameters();
      break;
      }
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:{
      extList = ExtendsList();
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    members = ClassOrInterfaceBody();
return new ClassOrInterfaceDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, isInterface, name, typePar.list, extList, impList, members);
}

  final public NodeList<ClassOrInterfaceType> ExtendsList() throws ParseException {boolean extendsMoreThanOne = false;
   NodeList<ClassOrInterfaceType> ret = new NodeList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
    jj_consume_token(EXTENDS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit); extendsMoreThanOne = true;
    }
return ret;
}

  final public NodeList<ClassOrInterfaceType> ImplementsList() throws ParseException {NodeList<ClassOrInterfaceType> ret = new NodeList<ClassOrInterfaceType>();
   ClassOrInterfaceType cit;
    jj_consume_token(IMPLEMENTS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        break label_5;
      }
      jj_consume_token(COMMA);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    }
return ret;
}

  final public EnumDeclaration EnumDeclaration(ModifierHolder modifier) throws ParseException {SimpleName name;
    NodeList<ClassOrInterfaceType> impList = emptyList();
        EnumConstantDeclaration entry;
        NodeList<EnumConstantDeclaration> entries = emptyList();
        BodyDeclaration<?> member;
    NodeList<BodyDeclaration<?>> members = emptyList();
        JavaToken begin = modifier.begin;
    jj_consume_token(ENUM);
begin = orIfInvalid(begin, token());
    name = SimpleName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPLEMENTS:{
      impList = ImplementsList();
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:{
      entry = EnumConstantDeclaration();
entries.add(entry);
      label_6:
      while (true) {
        if (jj_2_4(2)) {
          ;
        } else {
          break label_6;
        }
        jj_consume_token(COMMA);
        entry = EnumConstantDeclaration();
entries.add(entry);
      }
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOID:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case LT:{
          ;
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          break label_7;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case CLASS:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case INTERFACE:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOID:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case LBRACE:
        case AT:
        case LT:{
          member = ClassOrInterfaceBodyDeclaration();
members = add(members, member);
          break;
          }
        case SEMICOLON:{
          jj_consume_token(SEMICOLON);
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
return new EnumDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, name, impList, entries, members);
}

  final public EnumConstantDeclaration EnumConstantDeclaration() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
        AnnotationExpr ann;
        SimpleName name;
        NodeList<Expression> args = emptyList();
        NodeList<BodyDeclaration<?>> classBody = emptyList();
        JavaToken begin = INVALID;

    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      ann = Annotation();
annotations = add(annotations, ann); begin = orIfInvalid(begin, ann);
    }
    name = SimpleName();
begin = orIfInvalid(begin, token());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      args = Arguments();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      classBody = ClassOrInterfaceBody();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
return new EnumConstantDeclaration(range(begin, token()), annotations, name, args, classBody);
}

/**
 * If the list inside the returned RangedList is null, there are no brackets.
 * If it is empty, there are brackets, but nothing is in them <>.
 * The normal case is that it contains TypeParameters, like <A, B, C>.
 */
  final public RangedList<TypeParameter> TypeParameters() throws ParseException {RangedList<TypeParameter> ret = new RangedList<TypeParameter>(new NodeList<TypeParameter>());
        TypeParameter tp;
        NodeList<AnnotationExpr> annotations;
    jj_consume_token(LT);
ret.beginAt(token());
    annotations = Annotations();
    tp = TypeParameter(annotations);
ret.add(tp); annotations = null;
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        break label_9;
      }
      jj_consume_token(COMMA);
      annotations = Annotations();
      tp = TypeParameter(annotations);
ret.add(tp); annotations = null;
    }
    jj_consume_token(GT);
ret.endAt(token());
return ret;
}

  final public TypeParameter TypeParameter(NodeList<AnnotationExpr> annotations) throws ParseException {SimpleName name;
        NodeList<ClassOrInterfaceType> typeBound  = emptyList();
        JavaToken begin;
    name = SimpleName();
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:{
      typeBound = TypeBound();
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
return new TypeParameter(range(begin, token()), name, typeBound, annotations);
}

  final public NodeList<ClassOrInterfaceType> TypeBound() throws ParseException {NodeList<ClassOrInterfaceType> ret = emptyList();
        ClassOrInterfaceType cit;
    jj_consume_token(EXTENDS);
    cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_AND:{
        ;
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_10;
      }
      jj_consume_token(BIT_AND);
      cit = AnnotatedClassOrInterfaceType();
ret.add(cit);
    }
return ret;
}

  final public NodeList<BodyDeclaration<?>> ClassOrInterfaceBody() throws ParseException {NodeList<BodyDeclaration<?>> ret = emptyList();
        BodyDeclaration member;
    jj_consume_token(LBRACE);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case LBRACE:
      case SEMICOLON:
      case AT:
      case LT:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case LBRACE:
      case AT:
      case LT:{
        member = ClassOrInterfaceBodyDeclaration();
ret.add(member);
        break;
        }
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[26] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
return ret;
}

  final public BodyDeclaration<?> ClassOrInterfaceBodyDeclaration() throws ParseException {ModifierHolder modifier;
   BodyDeclaration<?> ret;
    if (jj_2_9(2)) {
      ret = InitializerDeclaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOID:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case AT:
      case LT:{
        // Just get all the modifiers out of the way. If you want to do
              // more checks, pass the modifiers down to the member
                  modifier = Modifiers();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CLASS:
        case INTERFACE:{
          ret = ClassOrInterfaceDeclaration(modifier);
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          if (jj_2_5(2147483647)) {
            ret = EnumDeclaration(modifier);
          } else if (jj_2_6(2147483647)) {
            ret = AnnotationTypeDeclaration(modifier);
          } else if (jj_2_7(2147483647)) {
            ret = ConstructorDeclaration(modifier);
          } else if (jj_2_8(2147483647)) {
            ret = FieldDeclaration(modifier);
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case RULE:{
              ret = RuleDeclaration(modifier);
              break;
              }
            case BOOLEAN:
            case BYTE:
            case CHAR:
            case DOUBLE:
            case ENUM:
            case FLOAT:
            case INT:
            case LONG:
            case SHORT:
            case STRICTFP:
            case VOID:
            case REQUIRES:
            case TO:
            case WITH:
            case OPEN:
            case OPENS:
            case USES:
            case MODULE:
            case EXPORTS:
            case PROVIDES:
            case TRANSITIVE:
            case IDENTIFIER:
            case AT:
            case LT:{
              ret = MethodDeclaration(modifier);
              break;
              }
            default:
              jj_la1[28] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public FieldDeclaration FieldDeclaration(ModifierHolder modifier) throws ParseException {Type partialType;
        NodeList<VariableDeclarator> variables = new NodeList<VariableDeclarator>();
        VariableDeclarator val;
    // Modifiers are already matched in the caller
        partialType = Type(emptyList());
    val = VariableDeclarator(partialType);
variables.add(val);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[30] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      val = VariableDeclarator(partialType);
variables.add(val);
    }
    jj_consume_token(SEMICOLON);
JavaToken begin = orIfInvalid(modifier.begin, partialType);
        return new FieldDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, variables);
}

  final public VariableDeclarator VariableDeclarator(Type partialType) throws ParseException {Pair<SimpleName, List<ArrayBracketPair>> id;
        Expression init = null;
    id = VariableDeclaratorId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      init = VariableInitializer();
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
return new VariableDeclarator(range(id.a, token()), juggleArrayType(partialType, id.b), id.a, init);
}

  final public Pair<SimpleName, List<ArrayBracketPair>> VariableDeclaratorId() throws ParseException {SimpleName name;
        JavaToken begin;
        ArrayBracketPair arrayBracketPair;
        List<ArrayBracketPair> arrayBracketPairs = new ArrayList(0);
    name = SimpleName();
begin=token();
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        break label_13;
      }
      arrayBracketPair = ArrayBracketPair(Origin.NAME);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
    }
if(storeTokens) {
            name.setTokenRange(name.getTokenRange().get().withEnd(token()));
        }
        return new Pair(name, arrayBracketPairs);
}

  final public Expression VariableInitializer() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      ret = ArrayInitializer();
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      if (jj_2_10(1)) {
        ret = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public ArrayInitializerExpr ArrayInitializer() throws ParseException {NodeList<Expression> values = emptyList();
        Expression val;
        JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    if (jj_2_12(1)) {
      val = VariableInitializer();
values = add(values, val);
      label_14:
      while (true) {
        if (jj_2_11(2)) {
          ;
        } else {
          break label_14;
        }
        jj_consume_token(COMMA);
        val = VariableInitializer();
values = add(values, val);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
return new ArrayInitializerExpr(range(begin, token()), values);
}

  final public MethodDeclaration MethodDeclaration(ModifierHolder modifier) throws ParseException {RangedList<TypeParameter> typeParameters = new RangedList<TypeParameter>(emptyList());
        Type type;
        SimpleName name;
        Pair<NodeList<Parameter>, ReceiverParameter> parameters = new Pair<NodeList<Parameter>, ReceiverParameter>(emptyList(), null);
        ArrayBracketPair arrayBracketPair;
        List<ArrayBracketPair> arrayBracketPairs = new ArrayList(0);
        NodeList<ReferenceType> throws_ = emptyList();
        BlockStmt body = null;
        NodeList<AnnotationExpr> annotations;
        JavaToken begin = modifier.begin;
        ReferenceType throwType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typeParameters = TypeParameters();
begin = orIfInvalid(begin, typeParameters.range.getBegin());
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    annotations = Annotations();
modifier.annotations.addAll(annotations); begin = orIfInvalid(begin, nodeListBegin(annotations));
    type = ResultType(emptyList());
begin = orIfInvalid(begin, type);
    name = SimpleName();
    parameters = Parameters();
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_15;
      }
      arrayBracketPair = ArrayBracketPair(Origin.NAME);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THROWS:{
      jj_consume_token(THROWS);
      throwType = AnnotatedReferenceType();
throws_ = add(throws_, throwType);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        throwType = AnnotatedReferenceType();
throws_ = add(throws_, throwType);
      }
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      body = Block();
      break;
      }
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
type = juggleArrayType(type, arrayBracketPairs);
        return new MethodDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, typeParameters.list, type, name, parameters.a, throws_, body, parameters.b);
}

  final public ReferenceType AnnotatedReferenceType() throws ParseException {NodeList<AnnotationExpr> annotations;
        ReferenceType type;
    annotations = Annotations();
    type = ReferenceType(annotations);
return type;
}

  final public Type AnnotatedType() throws ParseException {NodeList<AnnotationExpr> annotations;
        Type type;
    annotations = Annotations();
    type = Type(annotations);
return type;
}

  final public Pair<NodeList<Parameter>, ReceiverParameter> Parameters() throws ParseException {NodeList<Parameter> ret = emptyList();
        Parameter par;
        ReceiverParameter rp = null;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ABSTRACT:
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case _DEFAULT:
    case DOUBLE:
    case ENUM:
    case FINAL:
    case FLOAT:
    case INT:
    case LONG:
    case NATIVE:
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case SHORT:
    case STATIC:
    case STRICTFP:
    case SYNCHRONIZED:
    case TRANSIENT:
    case VOLATILE:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:{
      if (jj_2_13(2147483647)) {
        rp = ReceiverParameter();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case _DEFAULT:
        case DOUBLE:
        case ENUM:
        case FINAL:
        case FLOAT:
        case INT:
        case LONG:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case STRICTFP:
        case SYNCHRONIZED:
        case TRANSIENT:
        case VOLATILE:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case AT:{
          par = Parameter();
ret = add(ret, par);
          break;
          }
        default:
          jj_la1[40] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[41] = jj_gen;
          break label_17;
        }
        jj_consume_token(COMMA);
        par = Parameter();
ret = add(ret, par);
      }
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
return new Pair(ret, rp);
}

  final public NodeList<Parameter> LambdaParameters() throws ParseException {NodeList<Parameter> ret = null;
  Parameter par;
    par = Parameter();
ret = add(ret, par);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      par = Parameter();
ret = add(ret, par);
    }
return ret;
}

  final public NodeList<Parameter> InferredLambdaParameters() throws ParseException {NodeList<Parameter> ret = null;
    Pair<SimpleName, List<ArrayBracketPair>> id;
    id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.a, id.a), EnumSet.noneOf(Modifier.class), emptyList(), new UnknownType(), false, emptyList(), id.a));
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      id = VariableDeclaratorId();
ret = add(ret, new Parameter(range(id.a, id.a), EnumSet.noneOf(Modifier.class), emptyList(), new UnknownType(), false, emptyList(), id.a));
    }
return ret;
}

  final public Parameter Parameter() throws ParseException {ModifierHolder modifier;
        Type partialType;
        boolean isVarArg = false;
        Pair<SimpleName, List<ArrayBracketPair>> id;
        NodeList<AnnotationExpr> varArgAnnotations = emptyList();
    modifier = Modifiers();
    partialType = Type(emptyList());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AT:
    case ELLIPSIS:{
      varArgAnnotations = Annotations();
      jj_consume_token(ELLIPSIS);
isVarArg = true;
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
    id = VariableDeclaratorId();
JavaToken begin = orIfInvalid(modifier.begin, partialType);
        return new Parameter(range(begin, token()), modifier.modifiers, modifier.annotations, juggleArrayType(partialType, id.b), isVarArg, varArgAnnotations, id.a);
}

  final public ReceiverParameter ReceiverParameter() throws ParseException {Type partialType;
        Name id;
        NodeList<AnnotationExpr> annotations = emptyList();
    annotations = Annotations();
    partialType = Type(emptyList());
    id = ReceiverParameterId();
return new ReceiverParameter(range(partialType, token()), annotations, partialType, id);
}

  final public Name ReceiverParameterId() throws ParseException {Name ret = null;
        NodeList<AnnotationExpr> annotations;
    if (jj_2_14(2147483647)) {
      ret = Name();
      jj_consume_token(DOT);
    } else {
      ;
    }
    annotations = Annotations();
    jj_consume_token(THIS);
return new Name(tokenRange(), ret, token.image, annotations);
}

  final public ConstructorDeclaration ConstructorDeclaration(ModifierHolder modifier) throws ParseException {RangedList<TypeParameter> typeParameters = new RangedList<TypeParameter>(emptyList());
        SimpleName name;
        Pair<NodeList<Parameter>, ReceiverParameter> parameters = new Pair<NodeList<Parameter>, ReceiverParameter>(emptyList(), null);
        NodeList<ReferenceType> throws_ = emptyList();
        ExplicitConstructorInvocationStmt exConsInv = null;
        NodeList<Statement> stmts = emptyList();
    JavaToken begin = modifier.begin;
        JavaToken blockBegin = INVALID;
        ReferenceType throwType;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:{
      typeParameters = TypeParameters();
begin = orIfInvalid(begin, typeParameters.range.getBegin());
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    // Modifiers matched in the caller
      name = SimpleName();
begin = orIfInvalid(begin, typeParameters.range.getBegin()); begin = orIfInvalid(begin, token());
    parameters = Parameters();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case THROWS:{
      jj_consume_token(THROWS);
      throwType = AnnotatedReferenceType();
throws_ = add(throws_, throwType);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        throwType = AnnotatedReferenceType();
throws_ = add(throws_, throwType);
      }
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
blockBegin=token();
    if (jj_2_15(2147483647)) {
      exConsInv = ExplicitConstructorInvocation();
    } else {
      ;
    }
    stmts = Statements();
    jj_consume_token(RBRACE);
if (exConsInv != null) {
                stmts = prepend(stmts, exConsInv);
        }
        return new ConstructorDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, typeParameters.list, name, parameters.a, throws_, new BlockStmt(range(blockBegin, token()), stmts), parameters.b);
}

  final public ExplicitConstructorInvocationStmt ExplicitConstructorInvocation() throws ParseException {boolean isThis = false;
        NodeList<Expression> args;
        Expression expr = null;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        JavaToken begin = INVALID;
    if (jj_2_17(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
begin=typeArgs.range.getBegin();
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        ;
      }
      jj_consume_token(THIS);
begin = orIfInvalid(begin, token()); isThis = true;
      args = Arguments();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case LT:
      case 150:{
        if (jj_2_16(2147483647)) {
          expr = PrimaryExpressionWithoutSuperSuffix();
          jj_consume_token(DOT);
begin = orIfInvalid(begin, expr);
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
begin = orIfInvalid(begin, typeArgs.range.getBegin());
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          ;
        }
        jj_consume_token(SUPER);
begin = orIfInvalid(begin, token());
        args = Arguments();
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return new ExplicitConstructorInvocationStmt(range(begin, token()),typeArgs.list, isThis, expr, args);
}

  final public NodeList<Statement> Statements() throws ParseException {NodeList<Statement> ret = emptyList();
        Statement stmt;
    label_21:
    while (true) {
      if (jj_2_18(2)) {
        ;
      } else {
        break label_21;
      }
      stmt = BlockStatement();
ret = add(ret, stmt);
    }
return ret;
}

  final public InitializerDeclaration InitializerDeclaration() throws ParseException {BlockStmt body;
        JavaToken begin = INVALID;
        boolean isStatic = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STATIC:{
      jj_consume_token(STATIC);
isStatic = true; begin=token();
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    body = Block();
begin = orIfInvalid(begin, body);
return new InitializerDeclaration(range(begin, token()), isStatic, body);
}

/*
 * Type, name and expression syntax follows.
 */
  final public 
Type Type(NodeList<AnnotationExpr> annotations) throws ParseException {Type ret;
    if (jj_2_19(2)) {
      ret = ReferenceType(annotations);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:{
        ret = PrimitiveType(annotations);
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public ReferenceType ReferenceType(NodeList<AnnotationExpr> annotations) throws ParseException {Type type;
        ArrayBracketPair arrayBracketPair;
        List<ArrayBracketPair> arrayBracketPairs = new ArrayList(0);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType(annotations);
      label_22:
      while (true) {
        arrayBracketPair = ArrayBracketPair(Origin.TYPE);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
        if (jj_2_20(2147483647)) {
          ;
        } else {
          break label_22;
        }
      }
      break;
      }
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      type = ClassOrInterfaceType(annotations);
      label_23:
      while (true) {
        if (jj_2_21(2147483647)) {
          ;
        } else {
          break label_23;
        }
        arrayBracketPair = ArrayBracketPair(Origin.TYPE);
arrayBracketPairs=add(arrayBracketPairs, arrayBracketPair);
      }
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return (ReferenceType)wrapInArrayTypes(type, arrayBracketPairs);
}

  final public ArrayBracketPair ArrayBracketPair(Origin origin) throws ParseException {NodeList<AnnotationExpr> annotations;
    JavaToken begin = INVALID;
    annotations = Annotations();
    jj_consume_token(LBRACKET);
begin = orIfInvalid(begin, token());
    jj_consume_token(RBRACKET);
return new ArrayBracketPair(range(begin, token()), origin, annotations);
}

  final public IntersectionType IntersectionType(NodeList<AnnotationExpr> annotations) throws ParseException {JavaToken begin = INVALID;
        ReferenceType elementType;
        NodeList<ReferenceType> elements = emptyList();
    elementType = ReferenceType(annotations);
begin = orIfInvalid(begin, elementType); elements = add(elements, elementType);
    jj_consume_token(BIT_AND);
    label_24:
    while (true) {
      elementType = AnnotatedReferenceType();
elements = add(elements, elementType);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        break label_24;
      }
    }
return new IntersectionType(range(begin, token()), elements);
}

  final public ClassOrInterfaceType AnnotatedClassOrInterfaceType() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
        ClassOrInterfaceType cit;
    annotations = Annotations();
    cit = ClassOrInterfaceType(annotations);
return cit;
}

  final public ClassOrInterfaceType ClassOrInterfaceType(NodeList<AnnotationExpr> firstAnnotations) throws ParseException {ClassOrInterfaceType ret;
        SimpleName name;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        JavaToken begin;
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    name = SimpleName();
begin=token();
    if (jj_2_22(2)) {
      typeArgs = TypeArguments();
    } else {
      ;
    }
ret = new ClassOrInterfaceType(range(begin, token()), null, name, typeArgs.list, firstAnnotations);
      typeArgs = new RangedList<Type>(null);
    label_25:
    while (true) {
      if (jj_2_23(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(DOT);
      annotations = Annotations();
      name = SimpleName();
      if (jj_2_24(2)) {
        typeArgs = TypeArguments();
      } else {
        ;
      }
ret = new ClassOrInterfaceType(range(begin, token()), ret, name, typeArgs.list, annotations);
        typeArgs = new RangedList<Type>(null);
    }
return ret;
}

  final public RangedList<Type> TypeArguments() throws ParseException {RangedList<Type> ret = new RangedList<Type>(new NodeList<Type>());
        Type type;
    jj_consume_token(LT);
ret.beginAt(token());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:
    case HOOK:{
      type = TypeArgument();
ret.add(type);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[56] = jj_gen;
          break label_26;
        }
        jj_consume_token(COMMA);
        type = TypeArgument();
ret.add(type);
      }
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(GT);
ret.endAt(token());
return ret;
}

  final public Type TypeArgument() throws ParseException {Type ret;
        NodeList<AnnotationExpr> annotations;
    annotations = Annotations();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      ret = Type(annotations);
      break;
      }
    case HOOK:{
      ret = Wildcard(annotations);
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public WildcardType Wildcard(NodeList<AnnotationExpr> firstAnnotations) throws ParseException {ReferenceType ext = null;
        ReferenceType sup = null;
        JavaToken begin;
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    jj_consume_token(HOOK);
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case EXTENDS:
    case SUPER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EXTENDS:{
        jj_consume_token(EXTENDS);
        annotations = Annotations();
        ext = ReferenceType(annotations);
        break;
        }
      case SUPER:{
        jj_consume_token(SUPER);
        annotations = Annotations();
        sup = ReferenceType(annotations);
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
return new WildcardType(range(begin, token()), ext, sup, firstAnnotations);
}

  final public PrimitiveType PrimitiveType(NodeList<AnnotationExpr> annotations) throws ParseException {PrimitiveType ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:{
      jj_consume_token(BOOLEAN);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.BOOLEAN, annotations);
      break;
      }
    case CHAR:{
      jj_consume_token(CHAR);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.CHAR, annotations);
      break;
      }
    case BYTE:{
      jj_consume_token(BYTE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.BYTE, annotations);
      break;
      }
    case SHORT:{
      jj_consume_token(SHORT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.SHORT, annotations);
      break;
      }
    case INT:{
      jj_consume_token(INT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.INT, annotations);
      break;
      }
    case LONG:{
      jj_consume_token(LONG);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.LONG, annotations);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.FLOAT, annotations);
      break;
      }
    case DOUBLE:{
      jj_consume_token(DOUBLE);
ret = new PrimitiveType(tokenRange(), PrimitiveType.Primitive.DOUBLE, annotations);
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public Type ResultType(NodeList<AnnotationExpr> annotations) throws ParseException {Type ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case VOID:{
      jj_consume_token(VOID);
ret = new VoidType(tokenRange());
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      ret = Type(annotations);
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public Name Name() throws ParseException {Name ret;
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    annotations = Annotations();
    Identifier();
ret = new Name(tokenRange(), null, token.image, annotations);
    label_27:
    while (true) {
      if (jj_2_25(2147483647)) {
        ;
      } else {
        break label_27;
      }
      jj_consume_token(DOT);
      annotations = Annotations();
      Identifier();
ret = new Name(range(ret, token()), ret, token.image, annotations);
    }
return ret;
}

  final public SimpleName SimpleName() throws ParseException {SimpleName ret;
    Identifier();
ret = new SimpleName(tokenRange(), token.image);
return ret;
}

  final public String Identifier() throws ParseException {String ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RULE:{
      jj_consume_token(RULE);
      break;
      }
    case MODULE:{
      jj_consume_token(MODULE);
      break;
      }
    case REQUIRES:{
      jj_consume_token(REQUIRES);
      break;
      }
    case TO:{
      jj_consume_token(TO);
      break;
      }
    case WITH:{
      jj_consume_token(WITH);
      break;
      }
    case OPEN:{
      jj_consume_token(OPEN);
      break;
      }
    case OPENS:{
      jj_consume_token(OPENS);
      break;
      }
    case USES:{
      jj_consume_token(USES);
      break;
      }
    case EXPORTS:{
      jj_consume_token(EXPORTS);
      break;
      }
    case PROVIDES:{
      jj_consume_token(PROVIDES);
      break;
      }
    case TRANSITIVE:{
      jj_consume_token(TRANSITIVE);
      break;
      }
    case ENUM:{
      jj_consume_token(ENUM);
      break;
      }
    case STRICTFP:{
      jj_consume_token(STRICTFP);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret = token.image; setTokenKind(IDENTIFIER);
return ret;
}

/*
 * Expression syntax follows.
 */
  final public 
Expression Expression() throws ParseException {Expression ret;
        AssignExpr.Operator op;
        Expression value;
        Statement lambdaBody = null;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
    ret = ConditionalExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:
    case PLUSASSIGN:
    case MINUSASSIGN:
    case STARASSIGN:
    case SLASHASSIGN:
    case ANDASSIGN:
    case ORASSIGN:
    case XORASSIGN:
    case REMASSIGN:
    case LSHIFTASSIGN:
    case RSIGNEDSHIFTASSIGN:
    case RUNSIGNEDSHIFTASSIGN:
    case ARROW:
    case DOUBLECOLON:{
      if (jj_2_26(2)) {
        op = AssignmentOperator();
        value = Expression();
ret = new AssignExpr(range(ret, token()), ret, value, op);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ARROW:{
          jj_consume_token(ARROW);
          lambdaBody = LambdaBody();
if (ret instanceof CastExpr) {
                    ret = generateLambda(ret, lambdaBody);
                } else if (ret instanceof ConditionalExpr) {
                    ConditionalExpr ce = (ConditionalExpr) ret;
                    if(ce.getElseExpr() != null) {
                        ce.setElseExpr(generateLambda(ce.getElseExpr(), lambdaBody));
                    }
                } else {
                    ret = generateLambda(ret, lambdaBody);
                }
          break;
          }
        case DOUBLECOLON:{
          jj_consume_token(DOUBLECOLON);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[64] = jj_gen;
            ;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ENUM:
          case STRICTFP:
          case REQUIRES:
          case TO:
          case WITH:
          case OPEN:
          case OPENS:
          case USES:
          case MODULE:
          case EXPORTS:
          case PROVIDES:
          case TRANSITIVE:
          case RULE:
          case IDENTIFIER:{
            Identifier();
            break;
            }
          case NEW:{
            jj_consume_token(NEW);
            break;
            }
          default:
            jj_la1[65] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
return ret;
}

  final public AssignExpr.Operator AssignmentOperator() throws ParseException {AssignExpr.Operator ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
ret = AssignExpr.Operator.ASSIGN;
      break;
      }
    case STARASSIGN:{
      jj_consume_token(STARASSIGN);
ret = AssignExpr.Operator.MULTIPLY;
      break;
      }
    case SLASHASSIGN:{
      jj_consume_token(SLASHASSIGN);
ret = AssignExpr.Operator.DIVIDE;
      break;
      }
    case REMASSIGN:{
      jj_consume_token(REMASSIGN);
ret = AssignExpr.Operator.REMAINDER;
      break;
      }
    case PLUSASSIGN:{
      jj_consume_token(PLUSASSIGN);
ret = AssignExpr.Operator.PLUS;
      break;
      }
    case MINUSASSIGN:{
      jj_consume_token(MINUSASSIGN);
ret = AssignExpr.Operator.MINUS;
      break;
      }
    case LSHIFTASSIGN:{
      jj_consume_token(LSHIFTASSIGN);
ret = AssignExpr.Operator.LEFT_SHIFT;
      break;
      }
    case RSIGNEDSHIFTASSIGN:{
      jj_consume_token(RSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.SIGNED_RIGHT_SHIFT;
      break;
      }
    case RUNSIGNEDSHIFTASSIGN:{
      jj_consume_token(RUNSIGNEDSHIFTASSIGN);
ret = AssignExpr.Operator.UNSIGNED_RIGHT_SHIFT;
      break;
      }
    case ANDASSIGN:{
      jj_consume_token(ANDASSIGN);
ret = AssignExpr.Operator.AND;
      break;
      }
    case XORASSIGN:{
      jj_consume_token(XORASSIGN);
ret = AssignExpr.Operator.XOR;
      break;
      }
    case ORASSIGN:{
      jj_consume_token(ORASSIGN);
ret = AssignExpr.Operator.OR;
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public Expression ConditionalExpression() throws ParseException {Expression ret;
        Expression left;
        Expression right;
    ret = ConditionalOrExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case HOOK:{
      jj_consume_token(HOOK);
      left = Expression();
      jj_consume_token(COLON);
      right = ConditionalExpression();
ret = new ConditionalExpr(range(ret, token()), ret, left, right);
      break;
      }
    default:
      jj_la1[69] = jj_gen;
      ;
    }
return ret;
}

  final public Expression ConditionalOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = ConditionalAndExpression();
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_OR:{
        ;
        break;
        }
      default:
        jj_la1[70] = jj_gen;
        break label_28;
      }
      jj_consume_token(SC_OR);
      right = ConditionalAndExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.OR);
    }
return ret;
}

  final public Expression ConditionalAndExpression() throws ParseException {Expression ret;
        Expression right;
    ret = InclusiveOrExpression();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SC_AND:{
        ;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_29;
      }
      jj_consume_token(SC_AND);
      right = InclusiveOrExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.AND);
    }
return ret;
}

  final public Expression InclusiveOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = ExclusiveOrExpression();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_OR:{
        ;
        break;
        }
      default:
        jj_la1[72] = jj_gen;
        break label_30;
      }
      jj_consume_token(BIT_OR);
      right = ExclusiveOrExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.BINARY_OR);
    }
return ret;
}

  final public Expression ExclusiveOrExpression() throws ParseException {Expression ret;
        Expression right;
    ret = AndExpression();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case XOR:{
        ;
        break;
        }
      default:
        jj_la1[73] = jj_gen;
        break label_31;
      }
      jj_consume_token(XOR);
      right = AndExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.XOR);
    }
return ret;
}

  final public Expression AndExpression() throws ParseException {Expression ret;
        Expression right;
    ret = EqualityExpression();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_AND:{
        ;
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        break label_32;
      }
      jj_consume_token(BIT_AND);
      right = EqualityExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, BinaryExpr.Operator.BINARY_AND);
    }
return ret;
}

  final public Expression EqualityExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = InstanceOfExpression();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:
      case NE:{
        ;
        break;
        }
      default:
        jj_la1[75] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = BinaryExpr.Operator.EQUALS;
        break;
        }
      case NE:{
        jj_consume_token(NE);
op = BinaryExpr.Operator.NOT_EQUALS;
        break;
        }
      default:
        jj_la1[76] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = InstanceOfExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
return ret;
}

  final public Expression InstanceOfExpression() throws ParseException {Expression ret;
        ReferenceType type;
        NodeList<AnnotationExpr> annotations;
    ret = RelationalExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INSTANCEOF:{
      jj_consume_token(INSTANCEOF);
      type = AnnotatedReferenceType();
ret = new InstanceOfExpr(range(ret, token()), ret, type);
      break;
      }
    default:
      jj_la1[77] = jj_gen;
      ;
    }
return ret;
}

  final public Expression RelationalExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = ShiftExpression();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:
      case LE:
      case GE:
      case GT:{
        ;
        break;
        }
      default:
        jj_la1[78] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        jj_consume_token(LT);
op = BinaryExpr.Operator.LESS;
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = BinaryExpr.Operator.GREATER;
        break;
        }
      case LE:{
        jj_consume_token(LE);
op = BinaryExpr.Operator.LESS_EQUALS;
        break;
        }
      case GE:{
        jj_consume_token(GE);
op = BinaryExpr.Operator.GREATER_EQUALS;
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = ShiftExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
return ret;
}

  final public Expression ShiftExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = AdditiveExpression();
    label_35:
    while (true) {
      if (jj_2_27(1)) {
        ;
      } else {
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSHIFT:{
        jj_consume_token(LSHIFT);
op = BinaryExpr.Operator.LEFT_SHIFT;
        break;
        }
      default:
        jj_la1[80] = jj_gen;
        if (jj_2_28(1)) {
          RSIGNEDSHIFT();
op = BinaryExpr.Operator.SIGNED_RIGHT_SHIFT;
        } else if (jj_2_29(1)) {
          RUNSIGNEDSHIFT();
op = BinaryExpr.Operator.UNSIGNED_RIGHT_SHIFT;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      right = AdditiveExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
return ret;
}

  final public Expression AdditiveExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = MultiplicativeExpression();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        break label_36;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = BinaryExpr.Operator.PLUS;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = BinaryExpr.Operator.MINUS;
        break;
        }
      default:
        jj_la1[82] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = MultiplicativeExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
return ret;
}

  final public Expression MultiplicativeExpression() throws ParseException {Expression ret;
        Expression right;
        BinaryExpr.Operator op;
    ret = UnaryExpression();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:
      case SLASH:
      case REM:{
        ;
        break;
        }
      default:
        jj_la1[83] = jj_gen;
        break label_37;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
op = BinaryExpr.Operator.MULTIPLY;
        break;
        }
      case SLASH:{
        jj_consume_token(SLASH);
op = BinaryExpr.Operator.DIVIDE;
        break;
        }
      case REM:{
        jj_consume_token(REM);
op = BinaryExpr.Operator.REMAINDER;
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      right = UnaryExpression();
ret = new BinaryExpr(range(ret, token()), ret, right, op);
    }
return ret;
}

  final public Expression UnaryExpression() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
        JavaToken begin = INVALID;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INCR:{
      ret = PreIncrementExpression();
      break;
      }
    case DECR:{
      ret = PreDecrementExpression();
      break;
      }
    case PLUS:
    case MINUS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = UnaryExpr.Operator.PLUS; begin=token();
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = UnaryExpr.Operator.MINUS; begin=token();
        break;
        }
      default:
        jj_la1[85] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      if (jj_2_30(1)) {
        ret = HalfBinaryExpression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public Expression PreIncrementExpression() throws ParseException {Expression ret;
        JavaToken begin = INVALID;
    jj_consume_token(INCR);
begin=token();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, UnaryExpr.Operator.PREFIX_INCREMENT);
return ret;
}

  final public Expression PreDecrementExpression() throws ParseException {Expression ret;
        JavaToken begin;
    jj_consume_token(DECR);
begin=token();
    ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, UnaryExpr.Operator.PREFIX_DECREMENT);
return ret;
}

// drlx start
  final public 

Expression HalfBinaryExpression() throws ParseException {Expression ret;
        HalfBinaryExpr.Operator op;
        JavaToken begin = INVALID;
        boolean isDrl = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case GT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = HalfBinaryExpr.Operator.EQUALS; begin=token();
        break;
        }
      case NE:{
        jj_consume_token(NE);
op = HalfBinaryExpr.Operator.NOT_EQUALS; begin=token();
        break;
        }
      case LT:{
        jj_consume_token(LT);
op = HalfBinaryExpr.Operator.LESS; begin=token();
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = HalfBinaryExpr.Operator.GREATER; begin=token();
        break;
        }
      case LE:{
        jj_consume_token(LE);
op = HalfBinaryExpr.Operator.LESS_EQUALS; begin=token();
        break;
        }
      case GE:{
        jj_consume_token(GE);
op = HalfBinaryExpr.Operator.GREATER_EQUALS; begin=token();
        break;
        }
      default:
        jj_la1[87] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_31(2147483647)) {
        ret = HalfBinaryExpression();
      } else if (jj_2_32(1)) {
        ret = Expression();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
isDrl = true;
        ret = new HalfBinaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      if (jj_2_33(1)) {
        ret = DrlxExpressionSwitch();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return isDrl ? asDrlNode(ret) : ret;
}

  final public Expression DrlxExpressionSwitch() throws ParseException {Expression ret;
    boolean isDrl = false;
    if (jj_2_34(2147483647) && (drlParsing)) {
      ret = PointFreeExprMvel();
    } else if (jj_2_35(2147483647) && (drlParsing)) {
      ret = HalfPointFreeExprMvel();
    } else if (jj_2_36(2147483647) && (drlParsing)) {
      ret = PointFreeExpr();
    } else if (jj_2_37(2147483647) && (drlParsing && (isPointFreeOperator(getToken(1).image) || isPointFreeOperator(getToken(2).image) ))) {
      ret = HalfPointFreeExpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case BANG:
      case TILDE:
      case 150:{
        ret = UnaryExpressionNotPlusMinus();
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return isDrl ? asDrlNode(ret) : ret;
}

// drlx end
  final public 
Expression UnaryExpressionNotPlusMinus() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
        JavaToken begin = INVALID;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BANG:
    case TILDE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TILDE:{
        jj_consume_token(TILDE);
op = UnaryExpr.Operator.BITWISE_COMPLEMENT; begin=token();
        break;
        }
      case BANG:{
        jj_consume_token(BANG);
op = UnaryExpr.Operator.LOGICAL_COMPLEMENT;     begin=token();
        break;
        }
      default:
        jj_la1[90] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      ret = UnaryExpression();
ret = new UnaryExpr(range(begin, token()), ret, op);
      break;
      }
    default:
      jj_la1[91] = jj_gen;
      if (jj_2_38(2147483647)) {
        ret = CastExpression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:
        case 150:{
          ret = PostfixExpression();
          break;
          }
        default:
          jj_la1[92] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return ret;
}

  final public Expression PostfixExpression() throws ParseException {Expression ret;
        UnaryExpr.Operator op;
    ret = PrimaryExpression();
    if (jj_2_39(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INCR:{
        jj_consume_token(INCR);
op = UnaryExpr.Operator.POSTFIX_INCREMENT;
        break;
        }
      case DECR:{
        jj_consume_token(DECR);
op = UnaryExpr.Operator.POSTFIX_DECREMENT;
        break;
        }
      default:
        jj_la1[93] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
ret = new UnaryExpr(range(ret, token()), ret, op);
    } else {
      ;
    }
return ret;
}

  final public Expression CastExpression() throws ParseException {Expression ret;
        ReferenceType referenceType;
        PrimitiveType primitiveType;
        JavaToken begin = INVALID;
        NodeList<AnnotationExpr> annotations;
        NodeList<ReferenceType> typesOfMultiCast = emptyList();
    jj_consume_token(LPAREN);
begin=token();
    annotations = Annotations();
    if (jj_2_40(2)) {
      primitiveType = PrimitiveType(annotations);
      jj_consume_token(RPAREN);
      ret = UnaryExpression();
ret = new CastExpr(range(begin, token()), primitiveType, ret);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FLOAT:
      case INT:
      case LONG:
      case SHORT:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        referenceType = ReferenceType(annotations);
typesOfMultiCast = add(typesOfMultiCast, referenceType);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case BIT_AND:{
            ;
            break;
            }
          default:
            jj_la1[94] = jj_gen;
            break label_38;
          }
          jj_consume_token(BIT_AND);
          referenceType = AnnotatedReferenceType();
typesOfMultiCast = add(typesOfMultiCast, referenceType);
        }
        jj_consume_token(RPAREN);
        ret = UnaryExpressionNotPlusMinus();
if (typesOfMultiCast.size() > 1) {
                ret = new CastExpr(range(begin, token()), new IntersectionType(range(typesOfMultiCast.get(0), typesOfMultiCast.get(typesOfMultiCast.size() -1)), typesOfMultiCast), ret);
            } else {
                ret = new CastExpr(range(begin, token()), referenceType, ret);
            }
        break;
        }
      default:
        jj_la1[95] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public Expression PrimaryExpression() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_39:
    while (true) {
      if (jj_2_41(2)) {
        ;
      } else {
        break label_39;
      }
      ret = PrimarySuffix(ret);
    }
return ret;
}

  final public Expression PrimaryExpressionWithoutSuperSuffix() throws ParseException {Expression ret;
    ret = PrimaryPrefix();
    label_40:
    while (true) {
      if (jj_2_42(2147483647)) {
        ;
      } else {
        break label_40;
      }
      ret = PrimarySuffixWithoutSuper(ret);
    }
return ret;
}

  final public Expression PrimaryPrefix() throws ParseException {Expression ret = null;
        SimpleName name;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        NodeList<Expression> args = emptyList();
        NodeList<Parameter> params = emptyList();
        boolean hasArgs = false;
        boolean isLambda = false;
        Type type;
        JavaToken begin;
        Parameter p = null;
        SimpleName id = null;
        int numberOfBackReferences = 0;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FALSE:
    case NULL:
    case TRUE:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:{
      ret = Literal();
      break;
      }
    case THIS:{
      jj_consume_token(THIS);
ret = new ThisExpr(tokenRange(), null);
      break;
      }
    case SUPER:{
      jj_consume_token(SUPER);
ret = new SuperExpr(tokenRange(), null);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[96] = jj_gen;
          ;
        }
        name = SimpleName();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LPAREN:{
          args = Arguments();
hasArgs=true;
          break;
          }
        default:
          jj_la1[97] = jj_gen;
          ;
        }
if (hasArgs) {
                                ret = new MethodCallExpr(range(ret, token()), ret, typeArgs.list, name, args);
                        } else {
                                ret = new FieldAccessExpr(range(ret, token()), ret, emptyList(), name);
                        }
        break;
        }
      case DOUBLECOLON:{
        jj_consume_token(DOUBLECOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[98] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:{
          Identifier();
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
        break;
        }
      default:
        jj_la1[100] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case LPAREN:{
      jj_consume_token(LPAREN);
begin=token();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case RPAREN:{
        jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        if (jj_2_43(2147483647)) {
          ret = Expression();
          jj_consume_token(RPAREN);
ret = new EnclosedExpr(range(begin, token()), ret);
        } else if (jj_2_44(2147483647)) {
          params = LambdaParameters();
          jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        } else if (jj_2_45(2147483647)) {
          params = InferredLambdaParameters();
          jj_consume_token(RPAREN);
ret = new LambdaExpr(range(begin, token()), params, new BlockStmt(), true);
        } else if (jj_2_46(1)) {
          // This could still be a lambda expression, but this is handled after matching -> elsewhere
                      ret = Expression();
          jj_consume_token(RPAREN);
ret = new EnclosedExpr(range(begin, token()), ret);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case NEW:{
      ret = AllocationExpression(null);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
      if (jj_2_47(2147483647)) {
        type = ResultType(emptyList());
        jj_consume_token(DOT);
        jj_consume_token(CLASS);
ret = new ClassExpr(range(type, token()), type);
      } else if (jj_2_48(2147483647)) {
        type = AnnotatedType();
        jj_consume_token(DOUBLECOLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LT:{
          typeArgs = TypeArguments();
          break;
          }
        default:
          jj_la1[102] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:{
          Identifier();
          break;
          }
        case NEW:{
          jj_consume_token(NEW);
          break;
          }
        default:
          jj_la1[103] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
ret = new TypeExpr(range(type, type), type);
                  ret = new MethodReferenceExpr(range(ret, token()), ret, typeArgs.list, token.image);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ENUM:
        case STRICTFP:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case IDENTIFIER:
        case 150:{
          label_41:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case 150:{
              ;
              break;
              }
            default:
              jj_la1[104] = jj_gen;
              break label_41;
            }
            jj_consume_token(150);
numberOfBackReferences++;
          }
          name = SimpleName();
begin=token();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[105] = jj_gen;
            ;
          }
if (hasArgs) {
                                ret = new MethodCallExpr(range(begin, token()), null, null, name, args);
                        } else {
                                ret = new NameExpr(name, numberOfBackReferences );
                        }
          break;
          }
        default:
          jj_la1[107] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return ret;
}

  final public Expression PrimarySuffix(Expression scope) throws ParseException {Expression ret;
    if (jj_2_49(2)) {
      ret = PrimarySuffixWithoutSuper(scope);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        jj_consume_token(SUPER);
ret = new SuperExpr(range(scope, token()), scope);
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ret;
}

  final public Expression PrimarySuffixWithoutSuper(Expression scope) throws ParseException {Expression ret;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        NodeList<Expression> args = emptyList();
        boolean hasArgs = false;
        SimpleName name;
        Type type;
        boolean isDrl = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case THIS:{
        jj_consume_token(THIS);
ret = new ThisExpr(range(scope, token()), scope);
        break;
        }
      case NEW:{
        ret = AllocationExpression(scope);
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        if (jj_2_50(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[109] = jj_gen;
            ;
          }
          name = SimpleName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[110] = jj_gen;
            ;
          }
if (hasArgs) {
                                ret = new MethodCallExpr(range(scope, token()), scope, typeArgs.list, name, args);
                        } else {
                                ret =  new FieldAccessExpr(range(scope, token()), scope, typeArgs.list, name);
                        }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      ret = Expression();
      jj_consume_token(RBRACKET);
ret = new ArrayAccessExpr(range(scope, token()), scope, ret);
      break;
      }
    case 151:{
      jj_consume_token(151);
isDrl=true;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        name = SimpleName();
ret = new InlineCastExpr(range(scope.getTokenRange().get().getBegin(), token()),
                                                           new ClassOrInterfaceType(range(name.getTokenRange().get().getBegin(), token()), null, name, null, emptyList()),
                                                           scope);
        break;
        }
      case LPAREN:{
        jj_consume_token(LPAREN);
        type = Type(emptyList());
        jj_consume_token(RPAREN);
ret = new InlineCastExpr(range(scope.getTokenRange().get().getBegin(), token()), type, scope);
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case 152:{
      jj_consume_token(152);
isDrl=true;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case THIS:{
        jj_consume_token(THIS);
ret = new ThisExpr(range(scope.getTokenRange().get().getBegin(), token()), scope);
        break;
        }
      case NEW:{
        ret = AllocationExpression(scope);
        break;
        }
      default:
        jj_la1[115] = jj_gen;
        if (jj_2_51(2147483647)) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LT:{
            typeArgs = TypeArguments();
            break;
            }
          default:
            jj_la1[113] = jj_gen;
            ;
          }
          name = SimpleName();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LPAREN:{
            args = Arguments();
hasArgs=true;
            break;
            }
          default:
            jj_la1[114] = jj_gen;
            ;
          }
if (hasArgs) {
                ret = new NullSafeMethodCallExpr(range(scope.getTokenRange().get().getBegin(), token()), scope, typeArgs.list, name, args);
            } else {
                ret =  new NullSafeFieldAccessExpr(range(scope.getTokenRange().get().getBegin(), token()), scope, typeArgs.list, name);
            }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return isDrl ? asDrlNode(ret) : ret;
}

  final public Expression Literal() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_LITERAL:{
      jj_consume_token(INTEGER_LITERAL);
ret = new IntegerLiteralExpr(tokenRange(), token.image);
      break;
      }
    case LONG_LITERAL:{
      jj_consume_token(LONG_LITERAL);
ret = new LongLiteralExpr(tokenRange(), token.image);
      break;
      }
    case BIG_DECIMAL_LITERAL:{
      jj_consume_token(BIG_DECIMAL_LITERAL);
ret = new BigDecimalLiteralExpr(tokenRange(), token.image);
      break;
      }
    case BIG_INTEGER_LITERAL:{
      jj_consume_token(BIG_INTEGER_LITERAL);
ret = new BigIntegerLiteralExpr(tokenRange(), token.image);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      jj_consume_token(FLOATING_POINT_LITERAL);
ret = new DoubleLiteralExpr(tokenRange(), token.image);
      break;
      }
    case CHARACTER_LITERAL:{
      jj_consume_token(CHARACTER_LITERAL);
ret = new CharLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case STRING_LITERAL:{
      jj_consume_token(STRING_LITERAL);
ret = new StringLiteralExpr(tokenRange(), token.image.substring(1, token.image.length()-1));
      break;
      }
    case FALSE:
    case TRUE:{
      ret = BooleanLiteral();
      break;
      }
    case NULL:{
      ret = NullLiteral();
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public Expression BooleanLiteral() throws ParseException {Expression ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TRUE:{
      jj_consume_token(TRUE);
ret = new BooleanLiteralExpr(tokenRange(), true);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
ret = new BooleanLiteralExpr(tokenRange(), false);
      break;
      }
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public Expression NullLiteral() throws ParseException {
    jj_consume_token(NULL);
return new NullLiteralExpr(tokenRange());
}

  final public NodeList<Expression> Arguments() throws ParseException {NodeList<Expression> ret = emptyList();
    jj_consume_token(LPAREN);
    if (jj_2_52(1)) {
      ret = ArgumentList();
    } else {
      ;
    }
    jj_consume_token(RPAREN);
return ret;
}

  final public NodeList<Expression> ArgumentList() throws ParseException {NodeList<Expression> ret = emptyList();
        Expression expr;
    expr = Expression();
ret.add(expr);
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[119] = jj_gen;
        break label_42;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
return ret;
}

  final public Expression AllocationExpression(Expression scope) throws ParseException {Expression ret;
        Type type;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        NodeList<BodyDeclaration<?>> anonymousBody = null;
        NodeList<Expression> args;
        JavaToken begin = INVALID;
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
    jj_consume_token(NEW);
if(scope==null) {begin=token();} else {begin = orIfInvalid(begin, scope);}
    annotations = Annotations();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:{
      type = PrimitiveType(annotations);
      ret = ArrayCreation(begin, type);
      break;
      }
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:
    case AT:
    case LT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LT:{
        typeArgs = TypeArguments();
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        ;
      }
      type = AnnotatedClassOrInterfaceType();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case AT:{
        ret = ArrayCreation(begin, type);
        break;
        }
      case LPAREN:{
        args = Arguments();
        if (jj_2_53(2)) {
          anonymousBody = ClassOrInterfaceBody();
        } else {
          ;
        }
ret = new ObjectCreationExpr(range(begin, token()), scope, (ClassOrInterfaceType) type, typeArgs.list, args, anonymousBody);
        break;
        }
      default:
        jj_la1[121] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[122] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public ArrayCreationExpr ArrayCreation(JavaToken begin, Type type) throws ParseException {Expression expr = null;
        ArrayInitializerExpr arrayInitializerExpr = null;
        NodeList<Expression> inits = emptyList();
        List<NodeList<AnnotationExpr>> accum = new ArrayList<NodeList<AnnotationExpr>>();
        NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
        JavaToken arrayCreationLevelStart = INVALID;
        List<TokenRange> levelRanges = new ArrayList<TokenRange>();
    label_43:
    while (true) {
      annotations = Annotations();
      jj_consume_token(LBRACKET);
arrayCreationLevelStart = annotations.isEmpty() ? token() : orIfInvalid(arrayCreationLevelStart, annotations.get(0));
      if (jj_2_54(1)) {
        expr = Expression();
      } else {
        ;
      }
accum = add(accum, annotations); inits = add(inits, expr); annotations=null; expr=null;
      jj_consume_token(RBRACKET);
levelRanges.add(range(arrayCreationLevelStart, token()));
      if (jj_2_55(2)) {
        ;
      } else {
        break label_43;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACE:{
      arrayInitializerExpr = ArrayInitializer();
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      ;
    }
return juggleArrayCreation(range(begin, token()), levelRanges, type, inits, accum, arrayInitializerExpr);
}

/*
 * Statement syntax follows.
 */
  final public 
Statement Statement() throws ParseException {Statement ret;
    try {
      if (jj_2_56(2)) {
        ret = LabeledStatement();
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ASSERT:{
          ret = AssertStatement();
          break;
          }
        case LBRACE:{
          ret = Block();
          break;
          }
        case SEMICOLON:{
          ret = EmptyStatement();
          break;
          }
        case BOOLEAN:
        case BYTE:
        case CHAR:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case THIS:
        case TRUE:
        case VOID:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case AT:
        case INCR:
        case DECR:
        case 150:{
          ret = StatementExpression();
          break;
          }
        case SWITCH:{
          ret = SwitchStatement();
          break;
          }
        case IF:{
          ret = IfStatement();
          break;
          }
        case WHILE:{
          ret = WhileStatement();
          break;
          }
        case DO:{
          ret = DoStatement();
          break;
          }
        case FOR:{
          ret = ForStatement();
          break;
          }
        case BREAK:{
          ret = BreakStatement();
          break;
          }
        case CONTINUE:{
          ret = ContinueStatement();
          break;
          }
        case RETURN:{
          ret = ReturnStatement();
          break;
          }
        case THROW:{
          ret = ThrowStatement();
          break;
          }
        case SYNCHRONIZED:{
          ret = SynchronizedStatement();
          break;
          }
        case TRY:{
          ret = TryStatement();
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
return ret;
    } catch (ParseException e) {
TokenRange errorRange = recover(SEMICOLON, e);
        return new UnparsableStmt(errorRange);
    }
}

  final public AssertStmt AssertStatement() throws ParseException {Expression check;
        Expression msg = null;
        JavaToken begin;
    jj_consume_token(ASSERT);
begin=token();
    check = Expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      msg = Expression();
      break;
      }
    default:
      jj_la1[125] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new AssertStmt(range(begin, token()), check, msg);
}

  final public LabeledStmt LabeledStatement() throws ParseException {SimpleName label;
        Statement stmt;
        JavaToken begin;
    label = SimpleName();
begin=token();
    jj_consume_token(COLON);
    stmt = Statement();
return new LabeledStmt(range(begin, token()), label, stmt);
}

  final public BlockStmt Block() throws ParseException {NodeList<Statement> stmts = emptyList();
        JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    try {
      stmts = Statements();
      jj_consume_token(RBRACE);
return new BlockStmt(range(begin, token()), stmts);
    } catch (ParseException e) {
recover(RBRACE, e);
        BlockStmt block = new BlockStmt(range(begin, token()), new NodeList<Statement>());
        block.setParsed(UNPARSABLE);
        return block;
    }
}

/*
 * Classes inside body statements can only be abstract or final. The semantic must check it.
 */
  final public Statement BlockStatement() throws ParseException {Statement ret;
        Expression expr;
        ClassOrInterfaceDeclaration typeDecl;
        ModifierHolder modifier;
    try {
      if (jj_2_57(2147483647)) {
        modifier = Modifiers();
        typeDecl = ClassOrInterfaceDeclaration(modifier);
ret = new LocalClassDeclarationStmt(range(typeDecl, token()), typeDecl);
      } else if (jj_2_58(2147483647)) {
        expr = VariableDeclarationExpression();
        jj_consume_token(SEMICOLON);
ret = new ExpressionStmt(range(expr, token()), expr);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ASSERT:
        case BOOLEAN:
        case BREAK:
        case BYTE:
        case CHAR:
        case CONTINUE:
        case DO:
        case DOUBLE:
        case ENUM:
        case FALSE:
        case FLOAT:
        case FOR:
        case IF:
        case INT:
        case LONG:
        case NEW:
        case NULL:
        case RETURN:
        case SHORT:
        case STRICTFP:
        case SUPER:
        case SWITCH:
        case SYNCHRONIZED:
        case THIS:
        case THROW:
        case TRUE:
        case TRY:
        case VOID:
        case WHILE:
        case REQUIRES:
        case TO:
        case WITH:
        case OPEN:
        case OPENS:
        case USES:
        case MODULE:
        case EXPORTS:
        case PROVIDES:
        case TRANSITIVE:
        case RULE:
        case LONG_LITERAL:
        case INTEGER_LITERAL:
        case BIG_INTEGER_LITERAL:
        case BIG_DECIMAL_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case IDENTIFIER:
        case LPAREN:
        case LBRACE:
        case SEMICOLON:
        case AT:
        case INCR:
        case DECR:
        case 150:{
          ret = Statement();
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
return ret;
    } catch (ParseException e) {
TokenRange errorRange = recover(SEMICOLON, e);
        return new UnparsableStmt(errorRange);
    }
}

  final public VariableDeclarationExpr VariableDeclarationExpression() throws ParseException {ModifierHolder modifier;
        Type partialType;
        NodeList<VariableDeclarator> variables = new NodeList<VariableDeclarator>();
        VariableDeclarator var;
    modifier = Modifiers();
    partialType = Type(emptyList());
    var = VariableDeclarator(partialType);
variables.add(var);
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      var = VariableDeclarator(partialType);
variables.add(var);
    }
JavaToken begin=orIfInvalid(modifier.begin, partialType);
        return new VariableDeclarationExpr(range(begin, token()), modifier.modifiers, modifier.annotations, variables);
}

  final public EmptyStmt EmptyStatement() throws ParseException {
    jj_consume_token(SEMICOLON);
return new EmptyStmt(tokenRange());
}

  final public Statement LambdaBody() throws ParseException {Expression expr;
    Statement n = null;
    if (jj_2_59(1)) {
      expr = Expression();
n = new ExpressionStmt(range(expr, token()), expr);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACE:{
        n = Block();
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return n;
}

  final public ExpressionStmt StatementExpression() throws ParseException {Expression expr;
        AssignExpr.Operator op;
        Expression value;
        RangedList<Type> typeArgs = new RangedList<Type>(null);
        Statement lambdaBody;
    if (jj_2_60(2)) {
      expr = PreIncrementExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DECR:{
        expr = PreDecrementExpression();
        break;
        }
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case 150:{
        expr = PrimaryExpression();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ASSIGN:
        case INCR:
        case DECR:
        case PLUSASSIGN:
        case MINUSASSIGN:
        case STARASSIGN:
        case SLASHASSIGN:
        case ANDASSIGN:
        case ORASSIGN:
        case XORASSIGN:
        case REMASSIGN:
        case LSHIFTASSIGN:
        case RSIGNEDSHIFTASSIGN:
        case RUNSIGNEDSHIFTASSIGN:{
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case INCR:{
            jj_consume_token(INCR);
expr = new UnaryExpr(range(expr, token()), expr, UnaryExpr.Operator.POSTFIX_INCREMENT);
            break;
            }
          case DECR:{
            jj_consume_token(DECR);
expr = new UnaryExpr(range(expr, token()), expr, UnaryExpr.Operator.POSTFIX_DECREMENT);
            break;
            }
          case ASSIGN:
          case PLUSASSIGN:
          case MINUSASSIGN:
          case STARASSIGN:
          case SLASHASSIGN:
          case ANDASSIGN:
          case ORASSIGN:
          case XORASSIGN:
          case REMASSIGN:
          case LSHIFTASSIGN:
          case RSIGNEDSHIFTASSIGN:
          case RUNSIGNEDSHIFTASSIGN:{
            op = AssignmentOperator();
            value = Expression();
expr = new AssignExpr(range(expr, token()), expr, value, op);
            break;
            }
          default:
            jj_la1[129] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[131] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(SEMICOLON);
return new ExpressionStmt(range(expr, token()), expr);
}

  final public SwitchStmt SwitchStatement() throws ParseException {Expression selector;
        SwitchEntryStmt entry;
        NodeList<SwitchEntryStmt> entries = emptyList();
        JavaToken begin;
    jj_consume_token(SWITCH);
begin=token();
    jj_consume_token(LPAREN);
    selector = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(LBRACE);
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CASE:
      case _DEFAULT:{
        ;
        break;
        }
      default:
        jj_la1[132] = jj_gen;
        break label_45;
      }
      entry = SwitchEntry();
entries = add(entries, entry);
    }
    jj_consume_token(RBRACE);
return new SwitchStmt(range(begin, token()), selector, entries);
}

  final public SwitchEntryStmt SwitchEntry() throws ParseException {Expression label = null;
        NodeList<Statement> stmts;
        JavaToken begin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CASE:{
      jj_consume_token(CASE);
begin=token();
      label = Expression();
      break;
      }
    case _DEFAULT:{
      jj_consume_token(_DEFAULT);
begin=token();
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(COLON);
    stmts = Statements();
return new SwitchEntryStmt(range(begin, token()),label, stmts);
}

  final public IfStmt IfStatement() throws ParseException {Expression condition;
        Statement thenStmt;
        Statement elseStmt = null;
        JavaToken begin;
    jj_consume_token(IF);
begin=token();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);

    thenStmt = Statement();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      jj_consume_token(ELSE);

      elseStmt = Statement();
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      ;
    }
return new IfStmt(range(begin, token()), condition, thenStmt, elseStmt);
}

  final public WhileStmt WhileStatement() throws ParseException {Expression condition;
        Statement body;
        JavaToken begin;
    jj_consume_token(WHILE);
begin=token();
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    body = Statement();
return new WhileStmt(range(begin, token()),condition, body);
}

  final public DoStmt DoStatement() throws ParseException {Expression condition;
        Statement body;
        JavaToken begin;
    jj_consume_token(DO);
begin=token();
    body = Statement();
    jj_consume_token(WHILE);
    jj_consume_token(LPAREN);
    condition = Expression();
    jj_consume_token(RPAREN);
    jj_consume_token(SEMICOLON);
return new DoStmt(range(begin, token()),body, condition);
}

  final public Statement ForStatement() throws ParseException {VariableDeclarationExpr varExpr = null;
        Expression expr = null;
        NodeList<Expression> init = emptyList();
        NodeList<Expression> update = emptyList();
        Statement body;
        JavaToken begin;
    jj_consume_token(FOR);
begin=token();
    jj_consume_token(LPAREN);
    if (jj_2_64(2147483647)) {
      varExpr = VariableDeclarationExpression();
      jj_consume_token(COLON);
      expr = Expression();
    } else if (jj_2_65(1)) {
      if (jj_2_61(1)) {
        init = ForInit();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      if (jj_2_62(1)) {
        expr = Expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      if (jj_2_63(1)) {
        update = ForUpdate();
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(RPAREN);
    body = Statement();
if (varExpr != null) {
                return new ForeachStmt(range(begin, token()),varExpr, expr, body);
        }
        return new ForStmt(range(begin, token()),init, expr, update, body);
}

  final public NodeList<Expression> ForInit() throws ParseException {NodeList<Expression> ret;
        Expression expr;
    if (jj_2_66(2147483647)) {
      expr = VariableDeclarationExpression();
ret = new NodeList<Expression>(); ret.add(expr);
    } else if (jj_2_67(1)) {
      ret = ExpressionList();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  final public NodeList<Expression> ExpressionList() throws ParseException {NodeList<Expression> ret = new NodeList<Expression>();
        Expression expr;
    expr = Expression();
ret.add(expr);
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        break label_46;
      }
      jj_consume_token(COMMA);
      expr = Expression();
ret.add(expr);
    }
return ret;
}

  final public NodeList<Expression> ForUpdate() throws ParseException {NodeList<Expression> ret;
    ret = ExpressionList();
return ret;
}

  final public BreakStmt BreakStatement() throws ParseException {SimpleName label = null;
        JavaToken begin;
    jj_consume_token(BREAK);
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      label = SimpleName();
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new BreakStmt(range(begin, token()), label);
}

  final public ContinueStmt ContinueStatement() throws ParseException {SimpleName label = null;
        JavaToken begin;
    jj_consume_token(CONTINUE);
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ENUM:
    case STRICTFP:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case IDENTIFIER:{
      label = SimpleName();
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
return new ContinueStmt(range(begin, token()), label);
}

  final public ReturnStmt ReturnStatement() throws ParseException {Expression expr = null;
        JavaToken begin;
    jj_consume_token(RETURN);
begin=token();
    if (jj_2_68(1)) {
      expr = Expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
return new ReturnStmt(range(begin, token()),expr);
}

  final public ThrowStmt ThrowStatement() throws ParseException {Expression expr;
        JavaToken begin;
    jj_consume_token(THROW);
begin=token();
    expr = Expression();
    jj_consume_token(SEMICOLON);
return new ThrowStmt(range(begin, token()),expr);
}

  final public SynchronizedStmt SynchronizedStatement() throws ParseException {Expression expr;
        BlockStmt body;
        JavaToken begin;
    jj_consume_token(SYNCHRONIZED);
begin=token();
    jj_consume_token(LPAREN);
    expr = Expression();
    jj_consume_token(RPAREN);
    body = Block();
return new SynchronizedStmt(range(begin, token()),expr, body);
}

  final public TryStmt TryStatement() throws ParseException {NodeList<Expression> resources = emptyList();
        BlockStmt tryBlock;
        BlockStmt finallyBlock = null;
        NodeList<CatchClause> catchs = emptyList();
        BlockStmt catchBlock;
        ModifierHolder exceptModifier;
        ReferenceType exceptionType;
        NodeList<ReferenceType> exceptionTypes = emptyList();
        Pair<SimpleName, List<ArrayBracketPair>> exceptId;
        JavaToken begin;
        JavaToken catchBegin;
        JavaToken typesBegin;
        JavaToken paramEnd;
        Type type;
    jj_consume_token(TRY);
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      resources = ResourceSpecification();
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    tryBlock = Block();
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CATCH:{
        ;
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_47;
      }
      jj_consume_token(CATCH);
catchBegin=token();
      jj_consume_token(LPAREN);
typesBegin=token();
      exceptModifier = Modifiers();
      exceptionType = ReferenceType(emptyList());
exceptionTypes.add(exceptionType);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case BIT_OR:{
          ;
          break;
          }
        default:
          jj_la1[140] = jj_gen;
          break label_48;
        }
        jj_consume_token(BIT_OR);
        exceptionType = AnnotatedReferenceType();
exceptionTypes.add(exceptionType);
      }
      exceptId = VariableDeclaratorId();
paramEnd = token();
      jj_consume_token(RPAREN);
      catchBlock = Block();
if (exceptionTypes.size() > 1) {
                                type = new UnionType(range(exceptionTypes.get(0), exceptionTypes.get(exceptionTypes.size() - 1)), exceptionTypes);
                            } else {
                                type = (Type)exceptionTypes.get(0);
                            }
                                Parameter catchType = new Parameter(range(type, paramEnd), exceptModifier.modifiers, exceptModifier.annotations, type, false, emptyList(), exceptId.a);
                            catchs = add(catchs, new CatchClause(range(catchBegin, token()), catchType, catchBlock));
                            exceptionTypes = emptyList();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FINALLY:{
      jj_consume_token(FINALLY);
      finallyBlock = Block();
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      ;
    }
return new TryStmt(range(begin, token()), resources, tryBlock, catchs, finallyBlock);
}

  final public NodeList<Expression> ResourceSpecification() throws ParseException {NodeList<Expression> variables;
    jj_consume_token(LPAREN);
    variables = Resources();
    if (jj_2_69(2)) {
      jj_consume_token(SEMICOLON);
    } else {
      ;
    }
    jj_consume_token(RPAREN);
return variables;
}

  final public NodeList<Expression> Resources() throws ParseException {NodeList<Expression> expressions = new NodeList<Expression>();
        Expression expr;
    expr = Resource();
expressions.add(expr);
    label_49:
    while (true) {
      if (jj_2_70(2)) {
        ;
      } else {
        break label_49;
      }
      jj_consume_token(SEMICOLON);
      expr = Resource();
expressions.add(expr);
    }
return expressions;
}

  final public Expression Resource() throws ParseException {Expression expr;
    if (jj_2_71(2147483647)) {
      /*this is a bit more lenient than we need to be, eg allowing access modifiers like private*/
              expr = VariableDeclarationExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case 150:{
        expr = PrimaryExpression();
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return expr;
}

/* We use productions to match >>>, >> and > so that we can keep the
 * type declaration syntax with generics clean
 */
  final public 
void RUNSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    getToken(1).realKind == RUNSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
    jj_consume_token(GT);
}

  final public void RSIGNEDSHIFT() throws ParseException {
    if (getToken(1).kind == GT &&
                    getToken(1).realKind == RSIGNEDSHIFT) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(GT);
    jj_consume_token(GT);
}

/* Annotation syntax follows. */
  final public 
NodeList<AnnotationExpr> Annotations() throws ParseException {NodeList<AnnotationExpr> annotations = new NodeList<AnnotationExpr>();
        AnnotationExpr annotation;
    label_50:
    while (true) {
      if (jj_2_72(2147483647)) {
        ;
      } else {
        break label_50;
      }
      annotation = Annotation();
annotations = add(annotations, annotation);
    }
return annotations;
}

  final public AnnotationExpr Annotation() throws ParseException {AnnotationExpr ret;
        Name name;
        NodeList<MemberValuePair> pairs = emptyList();
        JavaToken begin;
        Expression memberVal;
    jj_consume_token(AT);
begin=token();
    name = Name();
    if (jj_2_73(2147483647)) {
      jj_consume_token(LPAREN);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        pairs = MemberValuePairs();
        break;
        }
      default:
        jj_la1[143] = jj_gen;
        ;
      }
      jj_consume_token(RPAREN);
ret = new NormalAnnotationExpr(range(begin, token()), name, pairs);
    } else if (jj_2_74(2147483647)) {
      jj_consume_token(LPAREN);
      memberVal = MemberValue();
      jj_consume_token(RPAREN);
ret = new SingleMemberAnnotationExpr(range(begin, token()), name, memberVal);
    } else {
ret = new MarkerAnnotationExpr(range(begin, token()), name);
    }
return ret;
}

  final public NodeList<MemberValuePair> MemberValuePairs() throws ParseException {NodeList<MemberValuePair> ret = new NodeList<MemberValuePair>();
        MemberValuePair pair;
    pair = MemberValuePair();
ret.add(pair);
    label_51:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_51;
      }
      jj_consume_token(COMMA);
      pair = MemberValuePair();
ret.add(pair);
    }
return ret;
}

  final public MemberValuePair MemberValuePair() throws ParseException {SimpleName name;
        Expression value;
        JavaToken begin;
    name = SimpleName();
begin=token();
    jj_consume_token(ASSIGN);
    value = MemberValue();
return new MemberValuePair(range(begin, token()),name, value);
}

  final public Expression MemberValue() throws ParseException {Expression ret;
    if (jj_2_75(2147483647)) {
      ret = Annotation();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACE:{
        ret = MemberValueArrayInitializer();
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        if (jj_2_76(1)) {
          ret = ConditionalExpression();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
return ret;
}

  final public Expression MemberValueArrayInitializer() throws ParseException {NodeList<Expression> ret = emptyList();
        Expression member;
        JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    if (jj_2_78(1)) {
      member = MemberValue();
ret.add(member);
      label_52:
      while (true) {
        if (jj_2_77(2)) {
          ;
        } else {
          break label_52;
        }
        jj_consume_token(COMMA);
        member = MemberValue();
ret.add(member);
      }
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
return new ArrayInitializerExpr(range(begin, token()),ret);
}

/* Annotation Types. */
  final public 
AnnotationDeclaration AnnotationTypeDeclaration(ModifierHolder modifier) throws ParseException {SimpleName name;
    NodeList<BodyDeclaration<?>> members = emptyList();
        JavaToken begin = modifier.begin;
    jj_consume_token(AT);
begin=orIfInvalid(begin, token());
    jj_consume_token(INTERFACE);
    name = SimpleName();
    members = AnnotationTypeBody();
return new AnnotationDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, name, members);
}

  final public NodeList<BodyDeclaration<?>> AnnotationTypeBody() throws ParseException {NodeList<BodyDeclaration<?>> ret = emptyList();
        BodyDeclaration member;
    jj_consume_token(LBRACE);
    label_53:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case SEMICOLON:
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        break label_53;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case CLASS:
      case _DEFAULT:
      case DOUBLE:
      case ENUM:
      case FINAL:
      case FLOAT:
      case INT:
      case INTERFACE:
      case LONG:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case STRICTFP:
      case SYNCHRONIZED:
      case TRANSIENT:
      case VOLATILE:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:
      case AT:{
        member = AnnotationBodyDeclaration();
ret = addWhenNotNull(ret, member);
        break;
        }
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        break;
        }
      default:
        jj_la1[148] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(RBRACE);
return ret;
}

  final public BodyDeclaration<?> AnnotationBodyDeclaration() throws ParseException {ModifierHolder modifier;
   BodyDeclaration ret;
    modifier = Modifiers();
    if (jj_2_79(2147483647)) {
      ret = AnnotationTypeMemberDeclaration(modifier);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CLASS:
      case INTERFACE:{
        ret = ClassOrInterfaceDeclaration(modifier);
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        if (jj_2_80(2147483647)) {
          ret = EnumDeclaration(modifier);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case AT:{
            ret = AnnotationTypeDeclaration(modifier);
            break;
            }
          case BOOLEAN:
          case BYTE:
          case CHAR:
          case DOUBLE:
          case ENUM:
          case FLOAT:
          case INT:
          case LONG:
          case SHORT:
          case STRICTFP:
          case REQUIRES:
          case TO:
          case WITH:
          case OPEN:
          case OPENS:
          case USES:
          case MODULE:
          case EXPORTS:
          case PROVIDES:
          case TRANSITIVE:
          case RULE:
          case IDENTIFIER:{
            ret = FieldDeclaration(modifier);
            break;
            }
          default:
            jj_la1[150] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
return ret;
}

  final public AnnotationMemberDeclaration AnnotationTypeMemberDeclaration(ModifierHolder modifier) throws ParseException {Type type;
        SimpleName name;
        Expression defaultVal = null;
    type = Type(emptyList());
    name = SimpleName();
    jj_consume_token(LPAREN);
    jj_consume_token(RPAREN);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case _DEFAULT:{
      defaultVal = DefaultValue();
      break;
      }
    default:
      jj_la1[151] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
JavaToken begin = orIfInvalid(modifier.begin, type);
    return new AnnotationMemberDeclaration(range(begin, token()), modifier.modifiers, modifier.annotations, type, name, defaultVal);
}

  final public Expression DefaultValue() throws ParseException {Expression ret;
    jj_consume_token(_DEFAULT);
    ret = MemberValue();
return ret;
}

/* Module syntax follows */
  final public 

ModuleStmt ModuleStmt() throws ParseException {ModifierHolder modifiers;
    Name name;
    Name tmpName;
    NodeList<Name> names=emptyList();
    Type type;
    Type tmpType;
    NodeList<Type> types=emptyList();
    JavaToken begin;
    ModuleStmt stmt=new ModuleRequiresStmt();
    JavaToken transitiveExceptionalToken;
    if (jj_2_81(2147483647)) {
      jj_consume_token(REQUIRES);
begin=token();
      jj_consume_token(TRANSITIVE);
transitiveExceptionalToken=token(); setTokenKind(IDENTIFIER);
      jj_consume_token(SEMICOLON);
stmt=new ModuleRequiresStmt(range(begin, token()), EnumSet.noneOf(Modifier.class), new Name(range(transitiveExceptionalToken, transitiveExceptionalToken), null, transitiveExceptionalToken.getText(), new NodeList<AnnotationExpr>()));
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case REQUIRES:{
        jj_consume_token(REQUIRES);
begin=token();
        modifiers = Modifiers();
        name = Name();
        jj_consume_token(SEMICOLON);
stmt=new ModuleRequiresStmt(range(begin, token()), modifiers.modifiers, name);
        break;
        }
      case EXPORTS:{
        jj_consume_token(EXPORTS);
begin=token();
        name = Name();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TO:{
          jj_consume_token(TO);
          tmpName = Name();
names.add(tmpName);
          label_54:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[152] = jj_gen;
              break label_54;
            }
            jj_consume_token(COMMA);
            tmpName = Name();
names.add(tmpName);
          }
          break;
          }
        default:
          jj_la1[153] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
stmt=new ModuleExportsStmt(range(begin, token()), name, names);
        break;
        }
      case OPENS:{
        jj_consume_token(OPENS);
begin=token();
        name = Name();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TO:{
          jj_consume_token(TO);
          tmpName = Name();
names.add(tmpName);
          label_55:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              ;
              break;
              }
            default:
              jj_la1[154] = jj_gen;
              break label_55;
            }
            jj_consume_token(COMMA);
            tmpName = Name();
names.add(tmpName);
          }
          break;
          }
        default:
          jj_la1[155] = jj_gen;
          ;
        }
        jj_consume_token(SEMICOLON);
stmt=new ModuleOpensStmt(range(begin, token()), name, names);
        break;
        }
      case USES:{
        jj_consume_token(USES);
begin=token();
        type = Type(emptyList());
        jj_consume_token(SEMICOLON);
stmt=new ModuleUsesStmt(range(begin, token()), type);
        break;
        }
      case PROVIDES:{
        jj_consume_token(PROVIDES);
begin=token();
        type = Type(emptyList());
        jj_consume_token(WITH);
        tmpType = Type(emptyList());
types.add(tmpType);
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[156] = jj_gen;
            break label_56;
          }
          jj_consume_token(COMMA);
          tmpType = Type(emptyList());
types.add(tmpType);
        }
        jj_consume_token(SEMICOLON);
stmt=new ModuleProvidesStmt(range(begin, token()), type, types);
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return stmt;
}

  final public ModuleDeclaration ModuleDeclaration(ModifierHolder modifier) throws ParseException {NodeList<ModuleStmt> statements = new NodeList<ModuleStmt>();
    boolean open=false;
    ModuleStmt st;
    Name name;
    JavaToken begin = modifier.begin;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPEN:{
      jj_consume_token(OPEN);
open=true; begin = orIfInvalid(begin, token());
      break;
      }
    default:
      jj_la1[158] = jj_gen;
      ;
    }
    jj_consume_token(MODULE);
begin = orIfInvalid(begin, token());
    name = Name();
    jj_consume_token(LBRACE);
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case REQUIRES:
      case OPENS:
      case USES:
      case EXPORTS:
      case PROVIDES:{
        ;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        break label_57;
      }
      st = ModuleStmt();
statements = add(statements, st);
    }
    jj_consume_token(RBRACE);
return new ModuleDeclaration(range(begin, token()), modifier.annotations, name, open, statements);
}

/* Rules for matching partial inputs.
These rules are needed to properly terminate them -
if we simply use the usual rules, they will ignore everything in the provider
after they matched their desired input, which will lead to unexpected behaviour
*/
  final public 

BlockStmt BlockParseStart() throws ParseException {BlockStmt ret;
    ret = Block();
    jj_consume_token(0);
return ret;
}

  final public Statement BlockStatementParseStart() throws ParseException {Statement ret;
    if (jj_2_82(3)) {
      ret = BlockStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BOOLEAN:
      case BYTE:
      case CHAR:
      case DOUBLE:
      case ENUM:
      case FALSE:
      case FLOAT:
      case INT:
      case LONG:
      case NEW:
      case NULL:
      case SHORT:
      case STRICTFP:
      case SUPER:
      case THIS:
      case TRUE:
      case VOID:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case LONG_LITERAL:
      case INTEGER_LITERAL:
      case BIG_INTEGER_LITERAL:
      case BIG_DECIMAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case IDENTIFIER:
      case LPAREN:
      case AT:
      case LT:
      case 150:{
        ret = ExplicitConstructorInvocation();
        break;
        }
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
return ret;
}

  final public ImportDeclaration ImportDeclarationParseStart() throws ParseException {ImportDeclaration ret;
    ret = ImportDeclaration();
    jj_consume_token(0);
return ret;
}

  final public Expression ExpressionParseStart() throws ParseException {Expression ret;
    ret = Expression();
    jj_consume_token(0);
return ret;
}

  final public AnnotationExpr AnnotationParseStart() throws ParseException {AnnotationExpr ret;
    ret = Annotation();
    jj_consume_token(0);
return ret;
}

  final public BodyDeclaration<?> AnnotationBodyDeclarationParseStart() throws ParseException {BodyDeclaration<?> ret;
    ret = AnnotationBodyDeclaration();
    jj_consume_token(0);
return ret;
}

  final public BodyDeclaration<?> ClassOrInterfaceBodyDeclarationParseStart() throws ParseException {BodyDeclaration<?> ret;
    ret = ClassOrInterfaceBodyDeclaration();
    jj_consume_token(0);
return ret;
}

  final public ClassOrInterfaceType ClassOrInterfaceTypeParseStart() throws ParseException {ClassOrInterfaceType ret;
    ret = AnnotatedClassOrInterfaceType();
    jj_consume_token(0);
return ret;
}

  final public Type ResultTypeParseStart() throws ParseException {NodeList<AnnotationExpr> annotations; Type ret;
    annotations = Annotations();
    ret = ResultType(annotations);
    jj_consume_token(0);
return ret;
}

  final public VariableDeclarationExpr VariableDeclarationExpressionParseStart() throws ParseException {VariableDeclarationExpr ret;
    ret = VariableDeclarationExpression();
    jj_consume_token(0);
return ret;
}

  final public ExplicitConstructorInvocationStmt ExplicitConstructorInvocationParseStart() throws ParseException {ExplicitConstructorInvocationStmt ret;
    ret = ExplicitConstructorInvocation();
    jj_consume_token(0);
return ret;
}

  final public Name NameParseStart() throws ParseException {Name ret;
    ret = Name();
    jj_consume_token(0);
return ret;
}

  final public SimpleName SimpleNameParseStart() throws ParseException {SimpleName ret;
    ret = SimpleName();
    jj_consume_token(0);
return ret;
}

  final public Parameter ParameterParseStart() throws ParseException {Parameter ret;
    ret = Parameter();
    jj_consume_token(0);
return ret;
}

  final public PackageDeclaration PackageDeclarationParseStart() throws ParseException {PackageDeclaration ret;
    ret = PackageDeclaration();
    jj_consume_token(0);
return ret;
}

  final public NodeList<Expression> Expressions() throws ParseException {NodeList<Expression> ret = emptyList();
        Expression expr;
    jj_consume_token(LPAREN);
    if (jj_2_83(1)) {
      expr = Expression();
ret = add(ret, expr);
      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[161] = jj_gen;
          break label_58;
        }
        jj_consume_token(COMMA);
        expr = Expression();
ret = add(ret, expr);
      }
    } else {
      ;
    }
    jj_consume_token(RPAREN);
return ret;
}

  final public RuleDeclaration RuleDeclaration(ModifierHolder modifier) throws ParseException {SimpleName name;
    JavaToken begin = modifier.begin;
    RuleBody body;
    jj_consume_token(RULE);
    name = SimpleName();
    body = RuleBody();
return new RuleDeclaration(range(begin, token()), modifier.annotations, name, body);
}

  final public RuleBody RuleBody() throws ParseException {NodeList<RuleItem> items = emptyList();
    JavaToken begin;
    jj_consume_token(LBRACE);
begin=token();
    items = RuleItems();
    jj_consume_token(RBRACE);
return new RuleBody(range(begin, token()), items);
}

  final public NodeList<RuleItem> RuleItems() throws ParseException {NodeList<RuleItem> items = emptyList();
    RuleItem item;
    RuleConsequence consequnce;
    label_59:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DO:
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        ;
        break;
        }
      default:
        jj_la1[162] = jj_gen;
        break label_59;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ENUM:
      case STRICTFP:
      case REQUIRES:
      case TO:
      case WITH:
      case OPEN:
      case OPENS:
      case USES:
      case MODULE:
      case EXPORTS:
      case PROVIDES:
      case TRANSITIVE:
      case RULE:
      case IDENTIFIER:{
        item = RulePattern();
items.add(item);
        break;
        }
      case DO:{
        item = RuleConsequence();
items.add(item);
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return items;
}

  final public RulePattern RulePattern() throws ParseException {JavaToken begin;
    SimpleName type;
    SimpleName bind;
    OOPathExpr expr;
    type = SimpleName();
begin=token();
    bind = SimpleName();
    jj_consume_token(ASSIGN);
    expr = OOPathExpr();
    jj_consume_token(SEMICOLON);
return new RulePattern(range(begin, token()), type, bind, expr);
}

  final public RuleConsequence RuleConsequence() throws ParseException {JavaToken begin;
    BlockStmt block;
    jj_consume_token(DO);
begin=token();
    block = Block();
return new RuleConsequence(range(begin, token()), block);
}

  final public OOPathExpr OOPathExpr() throws ParseException {JavaToken begin;
    NodeList<OOPathChunk> chunks = emptyList();
    OOPathChunk chunk;
    jj_consume_token(SLASH);
begin=token();
    chunk = OOPathChunk();
chunks.add(chunk);
    label_60:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SLASH:{
        ;
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        break label_60;
      }
      jj_consume_token(SLASH);
      chunk = OOPathChunk();
chunks.add(chunk);
    }
return new OOPathExpr(range(begin, token()), chunks);
}

  final public OOPathChunk OOPathChunk() throws ParseException {JavaToken begin;
    SimpleName field;
    SimpleName inlineCast = null;
    Expression tempExpr;
    List<Expression> conditions = new ArrayList<Expression>();
    field = SimpleName();
begin=token();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 151:{
      jj_consume_token(151);
      inlineCast = SimpleName();
      break;
      }
    default:
      jj_la1[165] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:{
      jj_consume_token(LBRACKET);
      tempExpr = Expression();
conditions = add(conditions, tempExpr);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[166] = jj_gen;
          break label_61;
        }
        jj_consume_token(COMMA);
        tempExpr = Expression();
conditions = add(conditions, tempExpr);
      }
      jj_consume_token(RBRACKET);
      break;
      }
    default:
      jj_la1[167] = jj_gen;
      ;
    }
return new OOPathChunk(range(begin, token()), field, inlineCast, conditions);
}

  final public DrlxExpression DrlxExpression() throws ParseException {SimpleName decl = null;
        Expression expr;
    if (jj_2_84(2)) {
      decl = SimpleName();
      jj_consume_token(COLON);
    } else {
      ;
    }
    if (jj_2_85(2147483647)) {
      expr = OOPathExpr();
    } else if (jj_2_86(1)) {
      expr = Expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return new DrlxExpression(decl, expr);
}

  final public Expression PointFreeExpr() throws ParseException {JavaToken begin;
    Expression left;
    NodeList<Expression> right = emptyList();
    SimpleName operator;
    boolean negated = false;
    TemporalLiteralArguments temporalLiteralArguments;
    Expression tempExpr;
    left = PrimaryExpression();
begin=token();
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        ;
        break;
        }
      default:
        jj_la1[168] = jj_gen;
        break label_62;
      }
      jj_consume_token(NOT);
negated = true;
    }
    operator = SimpleName();
    temporalLiteralArguments = TemporalLiteralArguments();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      right = Expressions();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case STRICTFP:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case AT:
    case 150:{
      tempExpr = PrimaryExpression();
right = add(right, tempExpr);
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(temporalLiteralArguments != null) {
                        return new PointFreeExpr(range(begin, token()), left, right, operator, negated, temporalLiteralArguments.getArg1(), temporalLiteralArguments.getArg2(), temporalLiteralArguments.getArg3(), temporalLiteralArguments.getArg4() );
                    } else {
                        return new PointFreeExpr(range(begin, token()), left, right, operator, negated, null, null, null, null);
                    }
}

  final public Expression PointFreeExprMvel() throws ParseException {JavaToken begin;
    Expression left;
    NodeList<Expression> right = emptyList();
    boolean negated = false;
    Expression tempExpr;
    Token mvelOperator = null;
    left = PrimaryExpression();
begin=token();
    label_63:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        ;
        break;
        }
      default:
        jj_la1[170] = jj_gen;
        break label_63;
      }
      jj_consume_token(NOT);
negated = true;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MVEL_STARTS_WITH:{
      mvelOperator = jj_consume_token(MVEL_STARTS_WITH);
      break;
      }
    case MVEL_ENDS_WITH:{
      mvelOperator = jj_consume_token(MVEL_ENDS_WITH);
      break;
      }
    case MVEL_LENGTH:{
      mvelOperator = jj_consume_token(MVEL_LENGTH);
      break;
      }
    default:
      jj_la1[171] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    tempExpr = PrimaryExpression();
right = add(right, tempExpr);
return new PointFreeExpr(range(begin, token()), left, right, new SimpleName(mvelOperator.toString()), negated, null, null, null, null);
}

  final public Expression HalfPointFreeExpr() throws ParseException {JavaToken begin = token();
    NodeList<Expression> right = emptyList();
    SimpleName operator;
    boolean negated = false;
    TemporalLiteralArguments temporalLiteralArguments;
    Expression tempExpr;
    label_64:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        ;
        break;
        }
      default:
        jj_la1[172] = jj_gen;
        break label_64;
      }
      jj_consume_token(NOT);
negated = true;
    }
    operator = SimpleName();
begin = token();
    temporalLiteralArguments = TemporalLiteralArguments();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      right = Expressions();
      break;
      }
    case BOOLEAN:
    case BYTE:
    case CHAR:
    case DOUBLE:
    case ENUM:
    case FALSE:
    case FLOAT:
    case INT:
    case LONG:
    case NEW:
    case NULL:
    case SHORT:
    case STRICTFP:
    case SUPER:
    case THIS:
    case TRUE:
    case VOID:
    case REQUIRES:
    case TO:
    case WITH:
    case OPEN:
    case OPENS:
    case USES:
    case MODULE:
    case EXPORTS:
    case PROVIDES:
    case TRANSITIVE:
    case RULE:
    case LONG_LITERAL:
    case INTEGER_LITERAL:
    case BIG_INTEGER_LITERAL:
    case BIG_DECIMAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case IDENTIFIER:
    case AT:
    case 150:{
      tempExpr = PrimaryPrefix();
right = add(right, tempExpr);
      break;
      }
    default:
      jj_la1[173] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if(temporalLiteralArguments != null) {
                    return new HalfPointFreeExpr(range(begin, token()), right, operator, negated, temporalLiteralArguments.getArg1(), temporalLiteralArguments.getArg2(), temporalLiteralArguments.getArg3(), temporalLiteralArguments.getArg4() );
                } else {
                    return new HalfPointFreeExpr(range(begin, token()), right, operator, negated, null, null, null, null);
                }
}

  final public Expression HalfPointFreeExprMvel() throws ParseException {JavaToken begin;
    NodeList<Expression> right = emptyList();
    boolean negated = false;
    Expression tempExpr;
    Token mvelOperator = null;
    label_65:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        ;
        break;
        }
      default:
        jj_la1[174] = jj_gen;
        break label_65;
      }
      jj_consume_token(NOT);
negated = true;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MVEL_STARTS_WITH:{
      mvelOperator = jj_consume_token(MVEL_STARTS_WITH);
      break;
      }
    case MVEL_ENDS_WITH:{
      mvelOperator = jj_consume_token(MVEL_ENDS_WITH);
      break;
      }
    case MVEL_LENGTH:{
      mvelOperator = jj_consume_token(MVEL_LENGTH);
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
begin = token();
    tempExpr = PrimaryExpression();
right = add(right, tempExpr);
return new HalfPointFreeExpr(range(begin, token()), right, new SimpleName(mvelOperator.toString()), negated, null, null, null, null);
}

  final public TemporalLiteralArguments TemporalLiteralArguments() throws ParseException {Expression arg1 = null;
    Expression arg2 = null;
    Expression arg3 = null;
    Expression arg4 = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LBRACKET:{
      if (jj_2_87(2147483647)) {
        jj_consume_token(LBRACKET);
        arg1 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg2 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg3 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg4 = TemporalLiteral();
        jj_consume_token(RBRACKET);
      } else if (jj_2_88(2147483647)) {
        jj_consume_token(LBRACKET);
        arg1 = TemporalLiteral();
        jj_consume_token(COMMA);
        arg2 = TemporalLiteral();
        jj_consume_token(RBRACKET);
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:{
          jj_consume_token(LBRACKET);
          arg1 = TemporalLiteral();
          jj_consume_token(RBRACKET);
          break;
          }
        default:
          jj_la1[176] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      ;
    }
return new TemporalLiteralArguments(arg1, arg2, arg3, arg4);
}

  final public TemporalLiteralExpr TemporalLiteral() throws ParseException {NodeList<TemporalChunkExpr> chunks = emptyList();
        TemporalLiteralChunkExpr chunk;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INTEGER_LITERAL:{
      jj_consume_token(INTEGER_LITERAL);
chunks.add(new TemporalLiteralChunkExpr(tokenRange(), token.image));
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
chunks.add(new TemporalLiteralInfiniteChunkExpr(tokenRange(), token.image));
      break;
      }
    case FLOATING_POINT_LITERAL:
    case MILLISECOND_LITERAL:
    case SECOND_LITERAL:
    case MINUTE_LITERAL:
    case HOUR_LITERAL:{
      chunk = TemporalLiteralChunk();
chunks.add(chunk);
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FLOATING_POINT_LITERAL:
        case MILLISECOND_LITERAL:
        case SECOND_LITERAL:
        case MINUTE_LITERAL:
        case HOUR_LITERAL:{
          ;
          break;
          }
        default:
          jj_la1[178] = jj_gen;
          break label_66;
        }
        chunk = TemporalLiteralChunk();
chunks.add(chunk);
      }
      break;
      }
    default:
      jj_la1[179] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return new TemporalLiteralExpr(tokenRange(), chunks);
}

  final public TemporalLiteralChunkExpr TemporalLiteralChunk() throws ParseException {TemporalLiteralChunkExpr ret;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MILLISECOND_LITERAL:{
      jj_consume_token(MILLISECOND_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.MILLISECONDS);
      break;
      }
    case SECOND_LITERAL:{
      jj_consume_token(SECOND_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.SECONDS);
      break;
      }
    case MINUTE_LITERAL:{
      jj_consume_token(MINUTE_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.MINUTES);
      break;
      }
    case HOUR_LITERAL:{
      jj_consume_token(HOUR_LITERAL);
ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.HOURS);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      jj_consume_token(FLOATING_POINT_LITERAL);
if (token.image.endsWith("f") || token.image.endsWith("F") || token.image.endsWith("D")) {
                    addProblem("unexpected float");
                    ret = null;
                } else {
                            ret = new TemporalLiteralChunkExpr(tokenRange(), token.image, TimeUnit.DAYS);
                    }
      break;
      }
    default:
      jj_la1[180] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ret;
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_26()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_27()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_28()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_29()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_30()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_31()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_32()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_33()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_34()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_35()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_36()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_37()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_38()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_39()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_40()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_41()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_42()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_43()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_44()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_45()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_46()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_47()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_48()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_49()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_50()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_51()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_52()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_53()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_54()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_55()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_56()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_57()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_58()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_59()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_60()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_61()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_62()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_63()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_64()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_65()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_66()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_67()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_68()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_69()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_70()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_71()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_72()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_73()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_74()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_75()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_76()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_77()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_78()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_79()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_80()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_81()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_82()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_83()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_84()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_85()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_2_86(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_86()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  private boolean jj_2_87(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_87()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  private boolean jj_2_88(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_88()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  private boolean jj_3R_81()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_3R_126()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_170()
 {
    if (jj_scan_token(ORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_169()
 {
    if (jj_scan_token(XORASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(TRANSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_168()
 {
    if (jj_scan_token(ANDASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_3R_125()) return true;
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_167()
 {
    if (jj_scan_token(RUNSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(STRICTFP)) return true;
    return false;
  }

  private boolean jj_3R_166()
 {
    if (jj_scan_token(RSIGNEDSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    if (jj_scan_token(LSHIFTASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_218()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(VOLATILE)) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_scan_token(MINUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_409()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_scan_token(PLUSASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(TRANSIENT)) return true;
    return false;
  }

  private boolean jj_3R_162()
 {
    if (jj_scan_token(REMASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_scan_token(SLASHASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_scan_token(SLASH)) return true;
    if (jj_3R_217()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(NATIVE)) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_scan_token(STARASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_399()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(ABSTRACT)) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(FINAL)) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) {
    jj_scanpos = xsp;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) {
    jj_scanpos = xsp;
    if (jj_3R_166()) {
    jj_scanpos = xsp;
    if (jj_3R_167()) {
    jj_scanpos = xsp;
    if (jj_3R_168()) {
    jj_scanpos = xsp;
    if (jj_3R_169()) {
    jj_scanpos = xsp;
    if (jj_3R_170()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_375()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_scan_token(PRIVATE)) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(PROTECTED)) return true;
    return false;
  }

  private boolean jj_3R_507()
 {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(PUBLIC)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_125()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_3()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_374()
 {
    if (jj_scan_token(ARROW)) return true;
    if (jj_3R_398()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_224()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_506()
 {
    if (jj_3R_99()) return true;
    if (jj_3R_99()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_136()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_100()) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_372()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_318()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) {
    jj_scanpos = xsp;
    if (jj_3R_375()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_3R_134()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_3R_99()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_497()
 {
    if (jj_3R_507()) return true;
    return false;
  }

  private boolean jj_3R_496()
 {
    if (jj_3R_506()) return true;
    return false;
  }

  private boolean jj_3R_488()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_496()) {
    jj_scanpos = xsp;
    if (jj_3R_497()) return true;
    }
    return false;
  }

  private boolean jj_3R_470()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_488()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_353()
 {
    if (jj_scan_token(ASSERT)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_409()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_303()
 {
    if (jj_3R_366()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(PACKAGE)) return true;
    if (jj_3R_91()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_302()
 {
    if (jj_3R_365()) return true;
    return false;
  }

  private boolean jj_3R_301()
 {
    if (jj_3R_364()) return true;
    return false;
  }

  private boolean jj_3R_461()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_470()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_300()
 {
    if (jj_3R_363()) return true;
    return false;
  }

  private boolean jj_3R_299()
 {
    if (jj_3R_362()) return true;
    return false;
  }

  private boolean jj_3R_298()
 {
    if (jj_3R_361()) return true;
    return false;
  }

  private boolean jj_3R_297()
 {
    if (jj_3R_360()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_296()
 {
    if (jj_3R_359()) return true;
    return false;
  }

  private boolean jj_3R_295()
 {
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3R_294()
 {
    if (jj_3R_357()) return true;
    return false;
  }

  private boolean jj_3R_425()
 {
    if (jj_scan_token(RULE)) return true;
    if (jj_3R_99()) return true;
    if (jj_3R_461()) return true;
    return false;
  }

  private boolean jj_3R_293()
 {
    if (jj_3R_356()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_292()
 {
    if (jj_3R_355()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_291()
 {
    if (jj_3R_354()) return true;
    return false;
  }

  private boolean jj_3_83()
 {
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_372()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_290()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_289()
 {
    if (jj_3R_353()) return true;
    return false;
  }

  private boolean jj_3R_254()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_147()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3_56()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_3R_97()) return true;
    if (jj_3R_84()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_147()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_240()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) {
    jj_scanpos = xsp;
    if (jj_3R_291()) {
    jj_scanpos = xsp;
    if (jj_3R_292()) {
    jj_scanpos = xsp;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) {
    jj_scanpos = xsp;
    if (jj_3R_297()) {
    jj_scanpos = xsp;
    if (jj_3R_298()) {
    jj_scanpos = xsp;
    if (jj_3R_299()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) {
    jj_scanpos = xsp;
    if (jj_3R_301()) {
    jj_scanpos = xsp;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_206()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_205()
 {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3_53()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_54()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_413()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    return false;
  }

  private boolean jj_3_55()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_387()
 {
    Token xsp;
    if (jj_3_55()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_55()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_413()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_197()
 {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_196()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_382()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_195()
 {
    if (jj_scan_token(LONG)) return true;
    return false;
  }

  private boolean jj_3R_194()
 {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_390()
 {
    if (jj_3R_228()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_53()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_193()
 {
    if (jj_scan_token(SHORT)) return true;
    return false;
  }

  private boolean jj_3R_389()
 {
    if (jj_3R_387()) return true;
    return false;
  }

  private boolean jj_3R_192()
 {
    if (jj_scan_token(BYTE)) return true;
    return false;
  }

  private boolean jj_3R_191()
 {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_429()
 {
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_287()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_244()) return true;
    return false;
  }

  private boolean jj_3R_388()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_190()
 {
    if (jj_scan_token(BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_428()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_414()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_428()) {
    jj_scanpos = xsp;
    if (jj_3R_429()) return true;
    }
    return false;
  }

  private boolean jj_3R_352()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    if (jj_3R_380()) return true;
    xsp = jj_scanpos;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    return false;
  }

  private boolean jj_3R_113()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_190()) {
    jj_scanpos = xsp;
    if (jj_3R_191()) {
    jj_scanpos = xsp;
    if (jj_3R_192()) {
    jj_scanpos = xsp;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) {
    jj_scanpos = xsp;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_351()
 {
    if (jj_3R_113()) return true;
    if (jj_3R_387()) return true;
    return false;
  }

  private boolean jj_3R_282()
 {
    if (jj_scan_token(NEW)) return true;
    if (jj_3R_97()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) return true;
    }
    return false;
  }

  private boolean jj_3R_368()
 {
    if (jj_scan_token(HOOK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_414()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_82()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_308()
 {
    if (jj_3R_368()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_382()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_307()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3_52()
 {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_244()
 {
    if (jj_3R_97()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) return true;
    }
    return false;
  }

  private boolean jj_3R_228()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_3R_244()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_287()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(LT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_158()) jj_scanpos = xsp;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_412()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_384()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_411()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_510()
 {
    if (jj_3R_511()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_81()
 {
    if (jj_scan_token(REQUIRES)) return true;
    if (jj_scan_token(TRANSITIVE)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_99()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_24()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_383()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_411()) {
    jj_scanpos = xsp;
    if (jj_3R_412()) return true;
    }
    return false;
  }

  private boolean jj_3R_458()
 {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_315()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_469()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_344()
 {
    if (jj_3R_384()) return true;
    return false;
  }

  private boolean jj_3R_343()
 {
    if (jj_3R_383()) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_342()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_242()
 {
    if (jj_3R_99()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_23()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_341()
 {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_243()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_340()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_339()
 {
    if (jj_scan_token(BIG_INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_380()
 {
    if (jj_3R_97()) return true;
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_338()
 {
    if (jj_scan_token(BIG_DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_241()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_337()
 {
    if (jj_scan_token(LONG_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_336()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_511()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_275()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_80()
 {
    if (jj_scan_token(ENUM)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_508()
 {
    if (jj_3R_85()) return true;
    if (jj_3R_99()) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_scan_token(RPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_510()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_79()
 {
    if (jj_3R_85()) return true;
    if (jj_3R_84()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_505()
 {
    if (jj_3R_424()) return true;
    return false;
  }

  private boolean jj_3R_320()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_504()
 {
    if (jj_3R_422()) return true;
    return false;
  }

  private boolean jj_3R_319()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_503()
 {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3R_502()
 {
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_263()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_319()) jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_320()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_156()
 {
    if (jj_3R_242()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_243()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_262()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_501()
 {
    if (jj_3R_508()) return true;
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_3R_113()) return true;
    Token xsp;
    if (jj_3R_241()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_241()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_202()
 {
    if (jj_scan_token(152)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_261()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) {
    jj_scanpos = xsp;
    if (jj_3R_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_260()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_85()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_77()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_259()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_50()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_201()
 {
    if (jj_scan_token(151)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) return true;
    }
    return false;
  }

  private boolean jj_3R_495()
 {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_501()) {
    jj_scanpos = xsp;
    if (jj_3R_502()) {
    jj_scanpos = xsp;
    if (jj_3R_503()) {
    jj_scanpos = xsp;
    if (jj_3R_504()) {
    jj_scanpos = xsp;
    if (jj_3R_505()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_141()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_200()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_317()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_316()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) return true;
    }
    return false;
  }

  private boolean jj_3R_484()
 {
    if (jj_3R_495()) return true;
    return false;
  }

  private boolean jj_3R_467()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_484()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    return false;
  }

  private boolean jj_3R_258()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_257()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3R_456()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_467()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_284()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_256()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(STATIC)) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_199()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) {
    jj_scanpos = xsp;
    if (jj_3R_258()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_224()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_18()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_422()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    if (jj_3R_99()) return true;
    if (jj_3R_456()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_418()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_417()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_230()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_94()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3_78()
 {
    if (jj_3R_135()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_77()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_229()
 {
    if (jj_3R_93()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_198()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(SUPER)) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) jj_scanpos = xsp;
    if (jj_scan_token(SUPER)) return true;
    if (jj_3R_228()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_283()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3_49()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_269()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(106)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_227()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_227()) jj_scanpos = xsp;
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_228()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_76()
 {
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3_75()
 {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3R_216()
 {
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) return true;
    }
    return false;
  }

  private boolean jj_3R_286()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_285()
 {
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_348()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) return true;
    }
    return false;
  }

  private boolean jj_3R_215()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_135()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_215()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3_76()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_48()
 {
    if (jj_3R_119()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_238()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_285()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_286()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_47()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3R_417()
 {
    if (jj_3R_99()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_135()) return true;
    return false;
  }

  private boolean jj_3R_203()
 {
    if (jj_3R_97()) return true;
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_459()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_237()
 {
    if (jj_3R_119()) return true;
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_283()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_284()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3_45()
 {
    if (jj_3R_117()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_236()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(CLASS)) return true;
    return false;
  }

  private boolean jj_3_44()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_3R_84()) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_469()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_235()
 {
    if (jj_3R_282()) return true;
    return false;
  }

  private boolean jj_3_43()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3_46()
 {
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_74()
 {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_434()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_396()
 {
    if (jj_3R_417()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_418()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_423()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_434()) jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    if (jj_3R_457()) return true;
    xsp = jj_scanpos;
    if (jj_3R_458()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_459()) jj_scanpos = xsp;
    if (jj_3R_224()) return true;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_73()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) return true;
    }
    return false;
  }

  private boolean jj_3R_281()
 {
    if (jj_3R_350()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_347()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_306()
 {
    return false;
  }

  private boolean jj_3R_367()
 {
    if (jj_3R_396()) return true;
    return false;
  }

  private boolean jj_3R_280()
 {
    if (jj_3R_349()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_278()
 {
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_279()
 {
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_305()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_135()) return true;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_277()
 {
    if (jj_scan_token(DOUBLECOLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_347()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) return true;
    }
    return false;
  }

  private boolean jj_3R_304()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_367()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_234()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_278()) {
    jj_scanpos = xsp;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3_46()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_226()
 {
    if (jj_3R_91()) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_3R_91()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) {
    jj_scanpos = xsp;
    if (jj_3R_305()) {
    jj_scanpos = xsp;
    if (jj_3R_306()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_72()
 {
    if (jj_scan_token(AT)) return true;
    return false;
  }

  private boolean jj_3R_346()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_385()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_345()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_276()
 {
    if (jj_scan_token(DOT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_345()) jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_346()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_42()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_3R_97()) return true;
    if (jj_3R_85()) return true;
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_233()
 {
    if (jj_scan_token(SUPER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    return false;
  }

  private boolean jj_3R_157()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_232()
 {
    if (jj_scan_token(THIS)) return true;
    return false;
  }

  private boolean jj_3R_97()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_157()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_231()
 {
    if (jj_3R_275()) return true;
    return false;
  }

  private boolean jj_3R_171()
 {
    return false;
  }

  private boolean jj_3_70()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_131()) return true;
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_116()
 {
    if (jj_3R_125()) return true;
    if (jj_3R_85()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_172()
 {
    return false;
  }

  private boolean jj_3R_102()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                getToken(1).realKind == RSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_171()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_41()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_386()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).kind == GT &&
                getToken(1).realKind == RUNSIGNEDSHIFT;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_172()) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3_71()
 {
    if (jj_3R_125()) return true;
    if (jj_3R_85()) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_350()
 {
    if (jj_3R_117()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_386()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_3R_150()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_151()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_212()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_211()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_349()
 {
    if (jj_3R_116()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_385()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_131()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_211()) {
    jj_scanpos = xsp;
    if (jj_3R_212()) return true;
    }
    return false;
  }

  private boolean jj_3R_179()
 {
    if (jj_3R_150()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_41()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_487()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_486()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_462()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_437()
 {
    if (jj_3R_131()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_70()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_485()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_468()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_485()) {
    jj_scanpos = xsp;
    if (jj_3R_486()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_487()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_255()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_189()
 {
    if (jj_3R_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_255()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3R_457()
 {
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_468()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3_40()
 {
    if (jj_3R_113()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_494()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_480()
 {
    if (jj_scan_token(FINALLY)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_69()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_416()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_437()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) jj_scanpos = xsp;
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_500()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_97()) return true;
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_97()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    }
    return false;
  }

  private boolean jj_3R_493()
 {
    if (jj_scan_token(CATCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_125()) return true;
    if (jj_3R_96()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_500()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_117()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_315()
 {
    if (jj_3R_97()) return true;
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3_39()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) return true;
    }
    return false;
  }

  private boolean jj_3R_111()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3_38()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_371()
 {
    if (jj_3R_179()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_39()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_479()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_493()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_494()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_471()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_464()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_463()
 {
    if (jj_scan_token(THROWS)) return true;
    if (jj_3R_315()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_471()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_310()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_370()
 {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  private boolean jj_3R_311()
 {
    if (jj_3R_371()) return true;
    return false;
  }

  private boolean jj_3R_435()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_369()
 {
    if (jj_scan_token(TILDE)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_89()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_11()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_426()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) jj_scanpos = xsp;
    if (jj_3R_97()) return true;
    if (jj_3R_118()) return true;
    if (jj_3R_99()) return true;
    if (jj_3R_457()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_462()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_463()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_464()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    return false;
  }

  private boolean jj_3R_395()
 {
    if (jj_3R_416()) return true;
    return false;
  }

  private boolean jj_3R_309()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3R_370()) return true;
    }
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_366()
 {
    if (jj_scan_token(TRY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_395()) jj_scanpos = xsp;
    if (jj_3R_144()) return true;
    xsp = jj_scanpos;
    if (jj_3R_479()) {
    jj_scanpos = xsp;
    if (jj_3R_480()) return true;
    }
    return false;
  }

  private boolean jj_3R_204()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_252()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) {
    jj_scanpos = xsp;
    if (jj_3R_310()) {
    jj_scanpos = xsp;
    if (jj_3R_311()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_37()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3_68()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_36()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_225()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(106)) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_365()
 {
    if (jj_scan_token(SYNCHRONIZED)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_35()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_394()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_178()
 {
    if (jj_3R_252()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3_34()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_3R_225()) return true;
    return false;
  }

  private boolean jj_3R_177()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_213()
 {
    if (jj_scan_token(ASSIGN)) return true;
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_176()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_175()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_364()
 {
    if (jj_scan_token(THROW)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3_10()) return true;
    }
    return false;
  }

  private boolean jj_3R_174()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_393()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    Token xsp;
    xsp = jj_scanpos;
    jj_lookingAhead = true;
    jj_semLA = drlParsing;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_174()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = drlParsing;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_175()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = drlParsing;
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_176()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = drlParsing && (isPointFreeOperator(getToken(1).image) || isPointFreeOperator(getToken(2).image) );
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_33()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_509()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_363()
 {
    if (jj_scan_token(RETURN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_334()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_32()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_333()
 {
    if (jj_scan_token(HOUR_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_99()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_204()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_251()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_250()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_332()
 {
    if (jj_scan_token(MINUTE_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_249()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_248()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_362()
 {
    if (jj_scan_token(CONTINUE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_394()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_247()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_246()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_331()
 {
    if (jj_scan_token(SECOND_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_245()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_173()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    }
    return false;
  }

  private boolean jj_3R_330()
 {
    if (jj_scan_token(MILLISECOND_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_3R_117()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_213()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_63()
 {
    if (jj_3R_129()) return true;
    return false;
  }

  private boolean jj_3R_361()
 {
    if (jj_scan_token(BREAK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_393()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_173()) {
    jj_scanpos = xsp;
    if (jj_3_33()) return true;
    }
    return false;
  }

  private boolean jj_3R_272()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_85()) return true;
    if (jj_3R_84()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_86()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_221()
 {
    if (jj_3R_272()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_273()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_460()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_273()
 {
    if (jj_3R_272()) return true;
    return false;
  }

  private boolean jj_3R_424()
 {
    if (jj_3R_85()) return true;
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_460()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(AT)) return true;
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_220()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_407()
 {
    if (jj_3R_426()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(ENUM)) return true;
    return false;
  }

  private boolean jj_3R_478()
 {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_406()
 {
    if (jj_3R_425()) return true;
    return false;
  }

  private boolean jj_3_66()
 {
    if (jj_3R_125()) return true;
    if (jj_3R_85()) return true;
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_219()
 {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_322()
 {
    if (jj_scan_token(DECR)) return true;
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_405()
 {
    if (jj_3R_424()) return true;
    return false;
  }

  private boolean jj_3R_404()
 {
    if (jj_3R_423()) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_509()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_403()
 {
    if (jj_3R_422()) return true;
    return false;
  }

  private boolean jj_3_67()
 {
    if (jj_3R_130()) return true;
    return false;
  }

  private boolean jj_3R_402()
 {
    if (jj_3R_421()) return true;
    return false;
  }

  private boolean jj_3_62()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_401()
 {
    if (jj_3R_239()) return true;
    return false;
  }

  private boolean jj_3R_137()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_210()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_scan_token(INCR)) return true;
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3_88()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_87()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    return false;
  }

  private boolean jj_3R_376()
 {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_324()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_314()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_323()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3_67()) return true;
    }
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_313()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_267()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_323()) {
    jj_scanpos = xsp;
    if (jj_3R_324()) return true;
    }
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_274()
 {
    if (jj_3R_335()) return true;
    return false;
  }

  private boolean jj_3R_266()
 {
    if (jj_3R_322()) return true;
    return false;
  }

  private boolean jj_3R_312()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_137()) return true;
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3R_253()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_312()) {
    jj_scanpos = xsp;
    if (jj_3R_313()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_265()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3_64()
 {
    if (jj_3R_126()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_183()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_181()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_321()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) return true;
    }
    return false;
  }

  private boolean jj_3_61()
 {
    if (jj_3R_128()) return true;
    return false;
  }

  private boolean jj_3R_209()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3_30()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    if (jj_scan_token(SEMICOLON)) return true;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_207()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    return false;
  }

  private boolean jj_3R_264()
 {
    if (jj_3R_321()) return true;
    return false;
  }

  private boolean jj_3R_410()
 {
    if (jj_3R_126()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_491()
 {
    if (jj_scan_token(REM)) return true;
    return false;
  }

  private boolean jj_3R_490()
 {
    if (jj_scan_token(SLASH)) return true;
    return false;
  }

  private boolean jj_3R_489()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_207()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_472()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_489()) {
    jj_scanpos = xsp;
    if (jj_3R_490()) {
    jj_scanpos = xsp;
    if (jj_3R_491()) return true;
    }
    }
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_360()
 {
    if (jj_scan_token(FOR)) return true;
    if (jj_scan_token(LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_410()) {
    jj_scanpos = xsp;
    if (jj_3_65()) return true;
    }
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_381()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_447()
 {
    if (jj_3R_209()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_472()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_335()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_380()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_381()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_107()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_181()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) return true;
    }
    }
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_474()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_473()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_359()
 {
    if (jj_scan_token(DO)) return true;
    if (jj_3R_240()) return true;
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_465()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_473()) {
    jj_scanpos = xsp;
    if (jj_3R_474()) return true;
    }
    if (jj_3R_447()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_186()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_222()
 {
    if (jj_3R_99()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_274()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_188()
 {
    if (jj_3R_150()) return true;
    return false;
  }

  private boolean jj_3R_208()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_443()
 {
    if (jj_3R_447()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_465()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_187()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_358()
 {
    if (jj_scan_token(WHILE)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_482()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_223()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_222()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(LSHIFT)) return true;
    return false;
  }

  private boolean jj_3_27()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) return true;
    }
    }
    if (jj_3R_443()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    if (jj_scan_token(LT)) return true;
    if (jj_3R_97()) return true;
    if (jj_3R_222()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_223()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_444()
 {
    if (jj_scan_token(INSTANCEOF)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3R_357()
 {
    if (jj_scan_token(IF)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_3R_240()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_478()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_441()
 {
    if (jj_3R_443()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_27()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_109()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_186()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_99()) return true;
    if (jj_3R_183()) return true;
    xsp = jj_scanpos;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) return true;
    }
    return false;
  }

  private boolean jj_3R_452()
 {
    if (jj_scan_token(GE)) return true;
    return false;
  }

  private boolean jj_3R_451()
 {
    if (jj_scan_token(LE)) return true;
    return false;
  }

  private boolean jj_3R_450()
 {
    if (jj_scan_token(GT)) return true;
    return false;
  }

  private boolean jj_3R_180()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_449()
 {
    if (jj_scan_token(LT)) return true;
    return false;
  }

  private boolean jj_3R_499()
 {
    if (jj_scan_token(_DEFAULT)) return true;
    return false;
  }

  private boolean jj_3R_448()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_449()) {
    jj_scanpos = xsp;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) {
    jj_scanpos = xsp;
    if (jj_3R_452()) return true;
    }
    }
    }
    if (jj_3R_441()) return true;
    return false;
  }

  private boolean jj_3R_498()
 {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_481()
 {
    if (jj_3R_228()) return true;
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_138()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_139()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_481()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_482()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_439()
 {
    if (jj_3R_441()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_448()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_492()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_498()) {
    jj_scanpos = xsp;
    if (jj_3R_499()) return true;
    }
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_224()) return true;
    return false;
  }

  private boolean jj_3R_483()
 {
    if (jj_3R_321()) return true;
    return false;
  }

  private boolean jj_3R_466()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_483()) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) return true;
    }
    return false;
  }

  private boolean jj_3R_440()
 {
    if (jj_scan_token(BIT_AND)) return true;
    if (jj_3R_427()) return true;
    return false;
  }

  private boolean jj_3R_436()
 {
    if (jj_3R_439()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_444()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_477()
 {
    if (jj_3R_492()) return true;
    return false;
  }

  private boolean jj_3R_455()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_466()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_3R_179()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_180()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) return true;
    }
    }
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_356()
 {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(RPAREN)) return true;
    if (jj_scan_token(LBRACE)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_477()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_454()
 {
    if (jj_3R_82()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_4()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_446()
 {
    if (jj_scan_token(NE)) return true;
    return false;
  }

  private boolean jj_3R_432()
 {
    if (jj_3R_100()) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_445()
 {
    if (jj_scan_token(EQ)) return true;
    return false;
  }

  private boolean jj_3R_453()
 {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_431()
 {
    if (jj_scan_token(DECR)) return true;
    return false;
  }

  private boolean jj_3R_442()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_445()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) return true;
    }
    if (jj_3R_436()) return true;
    return false;
  }

  private boolean jj_3R_185()
 {
    if (jj_3R_179()) return true;
    return false;
  }

  private boolean jj_3R_438()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_408()) return true;
    return false;
  }

  private boolean jj_3R_430()
 {
    if (jj_scan_token(INCR)) return true;
    return false;
  }

  private boolean jj_3R_415()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_430()) {
    jj_scanpos = xsp;
    if (jj_3R_431()) {
    jj_scanpos = xsp;
    if (jj_3R_432()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_182()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_433()
 {
    if (jj_scan_token(BIT_OR)) return true;
    if (jj_3R_377()) return true;
    return false;
  }

  private boolean jj_3R_421()
 {
    if (jj_scan_token(ENUM)) return true;
    if (jj_3R_99()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_453()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    xsp = jj_scanpos;
    if (jj_3R_454()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(106)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3R_184()
 {
    if (jj_3R_254()) return true;
    return false;
  }

  private boolean jj_3R_427()
 {
    if (jj_3R_436()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_442()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_392()
 {
    if (jj_3R_179()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_415()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_391()
 {
    if (jj_3R_322()) return true;
    return false;
  }

  private boolean jj_3R_419()
 {
    if (jj_scan_token(SC_AND)) return true;
    if (jj_3R_325()) return true;
    return false;
  }

  private boolean jj_3_60()
 {
    if (jj_3R_127()) return true;
    return false;
  }

  private boolean jj_3R_408()
 {
    if (jj_3R_427()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_440()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_355()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) return true;
    }
    }
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3R_476()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_397()
 {
    if (jj_scan_token(SC_OR)) return true;
    if (jj_3R_268()) return true;
    return false;
  }

  private boolean jj_3R_379()
 {
    if (jj_scan_token(IMPLEMENTS)) return true;
    if (jj_3R_380()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_476()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_377()
 {
    if (jj_3R_408()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_438()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_475()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_380()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_3R_179()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_182()) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_99()) return true;
    if (jj_3R_183()) return true;
    xsp = jj_scanpos;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) return true;
    }
    return false;
  }

  private boolean jj_3R_420()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_378()
 {
    if (jj_scan_token(EXTENDS)) return true;
    if (jj_3R_380()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_475()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_59()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_325()
 {
    if (jj_3R_377()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_433()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_288()
 {
    if (jj_scan_token(INTERFACE)) return true;
    return false;
  }

  private boolean jj_3R_398()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3R_420()) return true;
    }
    return false;
  }

  private boolean jj_3_85()
 {
    if (jj_3R_136()) return true;
    return false;
  }

  private boolean jj_3R_328()
 {
    if (jj_3R_379()) return true;
    return false;
  }

  private boolean jj_3R_327()
 {
    if (jj_3R_378()) return true;
    return false;
  }

  private boolean jj_3R_326()
 {
    if (jj_3R_140()) return true;
    return false;
  }

  private boolean jj_3R_268()
 {
    if (jj_3R_325()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_419()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_354()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    return false;
  }

  private boolean jj_3_86()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_239()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_3R_288()) return true;
    }
    if (jj_3R_99()) return true;
    xsp = jj_scanpos;
    if (jj_3R_326()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_327()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_328()) jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_84()
 {
    if (jj_3R_99()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_400()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_214()
 {
    if (jj_3R_268()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_397()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_3R_125()) return true;
    if (jj_3R_85()) return true;
    if (jj_3R_132()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_208()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_329()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_373()
 {
    if (jj_scan_token(HOOK)) return true;
    if (jj_3R_88()) return true;
    if (jj_scan_token(COLON)) return true;
    if (jj_3R_134()) return true;
    return false;
  }

  private boolean jj_3R_271()
 {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_3R_88()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_329()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(RBRACKET)) return true;
    return false;
  }

  private boolean jj_3_58()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_270()
 {
    if (jj_scan_token(151)) return true;
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3_57()
 {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    }
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_3R_214()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_3R_240()) return true;
    return false;
  }

  private boolean jj_3R_217()
 {
    if (jj_3R_99()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_270()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_271()) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public GeneratedJavaParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[181];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x24480800,0x4080000,0x24480800,0x1,0x0,0x0,0x20400800,0x80000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0xa54ca800,0xa54ca800,0x0,0x0,0x0,0x0,0x0,0x8000000,0x0,0xa54ca800,0xa54ca800,0x80000,0x8504a000,0xa54ca800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa544a800,0x0,0xa544a800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x8104a000,0x8504a000,0x8504a000,0x0,0x8504a000,0x8504a000,0x8000000,0x8000000,0x8104a000,0x8504a000,0x4000000,0x0,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x0,0x9504a000,0x0,0x0,0x8504a000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x4000000,0x0,0x0,0x10000000,0x4000000,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x8504a000,0x0,0x95a4f000,0x0,0x95a4f000,0x0,0x0,0x0,0x0,0x9504a000,0x410000,0x410000,0x2000000,0x0,0x4000000,0x4000000,0x0,0x20000,0x0,0x40000000,0x9504a000,0x4000000,0x0,0x0,0x0,0xa54ca800,0xa54ca800,0x80000,0x8504a000,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x4800000,0x4800000,0x0,0x0,0x0,0x0,0x0,0x9504a000,0x0,0x0,0x0,0x9504a000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x444ce290,0x80,0x444ce290,0x0,0x40000,0x0,0x444ce200,0x80,0x0,0x0,0x8,0x0,0x0,0x8,0x80000,0x0,0x644ee3c0,0x644ee3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x644ee3c0,0x644ee3c0,0x80,0x200a0140,0x644ee3c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x444ee340,0x0,0x444ee340,0x0,0x0,0x0,0x0,0x0,0x2000000,0x0,0x0,0x289a0d40,0x40000,0x20140,0xa0140,0xa0140,0x0,0xa0140,0xa0140,0x100000,0x100000,0x20140,0x200a0140,0x80000,0x0,0x80400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x289a0d40,0x0,0x0,0xa0140,0x0,0x0,0x0,0x80400,0x0,0x0,0x0,0x80400,0x0,0x0,0x8900c00,0x80000,0x0,0x0,0x0,0x800400,0x80000,0x0,0x0,0x800400,0x0,0x8000800,0x8000000,0x0,0x0,0x0,0xa0140,0x0,0xb9fb0d45,0x0,0xb9fb0d45,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x289a0d40,0x80000,0x0,0x0,0x0,0x444ee3c0,0x444ee3c0,0x80,0xa0140,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x80000,0x80000,0x0,0x0,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x289a0d40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x648,0x448,0x648,0x0,0x0,0x0,0x200,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff,0x0,0x7ff,0x7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff,0x7ff,0x0,0x7ff,0x7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7ff,0x0,0x7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc08787ff,0x0,0x0,0x7ff,0x7ff,0x0,0x7ff,0x7ff,0x0,0x0,0x0,0x7ff,0x7ff,0x0,0x7ff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc08787ff,0x0,0x0,0xc08787ff,0x0,0x0,0x7ff,0x0,0x0,0x0,0x7ff,0x0,0x0,0x0,0x7ff,0x0,0x0,0xc0878000,0x7ff,0x0,0x0,0x0,0x0,0x7ff,0x0,0x0,0x0,0x0,0xc0878000,0x0,0x0,0x0,0x0,0x7ff,0x0,0xc08787ff,0x0,0xc08787ff,0x0,0x0,0x0,0x0,0xc08787ff,0x0,0x0,0x0,0x0,0x7ff,0x7ff,0x0,0x0,0x0,0x0,0xc08787ff,0x7ff,0x0,0x0,0x0,0x7ff,0x7ff,0x0,0x7ff,0x0,0x0,0x2,0x0,0x2,0x0,0x1b1,0x8,0x1b1,0xc08787ff,0x0,0x7ff,0x7ff,0x0,0x0,0x0,0x0,0x800,0xc08787ff,0x800,0x7000,0x800,0xc08787ff,0x800,0x7000,0x0,0x0,0x800000,0x810000,0x800000,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x1200,0x1200,0x1200,0x0,0x0,0x800,0x1000,0x0,0x4000,0x0,0x0,0x400,0x400,0x0,0x1001,0x400,0x5221,0x5221,0x200,0x1000,0x8,0x20,0x400,0x0,0x80000000,0x5221,0x5221,0x0,0x5001,0x5001,0x400,0x2000,0x1080,0x20,0x400,0x4000,0x1080,0x400,0x0,0x220,0x1001,0x400,0x1001,0x400,0x400,0x1000,0x4000,0x400,0x0,0x4000,0x4000,0x5009,0x0,0x0,0x1,0x1001,0x400,0x21001,0x20001,0x0,0x0,0x0,0x1,0x1,0x4000,0x1,0x0,0x2000,0x2000,0x20000,0x800000,0x1000000,0x0,0x0,0x80000000,0x480000,0x480000,0x0,0x304000,0x304000,0x0,0x18000000,0x18000000,0x60000000,0x60000000,0x18000000,0x1e000000,0x784000,0x784000,0x19009,0x18000,0x18000,0x1009,0x6000000,0x80000000,0x1,0x4000,0x8,0x4000,0x1,0x800,0x10,0x4000,0x1,0x0,0x8,0x8,0x1,0x800,0x4000,0x8,0x0,0x9,0x4000,0x8,0x0,0x880,0x0,0x0,0x400,0x4000,0x1088,0x5001,0x20,0x6001229,0x40000,0x6001229,0x400,0x20,0x6002000,0x6002000,0x4001009,0x0,0x0,0x0,0x400,0x1,0x1,0x8,0x0,0x0,0x0,0x1009,0x1,0x400,0x20,0x400,0x1201,0x1201,0x0,0x1001,0x0,0x400,0x0,0x400,0x0,0x400,0x0,0x0,0x0,0x5009,0x400,0x1,0x1,0x40000000,0x0,0x400,0x80,0x0,0x1009,0x0,0x0,0x0,0x1009,0x0,0x0,0x80,0x80,0x0,0x20000000,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30000,0x37ff0,0x7ff0,0x0,0x0,0x0,0x1,0x2,0x0,0x0,0x0,0x0,0x100000,0x100000,0x8,0x0,0x0,0x4,0x4,0x0,0x0,0x100000,0x100000,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x0,0x0,0x0,0x400000,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x7ff0,0x7ff0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x1e000000,0x1e000000,0x1e000000,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[88];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public GeneratedJavaParser(Provider stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new GeneratedJavaParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 181; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public GeneratedJavaParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new GeneratedJavaParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 181; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public GeneratedJavaParser(GeneratedJavaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 181; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(GeneratedJavaParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 181; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = jj_lookingAhead ? jj_scanpos : token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[157];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 181; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 157; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : GeneratedJavaParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 88; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			   case 25: jj_3_26(); break;
			   case 26: jj_3_27(); break;
			   case 27: jj_3_28(); break;
			   case 28: jj_3_29(); break;
			   case 29: jj_3_30(); break;
			   case 30: jj_3_31(); break;
			   case 31: jj_3_32(); break;
			   case 32: jj_3_33(); break;
			   case 33: jj_3_34(); break;
			   case 34: jj_3_35(); break;
			   case 35: jj_3_36(); break;
			   case 36: jj_3_37(); break;
			   case 37: jj_3_38(); break;
			   case 38: jj_3_39(); break;
			   case 39: jj_3_40(); break;
			   case 40: jj_3_41(); break;
			   case 41: jj_3_42(); break;
			   case 42: jj_3_43(); break;
			   case 43: jj_3_44(); break;
			   case 44: jj_3_45(); break;
			   case 45: jj_3_46(); break;
			   case 46: jj_3_47(); break;
			   case 47: jj_3_48(); break;
			   case 48: jj_3_49(); break;
			   case 49: jj_3_50(); break;
			   case 50: jj_3_51(); break;
			   case 51: jj_3_52(); break;
			   case 52: jj_3_53(); break;
			   case 53: jj_3_54(); break;
			   case 54: jj_3_55(); break;
			   case 55: jj_3_56(); break;
			   case 56: jj_3_57(); break;
			   case 57: jj_3_58(); break;
			   case 58: jj_3_59(); break;
			   case 59: jj_3_60(); break;
			   case 60: jj_3_61(); break;
			   case 61: jj_3_62(); break;
			   case 62: jj_3_63(); break;
			   case 63: jj_3_64(); break;
			   case 64: jj_3_65(); break;
			   case 65: jj_3_66(); break;
			   case 66: jj_3_67(); break;
			   case 67: jj_3_68(); break;
			   case 68: jj_3_69(); break;
			   case 69: jj_3_70(); break;
			   case 70: jj_3_71(); break;
			   case 71: jj_3_72(); break;
			   case 72: jj_3_73(); break;
			   case 73: jj_3_74(); break;
			   case 74: jj_3_75(); break;
			   case 75: jj_3_76(); break;
			   case 76: jj_3_77(); break;
			   case 77: jj_3_78(); break;
			   case 78: jj_3_79(); break;
			   case 79: jj_3_80(); break;
			   case 80: jj_3_81(); break;
			   case 81: jj_3_82(); break;
			   case 82: jj_3_83(); break;
			   case 83: jj_3_84(); break;
			   case 84: jj_3_85(); break;
			   case 85: jj_3_86(); break;
			   case 86: jj_3_87(); break;
			   case 87: jj_3_88(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
