package org.drools.javaparser.ast.nodeTypes.modifiers;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.nodeTypes.NodeWithModifiers;

import static org.drools.javaparser.ast.Modifier.STRICTFP;

/**
 * A node that can be strictfp.
 */
public interface NodeWithStrictfpModifier<N extends Node> extends NodeWithModifiers<N> {
    default boolean isStrictfp() {
        return getModifiers().contains(STRICTFP);
    }

    @SuppressWarnings("unchecked")
    default N setStrictfp(boolean set) {
        return setModifier(STRICTFP, set);
    }
}
