/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer.concretesyntaxmodel;

import org.drools.javaparser.GeneratedJavaParserConstants;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.expr.IntegerLiteralExpr;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.printer.SourcePrinter;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmElement;
import org.drools.javaparser.printer.concretesyntaxmodel.PrintingHelper;

public class CsmAttribute
implements CsmElement {
    private final ObservableProperty property;

    public ObservableProperty getProperty() {
        return this.property;
    }

    public CsmAttribute(ObservableProperty property) {
        this.property = property;
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        Object value = this.property.getRawValue(node);
        printer.print(PrintingHelper.printToString(value));
    }

    public int getTokenType(Node node, String text) {
        switch (this.property) {
            case IDENTIFIER: {
                return 96;
            }
            case TYPE: {
                String expectedImage = "\"" + text.toLowerCase() + "\"";
                for (int i = 0; i < GeneratedJavaParserConstants.tokenImage.length; ++i) {
                    if (!GeneratedJavaParserConstants.tokenImage[i].equals(expectedImage)) continue;
                    return i;
                }
                throw new RuntimeException("Attribute 'type' does not corresponding to any expected value. Text: " + text);
            }
            case OPERATOR: {
                try {
                    return (Integer)GeneratedJavaParserConstants.class.getDeclaredField(text).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException("Attribute 'operator' does not corresponding to any expected value. Text: " + text, e);
                }
            }
            case VALUE: {
                if (node instanceof IntegerLiteralExpr) {
                    return 80;
                }
            }
            case NAME: {
                return 96;
            }
        }
        throw new UnsupportedOperationException("getTokenType does not know how to handle property " + (Object)((Object)this.property) + " with text: " + text);
    }
}

