package org.drools.javaparser.ast.nodeTypes;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.comments.Comment;
import org.drools.javaparser.ast.expr.Expression;
import org.drools.javaparser.ast.stmt.SwitchEntryStmt;

import java.util.Optional;

/**
 * The common interface of {@link org.drools.javaparser.ast.expr.SwitchExpr} and {@link org.drools.javaparser.ast.stmt.SwitchStmt}
 */
public interface SwitchNode {
    NodeList<SwitchEntryStmt> getEntries();

    SwitchEntryStmt getEntry(int i);

    Expression getSelector();

    SwitchNode setEntries(NodeList<SwitchEntryStmt> entries);

    SwitchNode setSelector(Expression selector);

    boolean remove(Node node);

    SwitchNode clone();

    boolean replace(Node node, Node replacementNode);

    Optional<Comment> getComment();
    
    // Too bad Node isn't an interface, or this could have easily inherited all of its methods.
    // Add more when required.
}
