package org.drools.javaparser.ast.validator;

import org.drools.javaparser.Problem;
import org.drools.javaparser.TokenRange;
import org.drools.javaparser.ast.nodeTypes.NodeWithTokenRange;

import java.util.function.Consumer;

import static org.drools.javaparser.utils.CodeGenerationUtils.f;

/**
 * A simple interface where validators can report found problems.
 */
public class ProblemReporter {
    private final Consumer<Problem> problemConsumer;

    public ProblemReporter(Consumer<Problem> problemConsumer) {
        this.problemConsumer = problemConsumer;
    }

    /**
     * Report a problem.
     *
     * @param message description of the problem
     * @param node the node in which the problem occurred, used to find the Range of the problem.
     */
    public void report(NodeWithTokenRange<?> node, String message, Object... args) {
        report(node.getTokenRange().orElse(null), message, args);
    }

    public void report(TokenRange range, String message, Object... args) {
        problemConsumer.accept(new Problem(f(message, args), range, null));
    }
}
