package org.drools.javaparser.version;

import org.drools.javaparser.ast.type.ClassOrInterfaceType;
import org.drools.javaparser.ast.type.VarType;

import static org.drools.javaparser.ParseResult.PostProcessor;

/**
 * Processes the generic AST into a Java 10 AST and validates it.
 */
public class Java10PostProcessor extends PostProcessors {
    protected final PostProcessor varNodeCreator = (result, configuration) ->
            result.getResult().ifPresent(node -> {
                node.findAll(ClassOrInterfaceType.class).forEach(n -> {
                    if (n.getNameAsString().equals("var")) {
                        n.replace(new VarType(n.getTokenRange().orElse(null)));
                    }
                });
            });

    public Java10PostProcessor() {
        add(varNodeCreator);
    }
}
