/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer.concretesyntaxmodel;

import java.util.Arrays;
import java.util.List;
import org.drools.javaparser.TokenTypes;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.printer.SourcePrinter;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmAttribute;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmChar;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmComment;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmConditional;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmIndent;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmList;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmNone;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmOrphanCommentsEnding;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmSequence;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmSingleReference;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmString;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmToken;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import org.drools.javaparser.utils.Utils;

public interface CsmElement {
    public void prettyPrint(Node var1, SourcePrinter var2);

    public static CsmElement child(ObservableProperty property) {
        return new CsmSingleReference(property);
    }

    public static CsmElement attribute(ObservableProperty property) {
        return new CsmAttribute(property);
    }

    public static CsmElement sequence(CsmElement ... elements) {
        return new CsmSequence(Arrays.asList(elements));
    }

    public static CsmElement string(int tokenType, String content) {
        return new CsmToken(tokenType, content);
    }

    public static CsmElement string(int tokenType) {
        return new CsmToken(tokenType);
    }

    public static CsmElement stringToken(ObservableProperty property) {
        return new CsmString(property);
    }

    public static CsmElement charToken(ObservableProperty property) {
        return new CsmChar(property);
    }

    public static CsmElement token(int tokenType) {
        return new CsmToken(tokenType);
    }

    public static CsmElement token(int tokenType, CsmToken.TokenContentCalculator tokenContentCalculator) {
        return new CsmToken(tokenType, tokenContentCalculator);
    }

    public static CsmElement conditional(ObservableProperty property, CsmConditional.Condition condition, CsmElement thenElement) {
        return new CsmConditional(property, condition, thenElement);
    }

    public static CsmElement conditional(ObservableProperty property, CsmConditional.Condition condition, CsmElement thenElement, CsmElement elseElement) {
        return new CsmConditional(property, condition, thenElement, elseElement);
    }

    public static CsmElement conditional(List<ObservableProperty> properties, CsmConditional.Condition condition, CsmElement thenElement, CsmElement elseElement) {
        return new CsmConditional(properties, condition, thenElement, elseElement);
    }

    public static CsmElement space() {
        return new CsmToken(TokenTypes.spaceTokenKind(), " ");
    }

    public static CsmElement semicolon() {
        return new CsmToken(99);
    }

    public static CsmElement comment() {
        return new CsmComment();
    }

    public static CsmElement newline() {
        return new CsmToken(TokenTypes.eolTokenKind(), Utils.EOL);
    }

    public static CsmElement none() {
        return new CsmNone();
    }

    public static CsmElement comma() {
        return new CsmToken(100);
    }

    public static CsmElement list(ObservableProperty property) {
        return new CsmList(property);
    }

    public static CsmElement list(ObservableProperty property, CsmElement separator) {
        return new CsmList(property, CsmElement.none(), separator, new CsmNone(), new CsmNone());
    }

    public static CsmElement list(ObservableProperty property, CsmElement separator, CsmElement preceeding, CsmElement following) {
        return new CsmList(property, CsmElement.none(), separator, preceeding, following);
    }

    public static CsmElement list(ObservableProperty property, CsmElement separatorPre, CsmElement separatorPost, CsmElement preceeding, CsmElement following) {
        return new CsmList(property, separatorPre, separatorPost, preceeding, following);
    }

    public static CsmElement orphanCommentsEnding() {
        return new CsmOrphanCommentsEnding();
    }

    public static CsmElement orphanCommentsBeforeThis() {
        return new CsmNone();
    }

    public static CsmElement indent() {
        return new CsmIndent();
    }

    public static CsmElement unindent() {
        return new CsmUnindent();
    }

    public static CsmElement block(CsmElement content) {
        return CsmElement.sequence(CsmElement.token(95), CsmElement.indent(), content, CsmElement.unindent(), CsmElement.token(96));
    }
}

