/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.ancompiler.CompiledNetwork;
import org.drools.ancompiler.CouldNotCreateAlphaNetworkCompilerException;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.index.AlphaRangeIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompiledNetworkSources {
    private final Logger logger = LoggerFactory.getLogger(CompiledNetworkSources.class);
    private final String source;
    private final IndexableConstraint indexableConstraint;
    private final String name;
    private final String sourceName;
    private final ObjectTypeNode objectTypeNode;
    private final Map<String, AlphaRangeIndex> rangeIndexDeclarationMap;
    private Collection<CompilationUnit> initClasses;

    public CompiledNetworkSources(String source, IndexableConstraint indexableConstraint, String name, String sourceName, ObjectTypeNode objectTypeNode, Map<String, AlphaRangeIndex> rangeIndexDeclarationMap, Collection<CompilationUnit> initClasses) {
        this.source = source;
        this.indexableConstraint = indexableConstraint;
        this.name = name;
        this.sourceName = sourceName;
        this.objectTypeNode = objectTypeNode;
        this.rangeIndexDeclarationMap = rangeIndexDeclarationMap;
        this.initClasses = initClasses;
    }

    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Collection<CompilationUnit> getInitClasses() {
        return this.initClasses;
    }

    public CompiledNetwork createInstanceAndSet(Class<?> compiledNetworkClass) {
        CompiledNetwork compiledNetwork = this.newCompiledNetworkInstance(compiledNetworkClass);
        compiledNetwork.setStartingObjectTypeNode(this.objectTypeNode);
        this.logger.debug("Setting {} as starting node of: {}", (Object)this.objectTypeNode, (Object)compiledNetworkClass.getName());
        return compiledNetwork;
    }

    public CompiledNetwork newCompiledNetworkInstance(Class<?> aClass) {
        try {
            return (CompiledNetwork)aClass.getDeclaredConstructor(InternalReadAccessor.class, Map.class).newInstance(this.getFieldExtractor(), this.rangeIndexDeclarationMap);
        }
        catch (Exception e) {
            throw new CouldNotCreateAlphaNetworkCompilerException(e);
        }
    }

    private InternalReadAccessor getFieldExtractor() {
        return this.indexableConstraint == null ? null : this.indexableConstraint.getFieldExtractor();
    }

    public Map<String, String> getAllGeneratedSources() {
        HashMap<String, String> allGeneratedSources = new HashMap<String, String>();
        allGeneratedSources.put(this.getName(), this.getSource());
        for (CompilationUnit ch : this.getInitClasses()) {
            PackageDeclaration packageDeclaration = (PackageDeclaration)ch.getChildNodes().get(0);
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)ch.getChildNodes().get(1);
            String classNameWithPackage = String.format("%s.%s", packageDeclaration.getNameAsString(), classOrInterfaceDeclaration.getNameAsString());
            allGeneratedSources.put(classNameWithPackage, ch.toString());
        }
        return allGeneratedSources;
    }
}

