/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ancompiler;

import java.util.Map;
import java.util.Optional;
import org.drools.ancompiler.CompiledNetworkSources;
import org.drools.ancompiler.CouldNotCreateAlphaNetworkCompilerException;
import org.drools.ancompiler.ObjectTypeNodeCompiler;
import org.drools.compiler.kie.builder.impl.KieBaseUpdater;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterOptions;
import org.drools.compiler.kie.builder.impl.KieBaseUpdatersContext;
import org.drools.core.reteoo.Rete;
import org.drools.core.util.MapUtils;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.kie.api.KieBase;
import org.kie.api.conf.Option;
import org.kie.internal.builder.conf.AlphaNetworkCompilerOption;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieBaseUpdaterANC
implements KieBaseUpdater {
    private final Logger logger = LoggerFactory.getLogger(KieBaseUpdaterANC.class);
    private final KieBaseUpdatersContext ctx;

    public KieBaseUpdaterANC(KieBaseUpdatersContext ctx) {
        this.ctx = ctx;
    }

    public void run() {
        Optional ancMode = this.ctx.getOption(AlphaNetworkCompilerOption.class);
        if (ancMode.filter(arg_0 -> AlphaNetworkCompilerOption.INMEMORY.equals(arg_0)).isPresent()) {
            this.inMemoryUpdate(this.ctx.getClassLoader(), this.ctx.getRete());
        } else if (ancMode.filter(arg_0 -> AlphaNetworkCompilerOption.LOAD.equals(arg_0)).isPresent()) {
            this.logger.debug("Loading compiled alpha network from KJar");
            this.loadFromKJar(this.ctx.getClassLoader(), this.ctx.getRete());
        }
    }

    private void inMemoryUpdate(ClassLoader rootClassLoader, Rete rete) {
        Map<String, CompiledNetworkSources> compiledNetworkSourcesMap = ObjectTypeNodeCompiler.compiledNetworkSourceMap(rete);
        if (!compiledNetworkSourcesMap.isEmpty()) {
            Map compiledClasses = KieMemoryCompiler.compile((Map)MapUtils.mapValues(compiledNetworkSourcesMap, CompiledNetworkSources::getSource), (ClassLoader)rootClassLoader);
            compiledNetworkSourcesMap.values().forEach(c -> {
                Class aClass = (Class)compiledClasses.get(c.getName());
                c.createInstanceAndSet(aClass);
            });
        }
    }

    private void loadFromKJar(ClassLoader rootClassLoader, Rete rete) {
        Map<String, CompiledNetworkSources> compiledNetworkSourcesMap = ObjectTypeNodeCompiler.compiledNetworkSourceMap(rete);
        for (Map.Entry<String, CompiledNetworkSources> kv : compiledNetworkSourcesMap.entrySet()) {
            Class<?> aClass;
            String compiledNetworkClassName = kv.getValue().getName();
            try {
                aClass = rootClassLoader.loadClass(compiledNetworkClassName);
            }
            catch (ClassNotFoundException e) {
                throw new CouldNotCreateAlphaNetworkCompilerException(e);
            }
            kv.getValue().createInstanceAndSet(aClass);
        }
    }

    public static void generateAndSetInMemoryANC(KieBase kbase) {
        KieBaseUpdaterOptions kieBaseUpdaterOptions = new KieBaseUpdaterOptions(new KieBaseUpdaterOptions.OptionEntry[]{new KieBaseUpdaterOptions.OptionEntry(AlphaNetworkCompilerOption.class, (Option)AlphaNetworkCompilerOption.INMEMORY)});
        KieBaseUpdatersContext context = new KieBaseUpdatersContext(kieBaseUpdaterOptions, ((InternalKnowledgeBase)kbase).getRete(), ((InternalKnowledgeBase)kbase).getRootClassLoader());
        new KieBaseUpdaterANC(context).run();
    }
}

