/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.accumulateFunction;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.LiteralRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindMissingNumber {
    public static final int MIN_NUMBER_OF_RESTRICTIONS = 4;

    public static Number testForPattern(Collection<LiteralRestriction> restrictions) {
        if (restrictions == null || restrictions.size() < 4) {
            return null;
        }
        Object[] numbers = new BigDecimal[restrictions.size()];
        int index = 0;
        for (LiteralRestriction restriction : restrictions) {
            if (restriction.getValueType() == Field.FieldType.DOUBLE) {
                numbers[index++] = BigDecimal.valueOf(restriction.getDoubleValue());
                continue;
            }
            if (restriction.getValueType() != Field.FieldType.INT) continue;
            numbers[index++] = BigDecimal.valueOf(restriction.getIntValue());
        }
        Arrays.sort(numbers);
        Number missingNumber = FindMissingNumber.findSumPattern((BigDecimal[])numbers);
        if (missingNumber != null) {
            return missingNumber;
        }
        missingNumber = FindMissingNumber.findMultiplicationPattern((BigDecimal[])numbers);
        if (missingNumber != null) {
            return missingNumber;
        }
        return null;
    }

    protected static Number findSumPattern(BigDecimal[] numbers) {
        if (numbers == null || numbers.length < 4) {
            return null;
        }
        BigDecimal gap = null;
        BigDecimal missingNumber = null;
        BigDecimal a = numbers[0];
        BigDecimal b = numbers[1];
        BigDecimal c = numbers[2];
        BigDecimal d = numbers[3];
        if (b.subtract(a).equals(c.subtract(b))) {
            gap = b.subtract(a);
        } else if (c.subtract(b).equals(d.subtract(c))) {
            gap = c.subtract(b);
        } else if (b.subtract(a).equals(d.subtract(c))) {
            gap = b.subtract(a);
        } else {
            return null;
        }
        for (int i = 0; i < numbers.length - 1; ++i) {
            BigDecimal first = numbers[i];
            BigDecimal second = numbers[i + 1];
            if (missingNumber == null && !second.subtract(first).equals(gap)) {
                missingNumber = second.subtract(gap);
                continue;
            }
            if (second.subtract(first).equals(gap) || missingNumber == null) continue;
            return null;
        }
        return missingNumber;
    }

    protected static Number findMultiplicationPattern(BigDecimal[] numbers) {
        if (numbers == null || numbers.length < 4) {
            return null;
        }
        try {
            BigDecimal gap = null;
            BigDecimal missingNumber = null;
            BigDecimal a = numbers[0];
            BigDecimal b = numbers[1];
            BigDecimal c = numbers[2];
            BigDecimal d = numbers[3];
            if (b.divide(a).equals(c.divide(b))) {
                gap = b.divide(a);
            } else if (c.divide(b).equals(d.divide(c))) {
                gap = c.divide(b);
            } else if (b.divide(a).equals(d.divide(c))) {
                gap = b.divide(a);
            } else {
                return null;
            }
            BigDecimal first = null;
            BigDecimal second = null;
            for (int i = 0; i < numbers.length - 1; ++i) {
                first = numbers[i];
                second = numbers[i + 1];
                if (missingNumber == null && !second.divide(first).equals(gap)) {
                    missingNumber = first.multiply(gap);
                    continue;
                }
                if (second.divide(first).equals(gap) || missingNumber == null) continue;
                return null;
            }
            return missingNumber;
        }
        catch (Exception e) {
            return null;
        }
    }
}

