/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.components;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.drools.analytics.components.Field;
import org.drools.analytics.components.Restriction;
import org.drools.analytics.result.Cause;

public class LiteralRestriction
extends Restriction
implements Cause {
    private Field.FieldType valueType;
    private boolean booleanValue;
    private int intValue;
    private double doubleValue;
    private String stringValue;
    private Date dateValue;

    public Restriction.RestrictionType getRestrictionType() {
        return Restriction.RestrictionType.LITERAL;
    }

    public Object getValueAsObject() {
        switch (this.valueType) {
            case BOOLEAN: {
                return this.booleanValue;
            }
            case DATE: {
                return this.dateValue;
            }
            case DOUBLE: {
                return this.doubleValue;
            }
            case INT: {
                return this.intValue;
            }
        }
        return this.stringValue;
    }

    public String getValueAsString() {
        return this.stringValue;
    }

    public double getDoubleValue() {
        return this.doubleValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public Field.FieldType getValueType() {
        return this.valueType;
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setValue(String value) {
        if ("true".equals(value) || "false".equals(value)) {
            this.booleanValue = value.equals("true");
            this.valueType = Field.FieldType.BOOLEAN;
            this.stringValue = value;
        }
        try {
            this.intValue = Integer.parseInt(value);
            this.valueType = Field.FieldType.INT;
            this.stringValue = value;
            return;
        }
        catch (NumberFormatException e) {
            try {
                this.doubleValue = Double.parseDouble(value);
                this.valueType = Field.FieldType.DOUBLE;
                this.stringValue = value;
                return;
            }
            catch (NumberFormatException e2) {
                try {
                    String fmt = System.getProperty("drools.dateformat");
                    if (fmt == null) {
                        fmt = "dd-MMM-yyyy";
                    }
                    this.dateValue = new SimpleDateFormat(fmt, Locale.ENGLISH).parse(value);
                    this.valueType = Field.FieldType.DATE;
                    this.stringValue = value;
                    return;
                }
                catch (Exception exception) {
                    this.stringValue = value;
                    this.valueType = Field.FieldType.STRING;
                    return;
                }
            }
        }
    }

    public boolean isBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public String toString() {
        return "LiteralRestriction from rule '" + this.ruleName + "' value '" + this.stringValue + "'";
    }
}

