/*
 * Decompiled with CFR 0.152.
 */
package org.drools.analytics.result;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.drools.analytics.components.AnalyticsClass;
import org.drools.analytics.components.AnalyticsRule;
import org.drools.analytics.components.Field;
import org.drools.analytics.dao.AnalyticsData;
import org.drools.analytics.dao.AnalyticsDataFactory;
import org.drools.analytics.result.AnalysisResult;
import org.drools.analytics.result.ComponentsReportVisitor;
import org.drools.analytics.result.MissingRangesReportVisitor;
import org.drools.analytics.result.RangeCheckCause;

public class ComponentsReportModeller {
    public static void writeHTML(String path, AnalysisResult result) {
        AnalyticsData data = AnalyticsDataFactory.getAnalyticsData();
        File sourceFolder = new File(path + "report");
        sourceFolder.mkdir();
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "index.htm", ComponentsReportVisitor.visitObjectTypeCollection(data.getAllClasses()));
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "packages.htm", ComponentsReportVisitor.visitRulePackageCollection(data.getAllRulePackages()));
        String ruleFolder = path + "report" + File.separator + "rules";
        File rulesFolder = new File(ruleFolder);
        rulesFolder.mkdir();
        for (AnalyticsRule rule : data.getAllRules()) {
            ComponentsReportModeller.writeToFile(ruleFolder + File.separator + rule.getId() + ".htm", ComponentsReportVisitor.visitRule(rule));
        }
        String objectTypeFolder = path + "report" + File.separator + "objectTypes";
        File objectTypesFolder = new File(objectTypeFolder);
        objectTypesFolder.mkdir();
        for (AnalyticsClass objectType : data.getAllClasses()) {
            ComponentsReportModeller.writeToFile(objectTypeFolder + File.separator + objectType.getId() + ".htm", ComponentsReportVisitor.visitObjectType(objectType));
        }
        String fieldFolder = path + "report" + File.separator + "fields";
        File fieldsFolder = new File(fieldFolder);
        fieldsFolder.mkdir();
        for (Field field : data.getAllFields()) {
            ComponentsReportModeller.writeToFile(fieldFolder + File.separator + field.getId() + ".htm", ComponentsReportVisitor.visitField(field));
        }
        Collection<RangeCheckCause> rangeCheckCauses = data.getRangeCheckCauses();
        ComponentsReportModeller.writeToFile(path + "report" + File.separator + "missingRanges.htm", MissingRangesReportVisitor.visitRangeCheckCauseCollection(rangeCheckCauses));
        String cssFolder = path + "report" + File.separator + "css";
        File cssesFolder = new File(cssFolder);
        cssesFolder.mkdir();
        ComponentsReportModeller.writeToFile(cssFolder + File.separator + "relationsDetails.css", ComponentsReportVisitor.getCss("relationsDetails.css"));
        ComponentsReportModeller.writeToFile(cssFolder + File.separator + "relationsList.css", ComponentsReportVisitor.getCss("relationsList.css"));
        String imagesFolder = path + "report" + File.separator + "images";
        File imgsFolder = new File(imagesFolder);
        imgsFolder.mkdir();
        try {
            ComponentsReportModeller.copyFile(imagesFolder, "hdrlogo_drools50px.gif");
            ComponentsReportModeller.copyFile(imagesFolder, "jbossrules_hdrbkg_blue.gif");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String destination, String filename) throws IOException {
        File source = new File(ComponentsReportModeller.class.getResource(filename).getFile());
        File dest = new File(destination + File.separator + filename);
        if (!dest.exists()) {
            dest.createNewFile();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void writeToFile(String fileName, String text) {
        try {
            FileWriter fstream = new FileWriter(fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(text);
            out.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

