/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.ProviderInitializationException;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentProvider;

public class KnowledgeAgentFactory {
    private static KnowledgeAgentProvider provider;

    public static KnowledgeAgentConfiguration newKnowledgeAgentConfiguration() {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgentConfiguration();
    }

    public static KnowledgeAgentConfiguration newKnowledgeAgentConfiguration(Properties properties) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgentConfiguration(properties);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeBase kbase) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, kbase);
    }

    public static KnowledgeAgent newKnowledgeAgent(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration) {
        return KnowledgeAgentFactory.getKnowledgeAgentProvider().newKnowledgeAgent(name, kbase, configuration);
    }

    private static synchronized void setKnowledgeAgentProvider(KnowledgeAgentProvider provider) {
        KnowledgeAgentFactory.provider = provider;
    }

    private static synchronized KnowledgeAgentProvider getKnowledgeAgentProvider() {
        if (provider == null) {
            KnowledgeAgentFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.agent.impl.KnowledgeAgentProviderImpl");
            KnowledgeAgentFactory.setKnowledgeAgentProvider((KnowledgeAgentProvider)cls.newInstance());
        }
        catch (Exception e) {
            throw new ProviderInitializationException("Provider org.drools.agent.KnowledgeAgentProvider could not be set.");
        }
    }
}

