/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.drools.base.base.AccessorKeySupplier;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;
import org.drools.base.common.DroolsObjectInputStream;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Pattern;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.TupleValueExtractor;
import org.drools.util.ClassUtils;
import org.kie.api.runtime.rule.FactHandle;

public class Declaration
implements Externalizable,
AcceptsReadAccessor,
TupleValueExtractor {
    private static final long serialVersionUID = 510L;
    private String identifier;
    private String bindingName;
    private ReadAccessor readAccessor;
    private Pattern pattern;
    private boolean internalFact;
    private transient Class<?> declarationClass;
    private int xPathOffset = 0;
    private transient String cachedTypeName;
    private transient String cachedBoxedTypeName;

    public Declaration() {
        this(null, null, null);
    }

    public Declaration(String identifier, Pattern pattern) {
        this(identifier, null, pattern, false);
    }

    public Declaration(String identifier, ReadAccessor extractor, Pattern pattern) {
        this(identifier, extractor, pattern, false);
    }

    public Declaration(String identifier, ReadAccessor extractor, Pattern pattern, boolean internalFact) {
        this.identifier = identifier;
        this.readAccessor = extractor;
        this.pattern = pattern;
        this.internalFact = internalFact;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = (String)in.readObject();
        if (in instanceof DroolsObjectInputStream) {
            ((DroolsObjectInputStream)in).readExtractor(this::setReadAccessor);
        } else {
            this.readAccessor = (ReadAccessor)in.readObject();
        }
        this.pattern = (Pattern)in.readObject();
        this.internalFact = in.readBoolean();
        this.bindingName = (String)in.readObject();
        this.xPathOffset = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.identifier);
        if (this.readAccessor instanceof AccessorKeySupplier) {
            out.writeObject(((AccessorKeySupplier)((Object)this.readAccessor)).getAccessorKey());
        } else {
            out.writeObject(this.readAccessor);
        }
        out.writeObject(this.pattern);
        out.writeBoolean(this.internalFact);
        out.writeObject(this.bindingName);
        out.writeInt(this.xPathOffset);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBindingName() {
        return this.bindingName != null ? this.bindingName : this.identifier;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    @Override
    public ValueType getValueType() {
        return this.readAccessor.getValueType();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public int getObjectIndex() {
        return this.pattern.getObjectIndex() + this.xPathOffset;
    }

    public int getTupleIndex() {
        return this.pattern.getTupleIndex() + this.xPathOffset;
    }

    public void setxPathOffset(int xPathOffset) {
        this.xPathOffset = xPathOffset;
    }

    public int getxPathOffset() {
        return this.xPathOffset;
    }

    public boolean isFromXpathChunk() {
        return this.xPathOffset >= 1;
    }

    public boolean isPatternDeclaration() {
        return this.pattern != null && this.pattern.getDeclaration() == this || this.getIdentifier().equals("this");
    }

    @Override
    public void setReadAccessor(ReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    public ReadAccessor getExtractor() {
        return this.readAccessor;
    }

    public Class<?> getDeclarationClass() {
        if (this.declarationClass == null) {
            this.declarationClass = this.readAccessor != null ? this.readAccessor.getExtractToClass() : null;
        }
        return this.declarationClass;
    }

    public void setDeclarationClass(Class<?> declarationClass) {
        this.declarationClass = declarationClass;
    }

    @Override
    public Object getValue(ValueResolver valueResolver, BaseTuple tuple) {
        return this.getValue(valueResolver, tuple.get(this));
    }

    public Object getValue(ValueResolver valueResolver, FactHandle fh) {
        return this.getValue(valueResolver, fh.getObject());
    }

    public Object getValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getValue(valueResolver, object);
    }

    public char getCharValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getCharValue(valueResolver, object);
    }

    public int getIntValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getIntValue(valueResolver, object);
    }

    public byte getByteValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getByteValue(valueResolver, object);
    }

    public short getShortValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getShortValue(valueResolver, object);
    }

    public long getLongValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getLongValue(valueResolver, object);
    }

    public float getFloatValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getFloatValue(valueResolver, object);
    }

    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getDoubleValue(valueResolver, object);
    }

    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getBooleanValue(valueResolver, object);
    }

    public int getHashCode(ValueResolver valueResolver, Object object) {
        return this.readAccessor.getHashCode(valueResolver, object);
    }

    public boolean isGlobal() {
        return this.readAccessor != null && this.readAccessor.isGlobal();
    }

    public Method getNativeReadMethod() {
        if (this.readAccessor != null) {
            return this.readAccessor.getNativeReadMethod();
        }
        try {
            return this.getClass().getDeclaredMethod("getValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public String getNativeReadMethodName() {
        return this.readAccessor != null ? this.readAccessor.getNativeReadMethodName() : "getValue";
    }

    public String getTypeName() {
        if (this.cachedTypeName == null) {
            this.cachedTypeName = this.getExtractor() != null && this.getDeclarationClass() != null ? ClassUtils.canonicalName(this.getDeclarationClass()) : "java.lang.Object";
        }
        return this.cachedTypeName;
    }

    public String getBoxedTypeName() {
        if (this.cachedBoxedTypeName == null) {
            this.cachedBoxedTypeName = this.getExtractor() != null ? ClassUtils.canonicalName((Class)ClassUtils.convertFromPrimitiveType(this.getDeclarationClass())) : "java.lang.Object";
        }
        return this.cachedBoxedTypeName;
    }

    public String toString() {
        return "(" + (Serializable)(this.readAccessor != null ? this.readAccessor.getValueType() : "null accessor") + ") " + this.identifier;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.pattern.getTupleIndex();
        result = 31 * result + this.readAccessor.hashCode();
        result = 31 * result + this.xPathOffset;
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Declaration other = (Declaration)object;
        return this.pattern.getPatternId() == other.pattern.getPatternId() && this.readAccessor.equals(other.readAccessor) && this.xPathOffset == other.xPathOffset;
    }

    public boolean isInternalFact() {
        return this.internalFact;
    }

    @Override
    public Declaration clone() {
        Declaration declr = new Declaration(this.identifier, this.readAccessor, this.pattern);
        declr.setBindingName(this.bindingName);
        declr.setxPathOffset(this.xPathOffset);
        return declr;
    }

    public Declaration cloneWithPattern(Pattern pattern) {
        Declaration declr = new Declaration(this.identifier, this.readAccessor, pattern);
        declr.setBindingName(this.bindingName);
        declr.setxPathOffset(this.xPathOffset);
        return declr;
    }
}

