/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.rule.constraint;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.base.DroolsQuery;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.field.ObjectFieldImpl;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.IndexableConstraint;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.FieldValue;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.constraint.AlphaNodeFieldConstraint;
import org.drools.base.rule.constraint.Constraint;
import org.drools.base.util.FieldIndex;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.runtime.rule.FactHandle;

public class QueryNameConstraint
implements AlphaNodeFieldConstraint,
IndexableConstraint,
AcceptsReadAccessor,
Externalizable {
    private ReadAccessor readAccessor;
    private String queryName;
    private FieldValue fieldValue;

    public QueryNameConstraint() {
    }

    public QueryNameConstraint(ReadAccessor readAccessor, String queryName) {
        this.readAccessor = readAccessor;
        this.queryName = queryName;
    }

    @Override
    public boolean isAllowed(FactHandle handle, ValueResolver valueResolver) {
        return ((DroolsQuery)handle.getObject()).getName().equals(this.queryName);
    }

    @Override
    public boolean isUnification() {
        return false;
    }

    @Override
    public boolean isIndexable(short nodeType, KieBaseConfiguration config) {
        return true;
    }

    @Override
    public ConstraintTypeOperator getConstraintType() {
        return ConstraintTypeOperator.EQUAL;
    }

    @Override
    public FieldValue getField() {
        if (this.fieldValue == null) {
            this.fieldValue = new ObjectFieldImpl(this.queryName);
        }
        return this.fieldValue;
    }

    @Override
    public FieldIndex getFieldIndex() {
        return null;
    }

    @Override
    public ReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    @Override
    public void setReadAccessor(ReadAccessor readAccessor) {
        this.readAccessor = readAccessor;
    }

    @Override
    public Declaration getIndexExtractor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return new Declaration[0];
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
    }

    @Override
    public Constraint clone() {
        return new QueryNameConstraint(this.readAccessor, this.queryName);
    }

    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public Constraint.ConstraintType getType() {
        return Constraint.ConstraintType.ALPHA;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readAccessor = (ReadAccessor)in.readObject();
        this.queryName = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.readAccessor);
        out.writeObject(this.queryName);
    }

    @Override
    public QueryNameConstraint cloneIfInUse() {
        return this;
    }

    public int hashCode() {
        return this.queryName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof QueryNameConstraint && this.queryName.equals(((QueryNameConstraint)obj).queryName);
    }

    public String toString() {
        return "QueryNameConstraint for " + this.queryName;
    }
}

