/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.definitions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.base.definitions.ResourceTypePackageRegistry;
import org.kie.api.definition.process.Process;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.io.ResourceType;

public class ProcessPackage
implements ResourceTypePackage<Process> {
    private final Map<String, Process> ruleFlows = new HashMap<String, Process>();

    public static ProcessPackage getOrCreate(ResourceTypePackageRegistry rtps) {
        ProcessPackage rtp = (ProcessPackage)rtps.get(ResourceType.BPMN2);
        if (rtp == null) {
            rtp = new ProcessPackage();
            rtps.put(ResourceType.BPMN2, rtp);
            rtps.put(ResourceType.DRF, rtp);
            rtps.put(ResourceType.CMMN, rtp);
        }
        return rtp;
    }

    public Map<String, Process> getRuleFlows() {
        return this.ruleFlows;
    }

    public ResourceType getResourceType() {
        return ResourceType.BPMN2;
    }

    public Process lookup(String id) {
        return this.ruleFlows.get(id);
    }

    public void add(Process processedResource) {
        this.ruleFlows.put(processedResource.getId(), processedResource);
    }

    public Iterator<Process> iterator() {
        return this.getRuleFlows().values().iterator();
    }

    public void remove(String id) {
        this.ruleFlows.remove(id);
    }
}

