/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesBeliefSystem;
import org.drools.beliefs.bayes.BayesHardEvidence;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.Entry;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;

public class BayesBeliefSet
extends LinkedList
implements BeliefSet {
    private BayesBeliefSystem beliefSystem;
    private InternalFactHandle rootHandle;
    private int conflictCounter;

    public BayesBeliefSet(InternalFactHandle rootHandle, BayesBeliefSystem beliefSystem) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    public InternalFactHandle getFactHandle() {
        LinkedListNode node = this.getFirst();
        SimpleLogicalDependency ld = (SimpleLogicalDependency)((LinkedListEntry)node).getObject();
        return this.rootHandle;
    }

    public void add(LinkedListNode node) {
        SimpleLogicalDependency ld = (SimpleLogicalDependency)((LinkedListEntry)node).getObject();
        BayesHardEvidence evidence = (BayesHardEvidence)ld.getValue();
        if (!this.isEmpty()) {
            BayesHardEvidence firstEvidence = (BayesHardEvidence)((SimpleLogicalDependency)((LinkedListEntry)this.getFirst()).getObject()).getValue();
            if (!Arrays.equals(evidence.getDistribution(), firstEvidence.getDistribution())) {
                ++this.conflictCounter;
            }
        }
        super.addLast(node);
    }

    public void remove(LinkedListNode node) {
        boolean wasFirst = this.getFirst() == node;
        super.remove(node);
        if (this.isEmpty()) {
            this.conflictCounter = 0;
            return;
        }
        LogicalDependency ld = (LogicalDependency)((LinkedListEntry)node).getObject();
        BayesHardEvidence evidence = (BayesHardEvidence)ld.getValue();
        BayesHardEvidence firstEvidence = (BayesHardEvidence)((SimpleLogicalDependency)((LinkedListEntry)this.getFirst()).getObject()).getValue();
        if (wasFirst) {
            this.conflictCounter = 0;
            for (Entry entry = node.getNext(); entry != null; entry = entry.getNext()) {
                LogicalDependency currentDep = (LogicalDependency)((LinkedListEntry)entry).getObject();
                BayesHardEvidence currentEvidence = (BayesHardEvidence)((SimpleLogicalDependency)((LinkedListEntry)currentDep).getObject()).getValue();
                if (Arrays.equals(firstEvidence.getDistribution(), currentEvidence.getDistribution())) continue;
                ++this.conflictCounter;
            }
        } else if (!Arrays.equals(evidence.getDistribution(), firstEvidence.getDistribution())) {
            --this.conflictCounter;
        }
    }

    public void cancel(PropagationContext propagationContext) {
    }

    public void clear(PropagationContext propagationContext) {
    }

    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isNegated() {
        return false;
    }

    public boolean isUndecided() {
        return this.conflictCounter > 0;
    }

    public boolean isPositive() {
        return !this.isEmpty();
    }
}

