/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import org.drools.beliefs.bayes.BayesBeliefSet;
import org.drools.beliefs.bayes.BayesFact;
import org.drools.beliefs.bayes.BayesHardEvidence;
import org.drools.beliefs.bayes.BayesInstance;
import org.drools.beliefs.bayes.BayesLogicalDependency;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.PropertyReference;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.LinkedListNode;

public class BayesBeliefSystem
implements BeliefSystem {
    private NamedEntryPoint ep;
    private TruthMaintenanceSystem tms;

    public BayesBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.ep = ep;
        this.tms = tms;
    }

    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        boolean wasEmpty = beliefSet.isEmpty();
        boolean wasUndecided = beliefSet.isUndecided();
        beliefSet.add((LinkedListNode)node.getJustifierEntry());
        node = (LogicalDependency)((LinkedListEntry)beliefSet.getFirst()).getObject();
        BayesHardEvidence evidence = (BayesHardEvidence)node.getValue();
        PropertyReference propRef = (PropertyReference)node.getObject();
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        InternalFactHandle fh = beliefSet.getFactHandle();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        if (!wasUndecided && beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.setLikelyhood(var, null);
        } else {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
    }

    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        boolean wasUndecided = beliefSet.isUndecided();
        beliefSet.remove((LinkedListNode)node.getJustifierEntry());
        PropertyReference propRef = (PropertyReference)node.getObject();
        BayesFact bayesFact = (BayesFact)propRef.getInstance();
        BayesInstance bayesInstance = bayesFact.getBayesInstance();
        BayesVariable var = bayesInstance.getFieldNames().get(propRef.getName());
        boolean empty = beliefSet.isEmpty();
        if (empty) {
            bayesInstance.unsetLikelyhood(var);
            return;
        }
        node = (LogicalDependency)((LinkedListEntry)beliefSet.getFirst()).getObject();
        BayesHardEvidence evidence = (BayesHardEvidence)node.getValue();
        if (!wasUndecided && beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, false);
            bayesInstance.unsetLikelyhood(var);
        } else if (wasUndecided && !beliefSet.isUndecided()) {
            bayesInstance.setDecided(var, true);
            bayesInstance.setLikelyhood(var, evidence.getDistribution());
        }
    }

    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new BayesBeliefSet(fh, this);
    }

    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new BayesLogicalDependency(activation, beliefSet, object, value);
    }

    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
    }

    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return null;
    }
}

