/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.drools.beliefs.bayes.BayesVariable;
import org.drools.beliefs.bayes.EliminationCandidate;
import org.drools.beliefs.bayes.JunctionTree;
import org.drools.beliefs.bayes.JunctionTreeClique;
import org.drools.beliefs.bayes.JunctionTreeSeparator;
import org.drools.beliefs.bayes.OpenBitSet;
import org.drools.beliefs.bayes.SeparatorSet;
import org.drools.beliefs.graph.Edge;
import org.drools.beliefs.graph.Graph;
import org.drools.beliefs.graph.GraphNode;

public class JunctionTreeBuilder {
    private Graph<BayesVariable> graph;
    private boolean[][] adjacencyMatrix;

    public Graph<BayesVariable> getGraph() {
        return this.graph;
    }

    public JunctionTreeBuilder(Graph<BayesVariable> graph) {
        this.graph = graph;
        this.adjacencyMatrix = new boolean[graph.size()][graph.size()];
        for (GraphNode graphNode : graph) {
            for (Edge e1 : graphNode.getInEdges()) {
                GraphNode<BayesVariable> pV1 = graph.getNode(e1.getOutGraphNode().getId());
                JunctionTreeBuilder.connect(this.adjacencyMatrix, pV1.getId(), graphNode.getId());
            }
        }
    }

    public JunctionTree build() {
        return this.build(true);
    }

    public JunctionTree build(boolean init) {
        this.moralize();
        List<OpenBitSet> cliques = this.triangulate();
        return this.junctionTree(cliques, init);
    }

    public void moralize() {
        for (GraphNode graphNode : this.graph) {
            for (Edge e1 : graphNode.getInEdges()) {
                GraphNode<BayesVariable> pV1 = this.graph.getNode(e1.getOutGraphNode().getId());
                this.moralize(graphNode, pV1);
            }
        }
    }

    public void moralize(GraphNode<BayesVariable> v, GraphNode v1) {
        for (Edge e2 : v.getInEdges()) {
            GraphNode<BayesVariable> v2 = this.graph.getNode(e2.getOutGraphNode().getId());
            if (v1 == v2 || this.adjacencyMatrix[v1.getId()][v2.getId()]) continue;
            JunctionTreeBuilder.connect(this.getAdjacencyMatrix(), v1.getId(), v2.getId());
        }
    }

    public static void connect(boolean[][] adjMatrix, int v1, int v2) {
        adjMatrix[v1][v2] = true;
        adjMatrix[v2][v1] = true;
    }

    public static void disconnect(boolean[][] adjMatrix, int v1, int v2) {
        adjMatrix[v1][v2] = false;
        adjMatrix[v2][v1] = false;
    }

    public List<OpenBitSet> triangulate() {
        boolean[][] clonedAdjMatrix = JunctionTreeBuilder.cloneAdjacencyMarix(this.adjacencyMatrix);
        PriorityQueue<EliminationCandidate> p = new PriorityQueue<EliminationCandidate>(this.graph.size());
        HashMap<Integer, EliminationCandidate> elmVertMap = new HashMap<Integer, EliminationCandidate>();
        for (GraphNode graphNode : this.graph) {
            EliminationCandidate elmCandVert = new EliminationCandidate(this.graph, clonedAdjMatrix, graphNode);
            p.add(elmCandVert);
            elmVertMap.put(graphNode.getId(), elmCandVert);
        }
        ArrayList<OpenBitSet> cliques = new ArrayList<OpenBitSet>();
        while (!p.isEmpty()) {
            EliminationCandidate eliminationCandidate = (EliminationCandidate)p.remove();
            JunctionTreeBuilder.updateCliques(cliques, eliminationCandidate.getCliqueBitSit());
            HashSet<Integer> verticesToUpdate = new HashSet<Integer>();
            boolean[] adjList = clonedAdjMatrix[eliminationCandidate.getV().getId()];
            this.createClique(eliminationCandidate.getV().getId(), clonedAdjMatrix, verticesToUpdate, adjList);
            this.eliminateVertex(p, elmVertMap, clonedAdjMatrix, adjList, verticesToUpdate, eliminationCandidate);
        }
        return cliques;
    }

    public void eliminateVertex(PriorityQueue<EliminationCandidate> p, Map<Integer, EliminationCandidate> elmVertMap, boolean[][] clonedAdjMatrix, boolean[] adjList, Set<Integer> verticesToUpdate, EliminationCandidate v) {
        int id = v.getV().getId();
        for (int i = 0; i < adjList.length; ++i) {
            JunctionTreeBuilder.disconnect(clonedAdjMatrix, id, i);
        }
        for (Integer i : verticesToUpdate) {
            EliminationCandidate vertexToUpdate = elmVertMap.get(i);
            p.remove(vertexToUpdate);
            vertexToUpdate.update();
            p.add(vertexToUpdate);
        }
    }

    public void createClique(int v, boolean[][] clonedAdjMatrix, Set<Integer> verticesToUpdate, boolean[] adjList) {
        for (int i = 0; i < adjList.length; ++i) {
            if (!adjList[i]) continue;
            this.getRelatedVerticesToUpdate(v, clonedAdjMatrix, verticesToUpdate, i);
            boolean needsConnection = false;
            for (int j = i + 1; j < adjList.length; ++j) {
                if (!adjList[j] || clonedAdjMatrix[i][j]) continue;
                JunctionTreeBuilder.connect(this.adjacencyMatrix, i, j);
                JunctionTreeBuilder.connect(clonedAdjMatrix, i, j);
                this.getRelatedVerticesToUpdate(v, clonedAdjMatrix, verticesToUpdate, j);
                needsConnection = true;
            }
            if (!needsConnection) continue;
            verticesToUpdate.add(i);
        }
    }

    private void getRelatedVerticesToUpdate(int v, boolean[][] clonedAdjMatrix, Set<Integer> verticesToUpdate, int i) {
        verticesToUpdate.add(i);
        for (Integer k : JunctionTreeBuilder.getAdjacentVertices(clonedAdjMatrix, i)) {
            if (k == v) continue;
            verticesToUpdate.add(k);
        }
    }

    public static void updateCliques(List<OpenBitSet> cliques, OpenBitSet newClique) {
        boolean superSetFound = false;
        for (OpenBitSet existingCluster : cliques) {
            if (OpenBitSet.andNotCount(newClique, existingCluster) != 0L) continue;
            superSetFound = true;
            break;
        }
        if (!superSetFound) {
            cliques.add(newClique);
        }
    }

    public boolean[][] getAdjacencyMatrix() {
        return this.adjacencyMatrix;
    }

    public static boolean[][] cloneAdjacencyMarix(boolean[][] src) {
        int length = src.length;
        boolean[][] target = new boolean[length][src[0].length];
        for (int i = 0; i < length; ++i) {
            System.arraycopy(src[i], 0, target[i], 0, src[i].length);
        }
        return target;
    }

    public JunctionTree junctionTree(List<OpenBitSet> cliques, boolean init) {
        int i;
        ArrayList<SeparatorSet> list = new ArrayList<SeparatorSet>();
        for (int i2 = 0; i2 < cliques.size(); ++i2) {
            for (int j = i2 + 1; j < cliques.size(); ++j) {
                SeparatorSet separatorSet = new SeparatorSet(cliques.get(i2), i2, cliques.get(j), j, this.graph);
                if (separatorSet.getMass() <= 0) continue;
                list.add(separatorSet);
            }
        }
        list.addAll(list);
        Collections.sort(list);
        SeparatorSet[][][] sepGraphs = new SeparatorSet[cliques.size()][][];
        JunctionTreeClique[] jtNodes = new JunctionTreeClique[cliques.size()];
        JunctionTreeSeparator[] jtSeps = new JunctionTreeSeparator[cliques.size() - 1];
        OpenBitSet[] varNodeToCliques = new OpenBitSet[this.graph.size()];
        int length = cliques.size();
        for (i = 0; i < length; ++i) {
            JunctionTreeClique node;
            jtNodes[i] = node = new JunctionTreeClique(i, this.graph, cliques.get(i));
            sepGraphs[i] = new SeparatorSet[this.graph.size()][this.graph.size()];
            this.mapVarNodeToCliques(varNodeToCliques, i, cliques.get(i));
        }
        i = 0;
        int j = 0;
        int length2 = cliques.size() - 1;
        while (i < length2) {
            SeparatorSet separatorSet = (SeparatorSet)list.get(j++);
            JunctionTreeClique node1 = jtNodes[separatorSet.getId1()];
            JunctionTreeClique node2 = jtNodes[separatorSet.getId2()];
            if (sepGraphs[node1.getId()] == sepGraphs[node2.getId()]) continue;
            this.mergeGraphs(sepGraphs, separatorSet);
            ++i;
        }
        this.createJunctionTreeGraph(sepGraphs[0], jtNodes[0], jtNodes, jtSeps, 0);
        this.mapNodeToCliqueFamily(varNodeToCliques, jtNodes);
        return new JunctionTree(this.graph, jtNodes[0], jtNodes, jtSeps, init);
    }

    public void mergeGraphs(SeparatorSet[][][] graphs, SeparatorSet separatorSet) {
        SeparatorSet[][] srcGraph = graphs[separatorSet.getId1()];
        SeparatorSet[][] trgGraph = graphs[separatorSet.getId2()];
        for (int i = 0; i < srcGraph.length; ++i) {
            SeparatorSet[] row = srcGraph[i];
            for (int j = 0; j < row.length; ++j) {
                if (row[j] == null) continue;
                trgGraph[i][j] = row[j];
                graphs[j] = trgGraph;
            }
        }
        graphs[separatorSet.getId1()] = trgGraph;
        trgGraph[separatorSet.getId1()][separatorSet.getId2()] = separatorSet;
        trgGraph[separatorSet.getId2()][separatorSet.getId1()] = separatorSet;
    }

    public int createJunctionTreeGraph(SeparatorSet[][] sepGraph, JunctionTreeClique parent, JunctionTreeClique[] jtNodes, JunctionTreeSeparator[] jtSeps, int i) {
        SeparatorSet[] row = sepGraph[parent.getId()];
        for (int j = 0; j < row.length; ++j) {
            JunctionTreeSeparator sepNode;
            if (row[j] == null) continue;
            SeparatorSet separatorSet = row[j];
            JunctionTreeClique node1 = jtNodes[separatorSet.getId1()];
            JunctionTreeClique node2 = jtNodes[separatorSet.getId2()];
            JunctionTreeClique child = node1 != parent ? node1 : node2;
            jtSeps[sepNode.getId()] = sepNode = new JunctionTreeSeparator(i++, parent, child, separatorSet.getIntersection(), this.graph);
            sepGraph[separatorSet.getId1()][separatorSet.getId2()] = null;
            sepGraph[separatorSet.getId2()][separatorSet.getId1()] = null;
            this.createJunctionTreeGraph(sepGraph, child, jtNodes, jtSeps, i);
        }
        return i;
    }

    public void mapNodeToCliqueFamily(OpenBitSet[] varNodeToCliques, JunctionTreeClique[] jtNodes) {
        for (int i = 0; i < varNodeToCliques.length; ++i) {
            OpenBitSet cliques;
            GraphNode<BayesVariable> varNode = this.graph.getNode(i);
            OpenBitSet parents = new OpenBitSet();
            int count = 0;
            for (Edge edge : varNode.getInEdges()) {
                parents.set(edge.getOutGraphNode().getId());
                ++count;
            }
            if (count == 0) {
                // empty if block
            }
            if ((cliques = varNodeToCliques[i]) == null) {
                throw new IllegalStateException("Node exists, that is not part of a clique. " + varNode.toString());
            }
            int bestWeight = -1;
            int clique = -1;
            int j = cliques.nextSetBit(0);
            while (j >= 0) {
                JunctionTreeClique jtNode = jtNodes[j];
                if (!(count != 0 && OpenBitSet.andNotCount(parents, jtNode.getBitSet()) != 0L || clique != -1 && jtNode.getBitSet().cardinality() >= (long)bestWeight)) {
                    bestWeight = (int)jtNode.getBitSet().cardinality();
                    clique = j;
                }
                j = cliques.nextSetBit(j + 1);
            }
            if (clique == -1) {
                throw new IllegalStateException("No clique for node found." + varNode.toString());
            }
            varNode.getContent().setFamily(clique);
            jtNodes[clique].addToFamily(varNode.getContent());
        }
    }

    public void mapVarNodeToCliques(OpenBitSet[] nodeToCliques, int id, OpenBitSet clique) {
        int i = clique.nextSetBit(0);
        while (i >= 0) {
            OpenBitSet cliques = nodeToCliques[i];
            if (cliques == null) {
                nodeToCliques[i] = cliques = new OpenBitSet();
            }
            cliques.set(id);
            i = clique.nextSetBit(i + 1);
        }
    }

    public static List<Integer> getAdjacentVertices(boolean[][] adjacencyMatrix, int i) {
        ArrayList<Integer> list = new ArrayList<Integer>(adjacencyMatrix.length);
        for (int j = 0; j < adjacencyMatrix[i].length; ++j) {
            if (!adjacencyMatrix[i][j]) continue;
            list.add(j);
        }
        return list;
    }
}

