/*
 * Decompiled with CFR 0.152.
 */
package org.drools.beliefs.bayes;

import java.util.Arrays;
import org.drools.beliefs.bayes.BayesBeliefSystem;
import org.drools.beliefs.bayes.BayesHardEvidence;
import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;

public class BayesBeliefSet<M extends BayesHardEvidence<M>>
extends LinkedList<M>
implements BeliefSet<M> {
    private BayesBeliefSystem<M> beliefSystem;
    private InternalFactHandle rootHandle;
    private int conflictCounter;

    public BayesBeliefSet(InternalFactHandle rootHandle, BayesBeliefSystem<M> beliefSystem) {
        this.beliefSystem = beliefSystem;
        this.rootHandle = rootHandle;
    }

    public BeliefSystem<M> getBeliefSystem() {
        return this.beliefSystem;
    }

    public InternalFactHandle getFactHandle() {
        return this.rootHandle;
    }

    public void add(M mode) {
        M evidence = mode;
        if (!this.isEmpty()) {
            BayesHardEvidence firstEvidence = (BayesHardEvidence)this.getFirst();
            if (!Arrays.equals(((BayesHardEvidence)((Object)evidence)).getDistribution(), firstEvidence.getDistribution())) {
                ++this.conflictCounter;
            }
        }
        super.addLast(mode);
    }

    public void remove(M mode) {
        boolean wasFirst = this.getFirst() == mode;
        super.remove(mode);
        if (this.isEmpty()) {
            this.conflictCounter = 0;
            return;
        }
        BayesHardEvidence firstEvidence = (BayesHardEvidence)this.getFirst();
        if (wasFirst) {
            this.conflictCounter = 0;
            for (BayesHardEvidence currentEvidence = (BayesHardEvidence)mode.getNext(); currentEvidence != null; currentEvidence = (BayesHardEvidence)currentEvidence.getNext()) {
                if (Arrays.equals(firstEvidence.getDistribution(), currentEvidence.getDistribution())) continue;
                ++this.conflictCounter;
            }
        } else if (!Arrays.equals(((BayesHardEvidence)((Object)mode)).getDistribution(), firstEvidence.getDistribution())) {
            --this.conflictCounter;
        }
    }

    public void cancel(PropagationContext propagationContext) {
    }

    public void clear(PropagationContext propagationContext) {
    }

    public void setWorkingMemoryAction(WorkingMemoryAction wmAction) {
    }

    public boolean isNegated() {
        return false;
    }

    public boolean isUndecided() {
        return this.isConflicting();
    }

    public boolean isConflicting() {
        return this.conflictCounter > 0;
    }

    public boolean isPositive() {
        return !this.isEmpty();
    }
}

